/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.NoInputsModelAction;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.binary.internal.BinarySpecFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTypeModelRuleExtractor
extends TypeModelRuleExtractor<BinaryType, BinarySpec, BaseBinarySpec> {
    public BinaryTypeModelRuleExtractor(ModelSchemaStore schemaStore) {
        super("binary", BinarySpec.class, BaseBinarySpec.class, BinaryTypeBuilder.class, schemaStore, new TypeBuilderFactory<BinarySpec>(){

            @Override
            public TypeBuilderInternal<BinarySpec> create(ModelSchema<? extends BinarySpec> schema) {
                return new DefaultBinaryTypeBuilder(schema);
            }
        });
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends BinarySpec> type, TypeBuilderInternal<BinarySpec> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType implementation = this.determineImplementationType(type, builder);
        ModelAction registrationAction = this.createRegistrationAction(type, implementation, builder.getInternalViews(), ruleDefinition.getDescriptor());
        return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, registrationAction);
    }

    private <S extends BinarySpec> ModelAction createRegistrationAction(final ModelType<S> publicType, final ModelType<? extends BaseBinarySpec> implementationType, final Set<Class<?>> internalViews, final ModelRuleDescriptor descriptor) {
        return NoInputsModelAction.of((ModelReference)ModelReference.of(BinarySpecFactory.class), (ModelRuleDescriptor)descriptor, (Action)new Action<BinarySpecFactory>(){

            public void execute(BinarySpecFactory binaries) {
                binaries.register(publicType, implementationType, internalViews, descriptor);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultBinaryTypeBuilder
    extends AbstractTypeBuilder<BinarySpec>
    implements BinaryTypeBuilder<BinarySpec> {
        public DefaultBinaryTypeBuilder(ModelSchema<? extends BinarySpec> schema) {
            super(BinaryType.class, schema);
        }
    }
}

