/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.internal;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.SharedLibraryBinary;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.configure.NativeBinaryRules;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.test.NativeTestSuiteBinarySpec;
import org.gradle.nativeplatform.test.NativeTestSuiteSpec;
import org.gradle.nativeplatform.test.internal.NativeTestSuiteBinarySpecInternal;
import org.gradle.platform.base.ToolChain;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.test.TestSuiteContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTestSuites {
    public static void createNativeTestSuiteBinaries(TestSuiteContainer testSuites, Class<? extends NativeTestSuiteSpec> testSuiteClass, final Class<? extends NativeTestSuiteBinarySpec> testSuiteBinaryClass, final String typeString, final File buildDir, final ServiceRegistry serviceRegistry) {
        testSuites.withType(testSuiteClass).afterEach((Action)new Action<NativeTestSuiteSpec>(){

            public void execute(NativeTestSuiteSpec testSuite) {
                for (NativeBinarySpec testedBinary : NativeTestSuites.testedBinariesOf(testSuite)) {
                    if (testedBinary instanceof SharedLibraryBinary) continue;
                    NativeTestSuites.createNativeTestSuiteBinary(testSuite, testSuiteBinaryClass, typeString, testedBinary, buildDir, serviceRegistry);
                }
            }
        });
    }

    private static void createNativeTestSuiteBinary(NativeTestSuiteSpec testSuite, Class<? extends NativeTestSuiteBinarySpec> testSuiteBinaryClass, String typeString, final NativeBinarySpec testedBinary, final File buildDir, ServiceRegistry serviceRegistry) {
        final BinaryNamingScheme namingScheme = NativeTestSuites.namingSchemeFor(testSuite, (NativeBinarySpecInternal)testedBinary, typeString);
        final NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
        testSuite.getBinaries().create(namingScheme.getBinaryName(), testSuiteBinaryClass, (Action)new Action<NativeTestSuiteBinarySpec>(){

            public void execute(NativeTestSuiteBinarySpec binary) {
                NativeTestSuiteBinarySpecInternal testBinary = (NativeTestSuiteBinarySpecInternal)binary;
                testBinary.setTestedBinary((NativeBinarySpecInternal)testedBinary);
                testBinary.setNamingScheme(namingScheme);
                testBinary.setResolver(resolver);
                testBinary.setToolChain(testedBinary.getToolChain());
                testBinary.getExecutable().setToolChain((ToolChain)testedBinary.getToolChain());
                testBinary.getExecutable().setFile(NativeTestSuites.executableFileFor(testBinary, buildDir));
                testBinary.getInstallation().setDirectory(NativeTestSuites.installDir(testBinary, buildDir));
            }
        });
    }

    public static Collection<NativeBinarySpec> testedBinariesOf(NativeTestSuiteSpec testSuite) {
        return NativeTestSuites.testedBinariesWithType(NativeBinarySpec.class, testSuite);
    }

    public static <S> Collection<S> testedBinariesWithType(Class<S> type, NativeTestSuiteSpec testSuite) {
        return testSuite.getTestedComponent().getBinaries().withType(type).values();
    }

    private static File executableFileFor(NativeTestSuiteBinarySpecInternal testBinary, File buildDir) {
        return NativeBinaryRules.executableFileFor((NativeBinarySpecInternal)testBinary, (File)buildDir);
    }

    private static File installDir(NativeTestSuiteBinarySpecInternal testBinary, File buildDir) {
        return NativeBinaryRules.installationDirFor((NativeBinarySpecInternal)testBinary, (File)buildDir);
    }

    private static BinaryNamingScheme namingSchemeFor(NativeTestSuiteSpec testSuite, NativeBinarySpecInternal testedBinary, String typeString) {
        return testedBinary.getNamingScheme().withComponentName(testSuite.getBaseName()).withBinaryType(typeString).withRole("executable", true);
    }
}

