/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Named;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.tasks.Copy;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.JvmLibrarySpec;
import org.gradle.jvm.internal.DefaultJarBinarySpec;
import org.gradle.jvm.internal.DefaultJvmLibrarySpec;
import org.gradle.jvm.internal.JarBinaryRules;
import org.gradle.jvm.internal.JarBinarySpecInternal;
import org.gradle.jvm.internal.JarFile;
import org.gradle.jvm.internal.JavaPlatformResolver;
import org.gradle.jvm.internal.JvmLibrarySpecInternal;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.tasks.api.ApiJar;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolChainRegistry;
import org.gradle.language.base.internal.ProjectLayout;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmComponentPlugin
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;

    @Inject
    public JvmComponentPlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(ComponentSpec.class), JarBinaryRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @ComponentType
        public void register(ComponentTypeBuilder<JvmLibrarySpec> builder) {
            builder.defaultImplementation(DefaultJvmLibrarySpec.class);
            builder.internalView(JvmLibrarySpecInternal.class);
        }

        @BinaryType
        public void registerJar(BinaryTypeBuilder<JarBinarySpec> builder) {
            builder.defaultImplementation(DefaultJarBinarySpec.class);
            builder.internalView(JarBinarySpecInternal.class);
        }

        @Model
        public JavaToolChainRegistry javaToolChain(ServiceRegistry serviceRegistry) {
            JavaToolChainInternal toolChain = (JavaToolChainInternal)serviceRegistry.get(JavaToolChainInternal.class);
            return new DefaultJavaToolChainRegistry(toolChain);
        }

        @Model
        public ProjectLayout projectLayout(ProjectIdentifier projectIdentifier, @Path(value="buildDir") File buildDir) {
            return new ProjectLayout(projectIdentifier, buildDir);
        }

        @Mutate
        public void registerPlatformResolver(PlatformResolvers platformResolvers) {
            platformResolvers.register((PlatformResolver)new JavaPlatformResolver());
        }

        @ComponentBinaries
        public void createBinaries(ModelMap<JarBinarySpec> binaries, PlatformResolvers platforms, JvmLibrarySpecInternal jvmLibrary) {
            List<JavaPlatform> selectedPlatforms = this.resolvePlatforms(platforms, jvmLibrary);
            final Set<String> exportedPackages = Rules.exportedPackagesOf(jvmLibrary);
            final Collection<DependencySpec> apiDependencies = Rules.apiDependenciesOf(jvmLibrary);
            final Collection<DependencySpec> dependencies = Rules.componentDependenciesOf(jvmLibrary);
            for (final JavaPlatform platform : selectedPlatforms) {
                final BinaryNamingScheme namingScheme = this.namingSchemeFor(jvmLibrary, selectedPlatforms, platform);
                binaries.create(namingScheme.getBinaryName(), (Action)new Action<JarBinarySpec>(){

                    public void execute(JarBinarySpec jarBinarySpec) {
                        JarBinarySpecInternal jarBinary = (JarBinarySpecInternal)jarBinarySpec;
                        jarBinary.setNamingScheme(namingScheme);
                        jarBinary.setTargetPlatform(platform);
                        jarBinary.setExportedPackages(exportedPackages);
                        jarBinary.setApiDependencies(apiDependencies);
                        jarBinary.setDependencies(dependencies);
                    }
                });
            }
        }

        private List<JavaPlatform> resolvePlatforms(final PlatformResolvers platformResolver, JvmLibrarySpecInternal jvmLibrarySpec) {
            List<PlatformRequirement> targetPlatforms = jvmLibrarySpec.getTargetPlatforms();
            if (targetPlatforms.isEmpty()) {
                targetPlatforms = Collections.singletonList(DefaultPlatformRequirement.create((String)DefaultJavaPlatform.current().getName()));
            }
            return CollectionUtils.collect(targetPlatforms, (Transformer)new Transformer<JavaPlatform, PlatformRequirement>(){

                public JavaPlatform transform(PlatformRequirement platformRequirement) {
                    return (JavaPlatform)platformResolver.resolve(JavaPlatform.class, platformRequirement);
                }
            });
        }

        private static Set<String> exportedPackagesOf(JvmLibrarySpecInternal jvmLibrary) {
            return jvmLibrary.getApi().getExports();
        }

        private static Collection<DependencySpec> apiDependenciesOf(JvmLibrarySpecInternal jvmLibrary) {
            return jvmLibrary.getApi().getDependencies().getDependencies();
        }

        private static Collection<DependencySpec> componentDependenciesOf(JvmLibrarySpecInternal jvmLibrary) {
            return jvmLibrary.getDependencies().getDependencies();
        }

        private BinaryNamingScheme namingSchemeFor(JvmLibrarySpec jvmLibrary, List<JavaPlatform> selectedPlatforms, JavaPlatform platform) {
            return DefaultBinaryNamingScheme.component((String)jvmLibrary.getName()).withBinaryType("Jar").withRole("jar", true).withVariantDimension((Named)platform, selectedPlatforms);
        }

        @BinaryTasks
        public void createTasks(ModelMap<Task> tasks, final JarBinarySpecInternal binary, final @Path(value="buildDir") File buildDir) {
            final File runtimeClassesDir = binary.getClassesDir();
            final File resourcesDir = binary.getResourcesDir();
            final File runtimeJarDestDir = binary.getJarFile().getParentFile();
            final String runtimeJarArchiveName = binary.getJarFile().getName();
            final String createRuntimeJar = "create" + StringUtils.capitalize((String)binary.getProjectScopedName());
            tasks.create(createRuntimeJar, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription(String.format("Creates the binary file for %s.", binary));
                    jar.from(new Object[]{runtimeClassesDir});
                    jar.from(new Object[]{resourcesDir});
                    jar.setDestinationDir(runtimeJarDestDir);
                    jar.setArchiveName(runtimeJarArchiveName);
                }
            });
            final JarFile apiJar = binary.getApiJar();
            final Set<String> exportedPackages = binary.getExportedPackages();
            String apiJarTaskName = this.apiJarTaskName(binary);
            if (exportedPackages.isEmpty()) {
                tasks.create(apiJarTaskName, Copy.class, (Action)new Action<Copy>(){

                    public void execute(Copy copy) {
                        copy.setDescription(String.format("Creates the API binary file for %s.", binary));
                        copy.from(new Object[]{new File(runtimeJarDestDir, runtimeJarArchiveName)});
                        copy.setDestinationDir(apiJar.getFile().getParentFile());
                        copy.dependsOn(new Object[]{createRuntimeJar});
                        apiJar.setBuildTask((Task)copy);
                    }
                });
            } else {
                tasks.create(apiJarTaskName, ApiJar.class, (Action)new Action<ApiJar>(){

                    public void execute(ApiJar jar) {
                        File apiClassesDir = binary.getNamingScheme().getOutputDirectory(buildDir, "apiClasses");
                        jar.setDescription(String.format("Creates the API binary file for %s.", binary));
                        jar.setRuntimeClassesDir(runtimeClassesDir);
                        jar.setExportedPackages(exportedPackages);
                        jar.setApiClassesDir(apiClassesDir);
                        jar.setDestinationDir(apiJar.getFile().getParentFile());
                        jar.setArchiveName(apiJar.getFile().getName());
                        apiJar.setBuildTask((Task)jar);
                    }
                });
            }
        }

        private String apiJarTaskName(JarBinarySpecInternal binary) {
            String binaryName = binary.getProjectScopedName();
            String libName = binaryName.endsWith("Jar") ? binaryName.substring(0, binaryName.length() - 3) : binaryName;
            return libName + "ApiJar";
        }
    }
}

