/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Cast;
import org.gradle.model.Managed;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseInstanceFactory<T>
implements InstanceFactory<T> {
    private final String displayName;
    private final ModelType<T> baseInterface;
    private final ModelType<? extends T> baseImplementation;
    private final Map<ModelType<? extends T>, TypeRegistration<? extends T>> registrations = Maps.newLinkedHashMap();

    public BaseInstanceFactory(String displayName, Class<T> baseInterface, Class<? extends T> baseImplementation) {
        this.displayName = displayName;
        this.baseInterface = ModelType.of(baseInterface);
        this.baseImplementation = ModelType.of(baseImplementation);
    }

    @Override
    public ModelType<T> getBaseInterface() {
        return this.baseInterface;
    }

    @Override
    public <S extends T> InstanceFactory.TypeRegistrationBuilder<S> register(ModelType<S> publicType, ModelRuleDescriptor source) {
        TypeRegistration<S> registration = (TypeRegistration<S>)Cast.uncheckedCast(this.registrations.get(publicType));
        if (registration == null) {
            registration = new TypeRegistration<S>(publicType);
            this.registrations.put(publicType, registration);
        }
        return new TypeRegistrationBuilderImpl<S>(source, registration);
    }

    @Override
    public <S extends T> InstanceFactory.ImplementationInfo<T> getImplementationInfo(ModelType<S> publicType) {
        ImplementationRegistration<S> implementationRegistration = this.getImplementationRegistration(publicType);
        return new ImplementationInfoImpl<S>(publicType, implementationRegistration);
    }

    @Override
    public <S extends T> InstanceFactory.ImplementationInfo<T> getManagedSubtypeImplementationInfo(final ModelType<S> publicType) {
        if (!publicType.getConcreteClass().isAnnotationPresent(Managed.class)) {
            throw new IllegalArgumentException(String.format("Type '%s' is not managed", publicType));
        }
        final ArrayList implementationInfos = Lists.newArrayListWithCapacity((int)1);
        ModelSchemaUtils.walkTypeHierarchy(publicType.getConcreteClass(), new RegistrationHierarchyVisitor<S>(){

            @Override
            protected void visitRegistration(TypeRegistration<? extends T> registration) {
                if (registration != null && registration.implementationRegistration != null) {
                    implementationInfos.add(new ImplementationInfoImpl(publicType, registration.implementationRegistration));
                }
            }
        });
        if (implementationInfos.isEmpty()) {
            throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because it doesn't extend an interface with a default implementation", publicType));
        }
        return (InstanceFactory.ImplementationInfo)implementationInfos.get(0);
    }

    @Override
    public <S extends T> Set<ModelType<?>> getInternalViews(ModelType<S> publicType) {
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        ModelSchemaUtils.walkTypeHierarchy(publicType.getConcreteClass(), new RegistrationHierarchyVisitor<S>(){

            @Override
            protected void visitRegistration(TypeRegistration<? extends T> registration) {
                for (InternalViewRegistration internalViewRegistration : registration.internalViewRegistrations) {
                    builder.add(internalViewRegistration.getInternalView());
                }
            }
        });
        return builder.build();
    }

    @Override
    public Set<ModelType<? extends T>> getSupportedTypes() {
        return ImmutableSet.copyOf(this.registrations.keySet());
    }

    private String getSupportedTypeNames() {
        ArrayList names = Lists.newArrayList();
        for (ModelType<T> type : this.registrations.keySet()) {
            names.add(type.toString());
        }
        Collections.sort(names);
        return names.isEmpty() ? "(None)" : Joiner.on((String)", ").join((Iterable)names);
    }

    private <S extends T> TypeRegistration<S> getRegistration(ModelType<S> type) {
        return (TypeRegistration)Cast.uncheckedCast(this.registrations.get(type));
    }

    private <S extends T> ImplementationRegistration<S> getImplementationRegistration(ModelType<S> type) {
        TypeRegistration<S> registration = this.getRegistration(type);
        if (registration == null) {
            throw new IllegalArgumentException(String.format("Cannot create a '%s' because this type is not known to %s. Known types are: %s", type, this.displayName, this.getSupportedTypeNames()));
        }
        if (((TypeRegistration)registration).implementationRegistration == null) {
            throw new IllegalArgumentException(String.format("Cannot create a '%s' because this type does not have an implementation registered.", type));
        }
        return ((TypeRegistration)registration).implementationRegistration;
    }

    @Override
    public void validateRegistrations() {
        for (TypeRegistration<T> registration : this.registrations.values()) {
            registration.validate();
        }
    }

    public String toString() {
        return "[" + this.getSupportedTypeNames() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class RegistrationHierarchyVisitor<S>
    implements ModelSchemaUtils.TypeVisitor<S> {
        private RegistrationHierarchyVisitor() {
        }

        @Override
        public void visitType(Class<? super S> type) {
            if (!BaseInstanceFactory.this.baseInterface.getConcreteClass().isAssignableFrom(type)) {
                return;
            }
            Class superTypeClassAsBaseType = type.asSubclass(BaseInstanceFactory.this.baseInterface.getConcreteClass());
            ModelType superTypeAsBaseType = ModelType.of(superTypeClassAsBaseType);
            TypeRegistration registration = BaseInstanceFactory.this.getRegistration(superTypeAsBaseType);
            if (registration != null) {
                this.visitRegistration(registration);
            }
        }

        protected abstract void visitRegistration(TypeRegistration<? extends T> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementationInfoImpl<T>
    implements InstanceFactory.ImplementationInfo<T> {
        private final ModelType<? extends T> publicType;
        private final ImplementationRegistration<T> implementationRegistration;

        public ImplementationInfoImpl(ModelType<? extends T> publicType, ImplementationRegistration<? extends T> implementationRegistration) {
            this.publicType = publicType;
            this.implementationRegistration = (ImplementationRegistration)Cast.uncheckedCast(implementationRegistration);
        }

        @Override
        public T create(MutableModelNode modelNode) {
            return ((ImplementationRegistration)this.implementationRegistration).factory.create(this.publicType, modelNode.getPath().getName(), modelNode);
        }

        @Override
        public ModelType<? extends T> getDelegateType() {
            return (ModelType)Cast.uncheckedCast((Object)((ImplementationRegistration)this.implementationRegistration).implementationType);
        }

        public String toString() {
            return String.valueOf(this.publicType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalViewRegistration<T> {
        private final ModelRuleDescriptor source;
        private final ModelType<T> internalView;

        private InternalViewRegistration(ModelRuleDescriptor source, ModelType<T> internalView) {
            this.source = source;
            this.internalView = internalView;
        }

        public ModelRuleDescriptor getSource() {
            return this.source;
        }

        public ModelType<T> getInternalView() {
            return this.internalView;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImplementationRegistration<S> {
        private final ModelRuleDescriptor source;
        private final ModelType<? extends S> implementationType;
        private final InstanceFactory.ImplementationFactory<S> factory;

        private ImplementationRegistration(ModelRuleDescriptor source, ModelType<? extends S> implementationType, InstanceFactory.ImplementationFactory<S> factory) {
            this.source = source;
            this.implementationType = implementationType;
            this.factory = factory;
        }

        public ModelRuleDescriptor getSource() {
            return this.source;
        }

        public ModelType<? extends S> getImplementationType() {
            return this.implementationType;
        }

        public InstanceFactory.ImplementationFactory<? extends S> getFactory() {
            return this.factory;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeRegistration<S extends T> {
        private final ModelType<S> publicType;
        private final boolean managedPublicType;
        private ImplementationRegistration<S> implementationRegistration;
        private final List<InternalViewRegistration<?>> internalViewRegistrations = Lists.newArrayList();

        public TypeRegistration(ModelType<S> publicType) {
            this.publicType = publicType;
            this.managedPublicType = publicType.getConcreteClass().isAnnotationPresent(Managed.class);
        }

        public void setImplementation(ModelType<? extends S> implementationType, ModelRuleDescriptor source, InstanceFactory.ImplementationFactory<S> factory) {
            if (this.implementationRegistration != null) {
                throw new IllegalStateException(String.format("Cannot register implementation for type '%s' because an implementation for this type was already registered by %s", this.publicType, this.implementationRegistration.getSource()));
            }
            if (this.managedPublicType) {
                throw new IllegalArgumentException(String.format("Cannot specify default implementation for managed type '%s'", this.publicType));
            }
            if (!BaseInstanceFactory.this.baseInterface.isAssignableFrom(implementationType)) {
                throw new IllegalArgumentException(String.format("Implementation type '%s' registered for '%s' must extend '%s'", implementationType, this.publicType, BaseInstanceFactory.this.baseImplementation));
            }
            if (Modifier.isAbstract(implementationType.getConcreteClass().getModifiers())) {
                throw new IllegalArgumentException(String.format("Implementation type '%s' registered for '%s' must not be abstract", implementationType, this.publicType));
            }
            try {
                implementationType.getConcreteClass().getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(String.format("Implementation type '%s' registered for '%s' must have a public default constructor", implementationType, this.publicType));
            }
            this.implementationRegistration = new ImplementationRegistration(source, implementationType, factory);
        }

        public <V> void addInternalView(ModelType<V> internalView, ModelRuleDescriptor source) {
            if (!internalView.getConcreteClass().isInterface()) {
                throw new IllegalArgumentException(String.format("Internal view '%s' registered for '%s' must be an interface", internalView, this.publicType));
            }
            boolean managedInternalView = internalView.getConcreteClass().isAnnotationPresent(Managed.class);
            if (this.managedPublicType && !managedInternalView) {
                throw new IllegalArgumentException(String.format("Internal view '%s' registered for managed type '%s' must be managed", internalView, this.publicType));
            }
            this.internalViewRegistrations.add(new InternalViewRegistration(source, internalView));
        }

        public void validate() {
            if (this.managedPublicType) {
                this.validateManaged();
            } else {
                this.validateUnmanaged();
            }
        }

        private void validateManaged() {
            InstanceFactory.ImplementationInfo implementationInfo = BaseInstanceFactory.this.getManagedSubtypeImplementationInfo(this.publicType);
            ModelType delegateType = implementationInfo.getDelegateType();
            for (InternalViewRegistration<?> internalViewRegistration : this.internalViewRegistrations) {
                this.validateManagedInternalView(internalViewRegistration, delegateType);
            }
        }

        private <V> void validateManagedInternalView(final InternalViewRegistration<V> internalViewRegistration, final ModelType<? extends T> delegateType) {
            ModelSchemaUtils.walkTypeHierarchy(internalViewRegistration.getInternalView().getConcreteClass(), new ModelSchemaUtils.TypeVisitor<V>(){

                @Override
                public void visitType(Class<? super V> type) {
                    if (!type.isAnnotationPresent(Managed.class) && !type.isAssignableFrom(delegateType.getConcreteClass())) {
                        throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because the default implementation type '%s' does not implement unmanaged internal view '%s', internal view was registered by %s", TypeRegistration.this.publicType, delegateType, type.getName(), internalViewRegistration.getSource()));
                    }
                }
            });
        }

        private void validateUnmanaged() {
            if (this.implementationRegistration == null) {
                throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because no implementation was registered", this.publicType));
            }
            ModelType<S> implementationType = this.implementationRegistration.getImplementationType();
            for (InternalViewRegistration<?> internalViewRegistration : this.internalViewRegistrations) {
                ModelType<S> internalView = internalViewRegistration.getInternalView();
                if (internalView.getConcreteClass().isAnnotationPresent(Managed.class) || internalView.isAssignableFrom(implementationType)) continue;
                throw new IllegalStateException(String.format("Factory registration for '%s' is invalid because the implementation type '%s' does not implement internal view '%s', implementation type was registered by %s, internal view was registered by %s", this.publicType, implementationType, internalView, this.implementationRegistration.getSource(), internalViewRegistration.getSource()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeRegistrationBuilderImpl<S extends T>
    implements InstanceFactory.TypeRegistrationBuilder<S> {
        private final ModelRuleDescriptor source;
        private final TypeRegistration<S> registration;

        public TypeRegistrationBuilderImpl(ModelRuleDescriptor source, TypeRegistration<S> registration) {
            this.source = source;
            this.registration = registration;
        }

        @Override
        public InstanceFactory.TypeRegistrationBuilder<S> withImplementation(ModelType<? extends S> implementationType, InstanceFactory.ImplementationFactory<S> factory) {
            this.registration.setImplementation(implementationType, this.source, factory);
            return this;
        }

        @Override
        public InstanceFactory.TypeRegistrationBuilder<S> withInternalView(ModelType<?> internalView) {
            this.registration.addInternalView(internalView, this.source);
            return this;
        }
    }
}

