/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.List;
import org.gradle.internal.BiAction;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.model.internal.core.DirectNodeInputUsingModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractManagedModelInitializer;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.ManagedImplStructSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelInitializer<T>
extends AbstractManagedModelInitializer<T> {
    public ManagedModelInitializer(ManagedImplStructSchema<T> modelSchema) {
        super(modelSchema);
    }

    @Override
    public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
        return ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, (Object)DirectNodeInputUsingModelAction.of(subject, descriptor, Arrays.asList(ModelReference.of(ManagedProxyFactory.class), ModelReference.of(TypeConverter.class)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode mutableModelNode, List<ModelView<?>> modelViews) {
                ManagedProxyFactory proxyFactory = ModelViews.getInstance(modelViews.get(0), ManagedProxyFactory.class);
                TypeConverter typeConverter = ModelViews.getInstance(modelViews, 1, TypeConverter.class);
                mutableModelNode.addProjection(new ManagedModelProjection(ManagedModelInitializer.this.schema, null, proxyFactory, typeConverter));
            }
        })).put((Object)ModelActionRole.Create, (Object)DirectNodeInputUsingModelAction.of(subject, descriptor, Arrays.asList(ModelReference.of(NodeInitializerRegistry.class), ModelReference.of(ManagedProxyFactory.class), ModelReference.of(TypeConverter.class)), new BiAction<MutableModelNode, List<ModelView<?>>>(){

            public void execute(MutableModelNode modelNode, List<ModelView<?>> modelViews) {
                NodeInitializerRegistry nodeInitializerRegistry = ModelViews.getInstance(modelViews, 0, NodeInitializerRegistry.class);
                ManagedProxyFactory proxyFactory = ModelViews.getInstance(modelViews, 1, ManagedProxyFactory.class);
                TypeConverter typeConverter = ModelViews.getInstance(modelViews, 2, TypeConverter.class);
                ManagedModelInitializer.this.addPropertyLinks(modelNode, nodeInitializerRegistry, proxyFactory, ManagedModelInitializer.this.schema.getProperties(), typeConverter);
            }
        })).build();
    }
}

