/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.Actions;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelSchemaExtractionContext<T>
implements ModelSchemaExtractionContext<T> {
    private final DefaultModelSchemaExtractionContext<?> parent;
    private final ModelType<T> type;
    private final String description;
    private final List<Action<? super ModelSchema<T>>> validators;
    private ModelSchema<T> result;
    private final List<DefaultModelSchemaExtractionContext<?>> children = Lists.newArrayList();

    private DefaultModelSchemaExtractionContext(DefaultModelSchemaExtractionContext<?> parent, ModelType<T> type, String description, Action<? super ModelSchema<T>> validator) {
        this.parent = parent;
        this.type = type;
        this.description = description;
        this.validators = Lists.newArrayListWithCapacity((int)2);
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public static <T> DefaultModelSchemaExtractionContext<T> root(ModelType<T> type) {
        return new DefaultModelSchemaExtractionContext<T>(null, type, null, null);
    }

    @Nullable
    public DefaultModelSchemaExtractionContext<?> getParent() {
        return this.parent;
    }

    @Override
    public ModelType<T> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description == null ? this.type.toString() : String.format("%s (%s)", this.description, this.type);
    }

    public List<DefaultModelSchemaExtractionContext<?>> getChildren() {
        return this.children;
    }

    @Override
    public <C> DefaultModelSchemaExtractionContext<C> child(ModelType<C> type, String description) {
        return this.child((ModelType)type, description, Actions.doNothing());
    }

    @Override
    public <C> DefaultModelSchemaExtractionContext<C> child(ModelType<C> type, String description, Action<? super ModelSchema<C>> validator) {
        DefaultModelSchemaExtractionContext<C> childContext = new DefaultModelSchemaExtractionContext<C>(this, type, description, validator);
        this.children.add(childContext);
        return childContext;
    }

    @Nullable
    public ModelSchema<T> getResult() {
        return this.result;
    }

    @Override
    public void found(ModelSchema<T> result) {
        this.result = result;
    }

    public void validate(ModelSchema<T> schema) {
        for (Action<? super ModelSchema<T>> action : this.validators) {
            action.execute(schema);
        }
    }

    public void addValidator(Action<? super ModelSchema<T>> validator) {
        this.validators.add(validator);
    }
}

