/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableSet;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.FactoryBasedNodeInitializer;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedNodeInitializerExtractionStrategy<T>
implements NodeInitializerExtractionStrategy {
    protected final InstanceFactory<T> instanceFactory;

    public FactoryBasedNodeInitializerExtractionStrategy(InstanceFactory<T> instanceFactory) {
        this.instanceFactory = instanceFactory;
    }

    public <S> NodeInitializer extractNodeInitializer(ModelSchema<S> schema) {
        if (!this.instanceFactory.getBaseInterface().isAssignableFrom(schema.getType())) {
            return null;
        }
        return this.getNodeInitializer((ModelSchema)Cast.uncheckedCast(schema));
    }

    private <S extends T> NodeInitializer getNodeInitializer(ModelSchema<S> schema) {
        StructSchema managedSchema = (StructSchema)Cast.uncheckedCast(schema);
        return new FactoryBasedNodeInitializer(this.instanceFactory, managedSchema);
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableSet.copyOf(this.instanceFactory.getSupportedTypes());
    }
}

