/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.internal.reflect.MethodDescription;
import org.gradle.model.Managed;
import org.gradle.model.Unmanaged;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ManagedImplSchema;
import org.gradle.model.internal.manage.schema.ManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ScalarCollectionSchema;
import org.gradle.model.internal.manage.schema.ScalarValueSchema;
import org.gradle.model.internal.manage.schema.extract.CandidateMethods;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.MethodType;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.model.internal.manage.schema.extract.StructSchemaExtractionStrategySupport;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedImplStructStrategy
extends StructSchemaExtractionStrategySupport {
    protected ManagedImplStructStrategy(ModelSchemaAspectExtractor aspectExtractor) {
        super(aspectExtractor);
    }

    @Override
    protected boolean isTarget(ModelType<?> type) {
        return type.getRawClass().isAnnotationPresent(Managed.class);
    }

    @Override
    protected <R> void validateTypeHierarchy(final ModelSchemaExtractionContext<R> extractionContext, ModelType<R> type) {
        ModelSchemaUtils.walkTypeHierarchy(type.getConcreteClass(), new ModelSchemaUtils.TypeVisitor<R>(){

            @Override
            public void visitType(Class<? super R> type) {
                if (type.isAnnotationPresent(Managed.class)) {
                    ManagedImplStructStrategy.this.validateManagedType(extractionContext, type);
                }
            }
        });
    }

    private void validateManagedType(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        if (!typeClass.isInterface() && !Modifier.isAbstract(typeClass.getModifiers())) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "must be defined as an interface or an abstract class.");
        }
        if (typeClass.getTypeParameters().length > 0) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "cannot be a parameterized type.");
        }
        Constructor<?> customConstructor = this.findCustomConstructor(typeClass);
        if (customConstructor != null) {
            throw this.invalidMethod(extractionContext, "custom constructors are not allowed", customConstructor);
        }
        this.ensureNoInstanceScopedFields(extractionContext, typeClass);
        this.ensureNoProtectedOrPrivateMethods(extractionContext, typeClass);
    }

    private Constructor<?> findCustomConstructor(Class<?> typeClass) {
        Constructor<?> customSuperConstructor;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && (customSuperConstructor = this.findCustomConstructor(typeClass.getSuperclass())) != null) {
            return customSuperConstructor;
        }
        Constructor<?>[] constructors = typeClass.getConstructors();
        if (constructors.length == 0 || constructors.length == 1 && constructors[0].getParameterTypes().length == 0) {
            return null;
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length <= 0) continue;
            return constructor;
        }
        throw new RuntimeException(String.format("Expected a constructor taking at least one argument in %s but no such constructors were found", typeClass.getName()));
    }

    private void ensureNoInstanceScopedFields(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        List<Field> declaredFields;
        Iterable instanceScopedFields;
        ImmutableSortedSet sortedDescriptions;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.ensureNoInstanceScopedFields(extractionContext, superClass);
        }
        if (!(sortedDescriptions = ImmutableSortedSet.copyOf((Iterable)Iterables.transform((Iterable)(instanceScopedFields = Iterables.filter(declaredFields = Arrays.asList(typeClass.getDeclaredFields()), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("metaClass");
            }
        })), (Function)new Function<Field, String>(){

            public String apply(Field field) {
                return field.toString();
            }
        }))).isEmpty()) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "instance scoped fields are not allowed (found fields: " + Joiner.on((String)", ").join((Iterable)sortedDescriptions) + ").");
        }
    }

    private void ensureNoProtectedOrPrivateMethods(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        Iterable protectedAndPrivateMethods;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.ensureNoProtectedOrPrivateMethods(extractionContext, superClass);
        }
        if (!Iterables.isEmpty((Iterable)(protectedAndPrivateMethods = Iterables.filter(Arrays.asList(typeClass.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                int modifiers = method.getModifiers();
                return !method.isSynthetic() && (Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers));
            }
        })))) {
            throw this.invalidMethods(extractionContext, "protected and private methods are not allowed", protectedAndPrivateMethods);
        }
    }

    @Override
    protected void validateMethodDeclarationHierarchy(ModelSchemaExtractionContext<?> context, CandidateMethods candidateMethods) {
        for (String methodName : candidateMethods.methodNames()) {
            Map<Equivalence.Wrapper<Method>, Collection<Method>> overloaded;
            Map<Equivalence.Wrapper<Method>, Collection<Method>> overridden;
            ArrayList handledOverridden = Lists.newArrayList();
            if (!MethodType.isPropertyMethodName(methodName) && !(overridden = candidateMethods.overriddenMethodsNamed(methodName)).isEmpty()) {
                this.handleOverriddenMethods(context, overridden.values());
                handledOverridden.addAll(overridden.keySet());
            }
            if ((overloaded = candidateMethods.overloadedMethodsNamed(methodName, handledOverridden)).isEmpty()) continue;
            this.handleOverloadedMethods(context, Iterables.concat(overloaded.values()));
        }
    }

    private void handleOverriddenMethods(ModelSchemaExtractionContext<?> extractionContext, Iterable<Collection<Method>> overriddenMethods) {
        ImmutableSet.Builder rejectedBuilder = ImmutableSet.builder();
        for (Collection<Method> methods : overriddenMethods) {
            if (methods.size() > 1 && !ModelSchemaUtils.isMethodDeclaredInManagedType((Method)Iterables.getLast(methods))) continue;
            rejectedBuilder.addAll(methods);
        }
        ImmutableSet rejectedOverrides = rejectedBuilder.build();
        if (!rejectedOverrides.isEmpty() && ModelSchemaUtils.isMethodDeclaredInManagedType((Iterable<Method>)rejectedOverrides)) {
            throw this.invalidMethods(extractionContext, "overridden methods not supported", (Iterable<Method>)rejectedOverrides);
        }
    }

    private void handleOverloadedMethods(ModelSchemaExtractionContext<?> extractionContext, Iterable<Method> overloadedMethods) {
        if (ModelSchemaUtils.isMethodDeclaredInManagedType(overloadedMethods)) {
            throw this.invalidMethods(extractionContext, "overloaded methods are not supported", overloadedMethods);
        }
    }

    @Override
    protected void handleNonPropertyMethod(ModelSchemaExtractionContext<?> context, Collection<Method> nonPropertyMethodsWithEqualSignature) {
        Method mostSpecificMethod = ModelSchemaUtils.findMostSpecificMethod(nonPropertyMethodsWithEqualSignature);
        if (ModelSchemaUtils.isMethodDeclaredInManagedType(mostSpecificMethod)) {
            String methodName = mostSpecificMethod.getName();
            if (MethodType.isGetterName(methodName) && !MethodType.takesNoParameter(mostSpecificMethod)) {
                throw this.invalidMethods(context, "getter methods cannot take parameters", nonPropertyMethodsWithEqualSignature);
            }
            if (MethodType.isSetterName(methodName)) {
                if (!MethodType.hasVoidReturnType(mostSpecificMethod)) {
                    throw this.invalidMethods(context, "setter method must have void return type", nonPropertyMethodsWithEqualSignature);
                }
                if (!MethodType.takesSingleParameter(mostSpecificMethod)) {
                    throw this.invalidMethods(context, "setter method must have exactly one parameter", nonPropertyMethodsWithEqualSignature);
                }
            }
            if (nonPropertyMethodsWithEqualSignature.size() > 1 && !ModelSchemaUtils.isMethodDeclaredInManagedType((Method)Iterables.getLast(nonPropertyMethodsWithEqualSignature))) {
                return;
            }
            throw this.invalidMethods(context, "only paired getter/setter methods are supported", nonPropertyMethodsWithEqualSignature);
        }
    }

    @Override
    protected boolean selectProperty(ModelSchemaExtractionContext<?> context, ModelPropertyExtractionContext property) {
        return true;
    }

    @Override
    protected void handleInvalidGetter(ModelSchemaExtractionContext<?> extractionContext, Method getter, String message) {
        if (ModelSchemaUtils.isMethodDeclaredInManagedType(getter)) {
            throw this.invalidMethod(extractionContext, message, getter);
        }
    }

    @Override
    protected void validateProperty(ModelSchemaExtractionContext<?> context, ModelPropertyExtractionContext property) {
        PropertyAccessorExtractionContext mergedGetter = property.mergeGetters();
        PropertyAccessorExtractionContext setter = property.getSetter();
        if (setter != null) {
            ModelType setterType;
            Method mostSpecificSetter = setter.getMostSpecificDeclaration();
            if (mergedGetter == null) {
                throw this.invalidMethods(context, "only paired getter/setter methods are supported", setter.getDeclaringMethods());
            }
            if (setter.isDeclaredAsAbstract() && !mergedGetter.isDeclaredAsAbstract()) {
                throw this.invalidMethod(context, "setters are not allowed for non-abstract getters", mostSpecificSetter);
            }
            if (mostSpecificSetter.getName().equals("setName") && Named.class.isAssignableFrom(context.getType().getRawClass())) {
                throw new InvalidManagedModelElementTypeException(context, String.format("@Managed types implementing %s must not declare a setter for the name property", Named.class.getName()));
            }
            if (mergedGetter.isDeclaredInManagedType() && !setter.isDeclaredInManagedType()) {
                throw this.invalidMethods(context, "unmanaged setter for managed getter", mergedGetter.getDeclaringMethods());
            }
            if (!mergedGetter.isDeclaredInManagedType() && setter.isDeclaredInManagedType()) {
                throw this.invalidMethods(context, "managed setter for unmanaged getter", mergedGetter.getDeclaringMethods());
            }
            if (!setter.isDeclaredInManagedType()) {
                return;
            }
            if (!Modifier.isAbstract(mostSpecificSetter.getModifiers())) {
                throw this.invalidMethod(context, "non-abstract setters are not allowed", mostSpecificSetter);
            }
            ModelType propertyType = ModelType.returnType(mergedGetter.getMostSpecificDeclaration());
            if (!propertyType.equals(setterType = ModelType.paramType(mostSpecificSetter, 0))) {
                String message = "setter method param must be of exactly the same type as the getter returns (expected: " + propertyType + ", found: " + setterType + ")";
                throw this.invalidMethod(context, message, mostSpecificSetter);
            }
        }
    }

    @Override
    protected ModelProperty.StateManagementType determineStateManagementType(ModelSchemaExtractionContext<?> extractionContext, PropertyAccessorExtractionContext getterContext) {
        if (getterContext.getMostSpecificDeclaration().getName().equals("getName") && Named.class.isAssignableFrom(extractionContext.getType().getRawClass())) {
            return ModelProperty.StateManagementType.MANAGED;
        }
        if (getterContext.isDeclaredInManagedType()) {
            if (getterContext.isDeclaredAsAbstract()) {
                return ModelProperty.StateManagementType.MANAGED;
            }
            return ModelProperty.StateManagementType.UNMANAGED;
        }
        return ModelProperty.StateManagementType.UNMANAGED;
    }

    @Override
    protected <P> Action<ModelSchema<P>> createPropertyValidator(final ModelSchemaExtractionContext<?> parentContext, final ModelPropertyExtractionResult<P> propertyResult) {
        return new Action<ModelSchema<P>>(){

            public void execute(ModelSchema<P> propertySchema) {
                ModelProperty property = propertyResult.getProperty();
                if (!property.getStateManagementType().equals((Object)ModelProperty.StateManagementType.MANAGED)) {
                    return;
                }
                if (property.getName().equals("name") && Named.class.isAssignableFrom(parentContext.getType().getRawClass())) {
                    return;
                }
                boolean isAllowedPropertyTypeOfManagedType = propertySchema instanceof ManagedImplSchema || propertySchema instanceof ScalarValueSchema;
                boolean isDeclaredAsHavingUnmanagedType = propertyResult.getGetter().isAnnotationPresent(Unmanaged.class);
                if (isAllowedPropertyTypeOfManagedType && isDeclaredAsHavingUnmanagedType) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("property '%s' is marked as @Unmanaged, but is of @Managed type '%s'. Please remove the @Managed annotation.%n", property.getName(), property.getType()));
                }
                if (!property.isWritable() && isDeclaredAsHavingUnmanagedType) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("unmanaged property '%s' cannot be read only, unmanaged properties must have setters", property.getName()));
                }
                if (propertySchema instanceof CollectionSchema && !(propertySchema instanceof ScalarCollectionSchema) && property.isWritable()) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("property '%s' cannot have a setter (%s properties must be read only).", property.getName(), property.getType().toString()));
                }
            }
        };
    }

    protected <R> ManagedImplStructSchema<R> createSchema(ModelSchemaExtractionContext<R> extractionContext, Iterable<ModelPropertyExtractionResult<?>> propertyResults, Iterable<ModelSchemaAspect> aspects) {
        ModelType<R> type = extractionContext.getType();
        Iterable properties = Iterables.transform(propertyResults, (Function)new Function<ModelPropertyExtractionResult<?>, ModelProperty<?>>(){

            public ModelProperty<?> apply(ModelPropertyExtractionResult<?> propertyResult) {
                return propertyResult.getProperty();
            }
        });
        return new ManagedImplStructSchema<R>(type, properties, aspects);
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, Method method) {
        return this.invalidMethod(extractionContext, message, MethodDescription.of((Method)method));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, Constructor<?> constructor) {
        return this.invalidMethod(extractionContext, message, MethodDescription.of(constructor));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, MethodDescription methodDescription) {
        return new InvalidManagedModelElementTypeException(extractionContext, message + " (invalid method: " + methodDescription.toString() + ").");
    }

    private InvalidManagedModelElementTypeException invalidMethods(ModelSchemaExtractionContext<?> extractionContext, String message, Iterable<Method> methods) {
        ImmutableSortedSet descriptions = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(methods, (Function)new Function<Method, String>(){

            public String apply(Method method) {
                return MethodDescription.of((Method)method).toString();
            }
        }));
        return new InvalidManagedModelElementTypeException(extractionContext, message + " (invalid methods: " + Joiner.on((String)", ").join((Iterable)descriptions) + ").");
    }
}

