/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.favorites.FavoriteTask;
import org.gradle.gradleplugin.foundation.favorites.FavoritesEditor;
import org.gradle.gradleplugin.foundation.settings.SettingsNode;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingEditFavoriteInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingExportInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingImportInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;
import org.gradle.gradleplugin.userinterface.swing.generic.tabs.GradleTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoriteTasksTab
implements GradleTab,
GradlePluginLord.GeneralPluginObserver,
FavoritesEditor.FavoriteTasksObserver {
    private GradlePluginLord gradlePluginLord;
    private FavoritesEditor favoritesEditor;
    private SettingsNode settingsNode;
    private JPanel mainPanel;
    private DefaultListModel model;
    private JList list;
    private JPopupMenu popupMenu;
    private JMenuItem executeMenuItem;
    private JMenuItem editMenuItem;
    private JMenuItem removeFavoritesMenuItem;
    private JMenuItem copyFavoritesMenuItem;
    private JButton executeButton;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton importButton;
    private JButton exportButton;

    public FavoriteTasksTab(GradlePluginLord gradlePluginLord, SettingsNode settingsNode) {
        this.gradlePluginLord = gradlePluginLord;
        this.settingsNode = settingsNode;
        this.favoritesEditor = gradlePluginLord.getFavoritesEditor();
        gradlePluginLord.addGeneralPluginObserver(this, true);
        this.favoritesEditor.addFavoriteTasksObserver(this, true);
        this.favoritesEditor.serializeIn(settingsNode);
    }

    @Override
    public String getName() {
        return "Favorites";
    }

    @Override
    public Component createComponent() {
        this.setupUI();
        this.enableThingsAppropriately();
        return this.mainPanel;
    }

    @Override
    public void aboutToShow() {
        this.populate();
    }

    private void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(this.createButtonPanel(), "North");
        this.mainPanel.add(this.createListPanel(), "Center");
        this.setupPopupMenu();
    }

    private Component createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.executeButton = Utility.createButton(this.getClass(), "execute.png", "Execute the selected command", new AbstractAction("Execute"){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.executeSelectedTasks();
            }
        });
        this.addButton = Utility.createButton(this.getClass(), "add.png", "Adds a new favorite gradle command", new AbstractAction("Add..."){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.addTask();
            }
        });
        this.editButton = Utility.createButton(this.getClass(), "edit.png", "Edit the selected favorite", new AbstractAction("Edit..."){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.editTask();
            }
        });
        this.removeButton = Utility.createButton(this.getClass(), "remove.png", "Delete the selected favorite", new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.removeSelectedFavorites();
            }
        });
        this.moveUpButton = Utility.createButton(this.getClass(), "move-up.png", "Moves the selected favorites up", new AbstractAction("Move Up"){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.favoritesEditor.moveFavoritesBefore(FavoriteTasksTab.this.getSelectedFavoriteTasks());
            }
        });
        this.moveDownButton = Utility.createButton(this.getClass(), "move-down.png", "Moves the selected favorites down", new AbstractAction("Move Down"){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.favoritesEditor.moveFavoritesAfter(FavoriteTasksTab.this.getSelectedFavoriteTasks());
            }
        });
        this.importButton = Utility.createButton(this.getClass(), "import.png", "Imports current favorite settings", new AbstractAction("Import..."){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.importFavorites();
            }
        });
        this.exportButton = Utility.createButton(this.getClass(), "export.png", "Exports current favorite settings", new AbstractAction("Export..."){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.exportFavorites();
            }
        });
        panel.add(this.executeButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.addButton);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.editButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.removeButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.moveUpButton);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.moveDownButton);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.importButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(this.exportButton);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    private Component createListPanel() {
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FavoriteTasksTab.this.executeSelectedTasks();
                } else if (e.getButton() == 3) {
                    FavoriteTasksTab.this.handleRightClick(e);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FavoriteTasksTab.this.enableThingsAppropriately();
                }
            }
        });
        this.list.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.executeSelectedTasks();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        return new JScrollPane(this.list);
    }

    private void populate() {
        this.model.clear();
        for (FavoriteTask favoriteTask : this.favoritesEditor.getFavoriteTasks()) {
            this.model.addElement(favoriteTask);
        }
    }

    private void handleRightClick(MouseEvent e) {
        Point point = e.getPoint();
        int index = this.list.locationToIndex(point);
        if (index != -1 && !this.list.isSelectedIndex(index)) {
            if (Utility.isCTRLDown(e.getModifiersEx())) {
                this.list.addSelectionInterval(index, index);
            } else {
                this.list.setSelectedIndex(index);
            }
        }
        this.enableThingsAppropriately();
        this.popupMenu.show(this.list, point.x, point.y);
    }

    @Override
    public void startingProjectsAndTasksReload() {
    }

    @Override
    public void projectsAndTasksReloaded(boolean wasSuccessful) {
        this.list.repaint();
        this.enableThingsAppropriately();
    }

    @Override
    public void favoritesChanged() {
        this.populate();
        this.favoritesEditor.serializeOut(this.settingsNode);
    }

    @Override
    public void favoritesReordered(List<FavoriteTask> favoritesReordered) {
        Object[] previouslySelectedObjects = this.list.getSelectedValues();
        this.populate();
        this.list.clearSelection();
        if (previouslySelectedObjects != null) {
            for (int index = 0; index < previouslySelectedObjects.length; ++index) {
                Object previouslySelectedObject = previouslySelectedObjects[index];
                int listIndex = this.model.indexOf(previouslySelectedObject);
                if (listIndex == -1) continue;
                this.list.addSelectionInterval(listIndex, listIndex);
            }
        }
        this.favoritesEditor.serializeOut(this.settingsNode);
    }

    private void setupPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.executeMenuItem = Utility.createMenuItem(this.getClass(), "Execute", "execute.png", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.executeSelectedTasks();
            }
        });
        this.popupMenu.add(this.executeMenuItem);
        this.editMenuItem = Utility.createMenuItem(this.getClass(), "Edit...", "edit.png", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.editTask();
            }
        });
        this.popupMenu.add(this.editMenuItem);
        this.copyFavoritesMenuItem = Utility.createMenuItem(this.getClass(), "Duplicate ", "blank.png", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.duplicateTasks();
            }
        });
        this.popupMenu.add(this.copyFavoritesMenuItem);
        this.removeFavoritesMenuItem = Utility.createMenuItem(this.getClass(), "Remove", "remove.png", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FavoriteTasksTab.this.removeSelectedFavorites();
            }
        });
        this.popupMenu.add(this.removeFavoritesMenuItem);
    }

    private void executeSelectedTasks() {
        List<FavoriteTask> favorites = this.getSelectedFavoriteTasks();
        this.gradlePluginLord.addExecutionRequestToQueue(favorites);
    }

    private void removeSelectedFavorites() {
        List<FavoriteTask> favorites = this.getSelectedFavoriteTasks();
        this.favoritesEditor.removeFavorites(favorites);
    }

    private List<FavoriteTask> getSelectedFavoriteTasks() {
        Object[] objects = this.list.getSelectedValues();
        if (objects == null) {
            return Collections.emptyList();
        }
        ArrayList<FavoriteTask> favorites = new ArrayList<FavoriteTask>();
        for (int index = 0; index < objects.length; ++index) {
            favorites.add((FavoriteTask)objects[index]);
        }
        return favorites;
    }

    private FavoriteTask getFirstSelectedFavoriteTask() {
        return (FavoriteTask)this.list.getSelectedValue();
    }

    private void enableThingsAppropriately() {
        Object[] objects = this.list.getSelectedValues();
        boolean hasSelection = objects != null && objects.length != 0;
        boolean hasSingleSelection = objects != null && objects.length == 1;
        this.executeMenuItem.setEnabled(hasSelection);
        this.removeFavoritesMenuItem.setEnabled(hasSelection);
        this.executeButton.setEnabled(hasSelection);
        this.removeButton.setEnabled(hasSelection);
        this.moveUpButton.setEnabled(hasSelection);
        this.moveDownButton.setEnabled(hasSelection);
        this.copyFavoritesMenuItem.setEnabled(hasSelection);
        this.editButton.setEnabled(hasSingleSelection);
    }

    private void importFavorites() {
        this.favoritesEditor.importFromFile(new SwingImportInteraction(SwingUtilities.getWindowAncestor(this.mainPanel)));
    }

    private void exportFavorites() {
        this.favoritesEditor.exportToFile(new SwingExportInteraction(SwingUtilities.getWindowAncestor(this.mainPanel)));
    }

    private void addTask() {
        this.favoritesEditor.addFavorite(new SwingEditFavoriteInteraction(SwingUtilities.getWindowAncestor(this.mainPanel), "Add Favorite", SwingEditFavoriteInteraction.SynchronizeType.OnlyIfAlreadySynchronized));
    }

    private void editTask() {
        FavoriteTask selectedFavoriteTask = this.getFirstSelectedFavoriteTask();
        this.favoritesEditor.editFavorite(selectedFavoriteTask, new SwingEditFavoriteInteraction(SwingUtilities.getWindowAncestor(this.mainPanel), "Edit Favorite", SwingEditFavoriteInteraction.SynchronizeType.OnlyIfAlreadySynchronized));
    }

    private void duplicateTasks() {
        this.favoritesEditor.duplicateFavorites(this.getSelectedFavoriteTasks(), new SwingEditFavoriteInteraction(SwingUtilities.getWindowAncestor(this.mainPanel), "Duplicate Favorite", SwingEditFavoriteInteraction.SynchronizeType.OnlyIfAlreadySynchronized));
    }
}

