/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.gradle.testkit.jarjar.com.google.common.base.Preconditions;
import org.gradle.testkit.jarjar.org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.testkit.jarjar.org.gradle.initialization.BuildCancellationToken;
import org.gradle.testkit.jarjar.org.gradle.initialization.layout.BuildLayout;
import org.gradle.testkit.jarjar.org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.testkit.jarjar.org.gradle.internal.Factory;
import org.gradle.testkit.jarjar.org.gradle.internal.UncheckedException;
import org.gradle.testkit.jarjar.org.gradle.internal.classpath.ClassPath;
import org.gradle.testkit.jarjar.org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.testkit.jarjar.org.gradle.logging.ProgressLogger;
import org.gradle.testkit.jarjar.org.gradle.logging.ProgressLoggerFactory;
import org.gradle.testkit.jarjar.org.gradle.util.DistributionLocator;
import org.gradle.testkit.jarjar.org.gradle.util.GradleVersion;
import org.gradle.testkit.jarjar.org.gradle.wrapper.Download;
import org.gradle.testkit.jarjar.org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.testkit.jarjar.org.gradle.wrapper.IDownload;
import org.gradle.testkit.jarjar.org.gradle.wrapper.Install;
import org.gradle.testkit.jarjar.org.gradle.wrapper.Logger;
import org.gradle.testkit.jarjar.org.gradle.wrapper.PathAssembler;
import org.gradle.testkit.jarjar.org.gradle.wrapper.WrapperConfiguration;
import org.gradle.testkit.jarjar.org.gradle.wrapper.WrapperExecutor;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.Distribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionFactory {
    private final Factory<? extends ExecutorService> executorFactory;
    private File distributionBaseDir;

    public DistributionFactory(Factory<? extends ExecutorService> executorFactory) {
        this.executorFactory = Preconditions.checkNotNull(executorFactory);
    }

    public void setDistributionBaseDir(File distributionBaseDir) {
        this.distributionBaseDir = distributionBaseDir;
    }

    public Distribution getDefaultDistribution(File projectDir, boolean searchUpwards) {
        BuildLayout layout = new BuildLayoutFactory().getLayoutFor(projectDir, searchUpwards);
        WrapperExecutor wrapper = WrapperExecutor.forProjectDirectory(layout.getRootDirectory(), System.out);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration(), this.executorFactory, this.distributionBaseDir);
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    public Distribution getDistribution(File gradleHomeDir) {
        return new InstalledDistribution(gradleHomeDir, String.format("Gradle installation '%s'", gradleHomeDir), String.format("Gradle installation directory '%s'", gradleHomeDir));
    }

    public Distribution getDistribution(String gradleVersion) {
        return this.getDownloadedDistribution(gradleVersion);
    }

    public Distribution getDistribution(URI gradleDistribution) {
        WrapperConfiguration configuration = new WrapperConfiguration();
        configuration.setDistribution(gradleDistribution);
        return new ZippedDistribution(configuration, this.executorFactory, this.distributionBaseDir);
    }

    public Distribution getClasspathDistribution() {
        return new ClasspathDistribution();
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version(gradleVersion));
        return this.getDistribution(distUri);
    }

    private static class ClasspathDistribution
    implements Distribution {
        private ClasspathDistribution() {
        }

        public String getDisplayName() {
            return "Gradle classpath distribution";
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir, BuildCancellationToken cancellationToken) {
            return new EffectiveClassPath(this.getClass().getClassLoader());
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        public InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir, BuildCancellationToken cancellationToken) {
            ProgressLogger progressLogger = progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription("Validate distribution");
            progressLogger.started();
            try {
                ClassPath classPath = this.getToolingImpl();
                return classPath;
            }
            finally {
                progressLogger.completed();
            }
        }

        private ClassPath getToolingImpl() {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
            return new DefaultClassPath((Iterable<File>)files);
        }
    }

    private static class ProgressReportingDownload
    implements IDownload {
        private final ProgressLoggerFactory progressLoggerFactory;

        private ProgressReportingDownload(ProgressLoggerFactory progressLoggerFactory) {
            this.progressLoggerFactory = progressLoggerFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void download(URI address, File destination) throws Exception {
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription(String.format("Download %s", address));
            progressLogger.started();
            try {
                new Download(new Logger(false), "Gradle Tooling API", GradleVersion.current().getVersion()).download(address, destination);
            }
            finally {
                progressLogger.completed();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;
        private final Factory<? extends ExecutorService> executorFactory;
        private final File distributionBaseDir;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration, Factory<? extends ExecutorService> executorFactory, File distributionBaseDir) {
            this.wrapperConfiguration = wrapperConfiguration;
            this.executorFactory = executorFactory;
            this.distributionBaseDir = distributionBaseDir;
        }

        @Override
        public String getDisplayName() {
            return String.format("Gradle distribution '%s'", this.wrapperConfiguration.getDistribution());
        }

        @Override
        public ClassPath getToolingImplementationClasspath(final ProgressLoggerFactory progressLoggerFactory, final File userHomeDir, BuildCancellationToken cancellationToken) {
            if (this.installedDistribution == null) {
                File installDir;
                Callable<File> installDistroTask = new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        File installDir;
                        try {
                            File realUserHomeDir = ZippedDistribution.this.determineRealUserHomeDir(userHomeDir);
                            Install install = new Install(new Logger(false), new ProgressReportingDownload(progressLoggerFactory), new PathAssembler(realUserHomeDir));
                            installDir = install.createDist(ZippedDistribution.this.wrapperConfiguration);
                        }
                        catch (FileNotFoundException e) {
                            throw new IllegalArgumentException(String.format("The specified %s does not exist.", ZippedDistribution.this.getDisplayName()), e);
                        }
                        catch (CancellationException e) {
                            throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", ZippedDistribution.this.wrapperConfiguration.getDistribution()), e);
                        }
                        catch (Exception e) {
                            throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", ZippedDistribution.this.wrapperConfiguration.getDistribution()), e);
                        }
                        return installDir;
                    }
                };
                ExecutorService executor = null;
                try {
                    executor = this.executorFactory.create();
                    final Future<File> installDirFuture = executor.submit(installDistroTask);
                    cancellationToken.addCallback(new Runnable(){

                        public void run() {
                            installDirFuture.cancel(true);
                        }
                    });
                    installDir = installDirFuture.get();
                }
                catch (CancellationException e) {
                    throw new BuildCancelledException(String.format("Distribution download cancelled. Using distribution from '%s'.", this.wrapperConfiguration.getDistribution()), e);
                }
                catch (InterruptedException e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), e);
                }
                catch (ExecutionException e) {
                    if (e.getCause() != null) {
                        UncheckedException.throwAsUncheckedException(e.getCause());
                    }
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), e);
                }
                finally {
                    if (executor != null) {
                        executor.shutdown();
                    }
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, userHomeDir, cancellationToken);
        }

        private File determineRealUserHomeDir(File userHomeDir) {
            if (this.distributionBaseDir != null) {
                return this.distributionBaseDir;
            }
            return userHomeDir != null ? userHomeDir : GradleUserHomeLookup.gradleUserHome();
        }
    }
}

