#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cprng-aes
version: 0.6.1
id: cprng-aes-0.6.1-4f88e976d4e99640259c02d6940382c2
key: cprng_FqpwhJtWO8g27pB5PJZtIq
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-cprng-aes
synopsis: Crypto Pseudo Random Number Generator using AES in counter mode.
description:
    Simple crypto pseudo-random-number-generator with really good randomness property.
    .
    Using ent, a randomness property maker on one 1Mb sample:
    Entropy = 7.999837 bits per byte.
    Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
    Chi square distribution for 1048576 samples is 237.02
    Arithmetic mean value of data bytes is 127.3422 (127.5 = random)
    Monte Carlo value for Pi is 3.143589568 (error 0.06 percent)
    .
    Compared to urandom with the same sampling:
    Entropy = 7.999831 bits per byte.
    Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
    Chi square distribution for 1048576 samples is 246.63
    Arithmetic mean value of data bytes is 127.6347 (127.5 = random).
    Monte Carlo value for Pi is 3.132465868 (error 0.29 percent).
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Crypto.Random.AESCtr
hidden-modules: Crypto.Random.AESCtr.Internal
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/cprng-aes-0.6.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/cprng-aes-0.6.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/cprng-aes-0.6.1
hs-libraries: HScprng-aes-0.6.1-FqpwhJtWO8g27pB5PJZtIq
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    byteable-0.1.1-b91304cc70dc43f4dc186dc9711b3917
    bytestring-0.10.6.0-3b51e35daa3fe2a56ecd3687fb389cdc
    cipher-aes-0.2.11-25252cf5003ba05bef45f1bdfd72c181
    crypto-random-0.0.9-1a34631cfa2fcb67c67a6201143b0147
haddock-interfaces: /usr/share/doc/haskell-cprng-aes/html/cprng-aes.haddock
haddock-html: /usr/share/doc/haskell-cprng-aes/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
