#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: haskell-src-exts
version: 1.17.1
id: haskell-src-exts-1.17.1-7afd8d2f109e171c19a1cb4891217e0d
key: haske_JDUB8hqF1uTJd7lozF5HU4
license: BSD3
maintainer: Niklas Broberg <niklas.broberg@chalmers.se>, Roman Cheplyaka <roma@ro-che.info>
stability: Stable
homepage: https://github.com/haskell-suite/haskell-src-exts
synopsis: Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer
description:
    Haskell-Source with Extensions (HSE, haskell-src-exts)
    is an extension of the standard haskell-src package,
    and handles most registered syntactic extensions to Haskell, including:
    .
    * Multi-parameter type classes with functional dependencies
    .
    * Indexed type families (including associated types)
    .
    * Empty data declarations
    .
    * GADTs
    .
    * Implicit parameters
    .
    * Template Haskell
    .
    and a few more. All extensions implemented in GHC are supported.
    Apart from these standard extensions,
    it also handles regular patterns as per the HaRP extension
    as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
exposed: True
exposed-modules:
    Language.Haskell.Exts Language.Haskell.Exts.Lexer
    Language.Haskell.Exts.Parser Language.Haskell.Exts.Pretty
    Language.Haskell.Exts.Syntax Language.Haskell.Exts.Extension
    Language.Haskell.Exts.Build Language.Haskell.Exts.Fixity
    Language.Haskell.Exts.Comments Language.Haskell.Exts.SrcLoc
    Language.Haskell.Exts.Annotated
    Language.Haskell.Exts.Annotated.Syntax
    Language.Haskell.Exts.Annotated.Fixity
    Language.Haskell.Exts.Annotated.Build
    Language.Haskell.Exts.Annotated.ExactPrint
    Language.Haskell.Exts.Annotated.Simplify
    Language.Haskell.Exts.Annotated.Parser
    Language.Haskell.Exts.Annotated.Comments
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.InternalLexer
                Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/haskell-src-exts-1.17.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/haskell-src-exts-1.17.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/haskell-src-exts-1.17.1
hs-libraries: HShaskell-src-exts-1.17.1-JDUB8hqF1uTJd7lozF5HU4
depends:
    array-0.5.1.0-a4b4f31b03b7779670557ea46745a386
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    cpphs-1.19.3-8cb6c3761dbbd3c20e10f28974c8d246
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    pretty-1.1.2.0-b06321e1e395640194b358a5374c465f
haddock-interfaces: /usr/share/doc/haskell-src-exts/html/haskell-src-exts.haddock
haddock-html: /usr/share/doc/haskell-src-exts/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
