/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.pluginmanager.PluginDownload;
import org.freehep.application.studio.pluginmanager.PluginInfoPanel;
import org.freehep.application.studio.pluginmanager.PluginManagerDialog;

class PluginInstallDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    private JButton install;
    private JButton close;
    private JRadioButton cb1;
    private JRadioButton cb2;
    private BitSet onOff;
    private JTable table;
    private PluginInfoPanel info;
    private List plugins;
    private Studio app;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    PluginInstallDialog(Studio app, PluginManagerDialog parent) {
        super(parent);
        this.app = app;
        this.plugins = parent.getInstallablePlugins();
        JPanel c = new JPanel(new BorderLayout(10, 10));
        c.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        c.add((Component)new JLabel("Select Plugins to install"), "North");
        this.table = new JTable(new DataModel());
        this.table.setTableHeader(null);
        this.table.setShowGrid(false);
        TableColumn col = this.table.getColumn(this.table.getColumnName(0));
        col.setMaxWidth(col.getMinWidth());
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        c.add((Component)new JScrollPane(this.table), "West");
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getSelectionModel().setSelectionMode(0);
        this.info = new PluginInfoPanel();
        this.info.setBorder(BorderFactory.createTitledBorder("Plugin Info"));
        c.add((Component)this.info, "Center");
        JPanel bottom = new JPanel(new BorderLayout());
        JPanel cb = new JPanel(new BorderLayout());
        String dir = app.getUserExtensionsDir();
        this.cb1 = new JRadioButton("Install in user directory (" + dir + ")");
        File df = new File(dir);
        if (!df.exists()) {
            df.mkdirs();
        }
        this.cb1.setEnabled(dir != null && df.canWrite());
        this.cb1.setSelected(true);
        cb.add((Component)this.cb1, "North");
        dir = app.getSystemExtensionsDir();
        this.cb2 = new JRadioButton("Install in system directory (" + dir + ")");
        df = new File(dir);
        if (!df.exists()) {
            df.mkdirs();
        }
        this.cb2.setEnabled(dir != null && df.canWrite());
        cb.add((Component)this.cb2, "South");
        ButtonGroup rg = new ButtonGroup();
        rg.add(this.cb1);
        rg.add(this.cb2);
        bottom.add((Component)cb, "North");
        this.install = new JButton("Install");
        this.install.addActionListener(this);
        this.install.setEnabled(false);
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.install);
        buttonPanel.add(this.close);
        bottom.add((Component)buttonPanel, "South");
        c.add((Component)bottom, "South");
        this.setContentPane(c);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            this.info.setPlugin((PluginInfo)this.plugins.get(index));
        } else {
            this.info.setPlugin(null);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.close) {
            this.dispose();
        } else {
            HashMap downloads = new HashMap();
            String base = this.cb1.isSelected() ? this.app.getUserExtensionsDir() : this.app.getSystemExtensionsDir();
            for (int i = 0; i < this.plugins.size(); ++i) {
                if (!this.onOff.get(i)) continue;
                PluginInfo info = (PluginInfo)this.plugins.get(i);
                Map files = info.getFiles();
                Iterator iter = files.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    File key = new File(base, entry.getKey().toString());
                    downloads.put(key, entry.getValue());
                }
            }
            PluginDownload download = new PluginDownload(downloads);
            Thread t = new Thread(download);
            t.start();
            JOptionPane.showMessageDialog(this, download, "Downloading...", -1);
            Throwable status = download.getStatus();
            System.out.println("Done! status=" + status);
            if (status != null) {
                JOptionPane.showMessageDialog(this, "Download failed: " + status, "Download error", 0);
                download.cleanUp();
            } else {
                download.commit();
                ExtensionClassLoader loader = this.app.getExtensionLoader();
                Iterator i = downloads.keySet().iterator();
                while (i.hasNext()) {
                    try {
                        loader.addURL(((File)i.next()).toURL());
                    }
                    catch (MalformedURLException x) {
                        x.printStackTrace();
                    }
                }
                this.app.loadPlugins(this.plugins, loader);
            }
        }
    }

    private class DataModel
    extends AbstractTableModel {
        DataModel() {
            PluginInstallDialog.this.onOff = new BitSet(PluginInstallDialog.this.plugins.size());
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return PluginInstallDialog.this.plugins.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return new Boolean(PluginInstallDialog.this.onOff.get(rowIndex));
            }
            return ((PluginInfo)PluginInstallDialog.this.plugins.get(rowIndex)).getName();
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            PluginInstallDialog.this.onOff.set(rowIndex, (Boolean)aValue);
            PluginInstallDialog.this.install.setEnabled(!PluginInstallDialog.this.onOff.isEmpty());
        }

        public Class getColumnClass(int columnIndex) {
            Class clazz = columnIndex == 0 ? (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PluginInstallDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean) : (class$java$lang$String == null ? (class$java$lang$String = PluginInstallDialog.class$("java.lang.String")) : class$java$lang$String);
            return clazz;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }
}

