/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.customdrawings.gen;

import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.facet.customdrawings.CustomDrawingParserRuntimeException;
import com.baselet.element.facet.customdrawings.gen.CustomDrawingParserConstants;
import com.baselet.element.facet.customdrawings.gen.CustomDrawingParserTokenManager;
import com.baselet.element.facet.customdrawings.gen.JavaCharStream;
import com.baselet.element.facet.customdrawings.gen.ParseException;
import com.baselet.element.facet.customdrawings.gen.Provider;
import com.baselet.element.facet.customdrawings.gen.StringProvider;
import com.baselet.element.facet.customdrawings.gen.Token;
import com.baselet.element.facet.customdrawings.gen.TokenMgrException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CustomDrawingParser
implements CustomDrawingParserConstants {
    private static final Logger log = LoggerFactory.getLogger(CustomDrawingParser.class);
    public CustomDrawingParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[24];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public abstract double getWidth();

    public abstract double getHeight();

    public abstract DrawHandler getDrawHandler();

    public final void start() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 23: {
                        this.drawLine();
                        break block0;
                    }
                    case 26: {
                        this.drawRectangle();
                        break block0;
                    }
                    case 27: {
                        this.drawRectangleRound();
                        break block0;
                    }
                    case 28: {
                        this.drawCircle();
                        break block0;
                    }
                    case 29: {
                        this.drawEllipse();
                        break block0;
                    }
                    case 30: {
                        this.drawArc();
                        break block0;
                    }
                    case 31: {
                        this.drawText();
                        break block0;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
    }

    public final void drawLine() throws ParseException {
        RecRunnable callStack;
        block9: {
            callStack = null;
            this.jj_consume_token(23);
            final double x1 = this.doubleTerm();
            this.jj_consume_token(24);
            final double y1 = this.doubleTerm();
            this.jj_consume_token(24);
            final double x2 = this.doubleTerm();
            this.jj_consume_token(24);
            final double y2 = this.doubleTerm();
            this.jj_consume_token(25);
            callStack = new RecRunnable(null){

                @Override
                public void run() {
                    CustomDrawingParser.this.getDrawHandler().drawLine(x1, y1, x2, y2);
                }
            };
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 14: 
                    case 15: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        callStack = this.fg(callStack);
                        continue block8;
                    }
                    case 14: {
                        callStack = this.lt(callStack);
                        continue block8;
                    }
                    case 15: {
                        callStack = this.lw(callStack);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[3] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        callStack.run();
    }

    public final void drawRectangle() throws ParseException {
        RecRunnable callStack;
        block11: {
            callStack = null;
            this.jj_consume_token(26);
            final double x = this.doubleTerm();
            this.jj_consume_token(24);
            final double y = this.doubleTerm();
            this.jj_consume_token(24);
            final double width = this.doubleTerm();
            this.jj_consume_token(24);
            final double height = this.doubleTerm();
            this.jj_consume_token(25);
            callStack = new RecRunnable(null){

                @Override
                public void run() {
                    CustomDrawingParser.this.getDrawHandler().drawRectangle(x, y, width, height);
                }
            };
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        callStack = this.fg(callStack);
                        continue block10;
                    }
                    case 13: {
                        callStack = this.bg(callStack);
                        continue block10;
                    }
                    case 14: {
                        callStack = this.lt(callStack);
                        continue block10;
                    }
                    case 15: {
                        callStack = this.lw(callStack);
                        continue block10;
                    }
                    case 16: {
                        callStack = this.transparency(callStack);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        callStack.run();
    }

    public final void drawRectangleRound() throws ParseException {
        RecRunnable callStack;
        block11: {
            callStack = null;
            this.jj_consume_token(27);
            final double x = this.doubleTerm();
            this.jj_consume_token(24);
            final double y = this.doubleTerm();
            this.jj_consume_token(24);
            final double width = this.doubleTerm();
            this.jj_consume_token(24);
            final double height = this.doubleTerm();
            this.jj_consume_token(24);
            final double radius = this.doubleTerm();
            this.jj_consume_token(25);
            callStack = new RecRunnable(null){

                @Override
                public void run() {
                    CustomDrawingParser.this.getDrawHandler().drawRectangleRound(x, y, width, height, radius);
                }
            };
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        callStack = this.fg(callStack);
                        continue block10;
                    }
                    case 13: {
                        callStack = this.bg(callStack);
                        continue block10;
                    }
                    case 14: {
                        callStack = this.lt(callStack);
                        continue block10;
                    }
                    case 15: {
                        callStack = this.lw(callStack);
                        continue block10;
                    }
                    case 16: {
                        callStack = this.transparency(callStack);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[7] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        callStack.run();
    }

    public final void drawCircle() throws ParseException {
        RecRunnable callStack;
        block11: {
            callStack = null;
            this.jj_consume_token(28);
            final double x = this.doubleTerm();
            this.jj_consume_token(24);
            final double y = this.doubleTerm();
            this.jj_consume_token(24);
            final double radius = this.doubleTerm();
            this.jj_consume_token(25);
            callStack = new RecRunnable(null){

                @Override
                public void run() {
                    CustomDrawingParser.this.getDrawHandler().drawCircle(x, y, radius);
                }
            };
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        callStack = this.fg(callStack);
                        continue block10;
                    }
                    case 13: {
                        callStack = this.bg(callStack);
                        continue block10;
                    }
                    case 14: {
                        callStack = this.lt(callStack);
                        continue block10;
                    }
                    case 15: {
                        callStack = this.lw(callStack);
                        continue block10;
                    }
                    case 16: {
                        callStack = this.transparency(callStack);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        callStack.run();
    }

    public final void drawEllipse() throws ParseException {
        RecRunnable callStack;
        block11: {
            callStack = null;
            this.jj_consume_token(29);
            final double x = this.doubleTerm();
            this.jj_consume_token(24);
            final double y = this.doubleTerm();
            this.jj_consume_token(24);
            final double width = this.doubleTerm();
            this.jj_consume_token(24);
            final double height = this.doubleTerm();
            this.jj_consume_token(25);
            callStack = new RecRunnable(null){

                @Override
                public void run() {
                    CustomDrawingParser.this.getDrawHandler().drawEllipse(x, y, width, height);
                }
            };
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        callStack = this.fg(callStack);
                        continue block10;
                    }
                    case 13: {
                        callStack = this.bg(callStack);
                        continue block10;
                    }
                    case 14: {
                        callStack = this.lt(callStack);
                        continue block10;
                    }
                    case 15: {
                        callStack = this.lw(callStack);
                        continue block10;
                    }
                    case 16: {
                        callStack = this.transparency(callStack);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        callStack.run();
    }

    public final void drawArc() throws ParseException {
        RecRunnable callStack;
        block11: {
            callStack = null;
            this.jj_consume_token(30);
            final double x = this.doubleTerm();
            this.jj_consume_token(24);
            final double y = this.doubleTerm();
            this.jj_consume_token(24);
            final double width = this.doubleTerm();
            this.jj_consume_token(24);
            final double height = this.doubleTerm();
            this.jj_consume_token(24);
            final double start = this.doubleTerm();
            this.jj_consume_token(24);
            final double extent = this.doubleTerm();
            this.jj_consume_token(24);
            final boolean open = this.booleanConstant();
            this.jj_consume_token(25);
            callStack = new RecRunnable(null){

                @Override
                public void run() {
                    CustomDrawingParser.this.getDrawHandler().drawArc(x, y, width, height, start, extent, open);
                }
            };
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 12: {
                        callStack = this.fg(callStack);
                        continue block10;
                    }
                    case 13: {
                        callStack = this.bg(callStack);
                        continue block10;
                    }
                    case 14: {
                        callStack = this.lt(callStack);
                        continue block10;
                    }
                    case 15: {
                        callStack = this.lw(callStack);
                        continue block10;
                    }
                    case 16: {
                        callStack = this.transparency(callStack);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[13] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        callStack.run();
    }

    public final void drawText() throws ParseException {
        RecRunnable callStack = null;
        this.jj_consume_token(31);
        final String text = this.simpleString();
        this.jj_consume_token(24);
        final double x = this.doubleTerm();
        this.jj_consume_token(24);
        final double y = this.doubleTerm();
        this.jj_consume_token(24);
        final AlignHorizontal alignment = this.horizontalAlignment();
        this.jj_consume_token(25);
        callStack = new RecRunnable(null){

            @Override
            public void run() {
                CustomDrawingParser.this.getDrawHandler().print(text, x, y, alignment);
            }
        };
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            callStack = this.fg(callStack);
        }
        callStack.run();
    }

    public final RecRunnable fg(RecRunnable inner) throws ParseException {
        this.jj_consume_token(12);
        final String newColor = this.colorOwn();
        return new RecRunnable(inner){

            @Override
            public void run() {
                ColorOwn oldColor = CustomDrawingParser.this.getDrawHandler().getForegroundColor();
                CustomDrawingParser.this.getDrawHandler().setForegroundColor(newColor);
                this.runInner();
                CustomDrawingParser.this.getDrawHandler().setForegroundColor(oldColor);
            }
        };
    }

    public final RecRunnable bg(RecRunnable inner) throws ParseException {
        this.jj_consume_token(13);
        final String newColor = this.colorOwn();
        return new RecRunnable(inner){

            @Override
            public void run() {
                ColorOwn oldColor = CustomDrawingParser.this.getDrawHandler().getBackgroundColor();
                CustomDrawingParser.this.getDrawHandler().setBackgroundColorAndKeepTransparency(newColor);
                this.runInner();
                CustomDrawingParser.this.getDrawHandler().setBackgroundColor(oldColor);
            }
        };
    }

    public final String colorOwn() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final RecRunnable lt(RecRunnable inner) throws ParseException {
        this.jj_consume_token(14);
        final LineType newLineType = this.lineType();
        return new RecRunnable(inner){

            @Override
            public void run() {
                LineType oldLineType = CustomDrawingParser.this.getDrawHandler().getLineType();
                CustomDrawingParser.this.getDrawHandler().setLineType(newLineType);
                this.runInner();
                CustomDrawingParser.this.getDrawHandler().setLineType(oldLineType);
            }
        };
    }

    public final LineType lineType() throws ParseException {
        LineType value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                value = LineType.SOLID;
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                value = LineType.DASHED;
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                value = LineType.DOTTED;
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                value = LineType.DOUBLE;
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                value = LineType.DOUBLE_DASHED;
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                value = LineType.DOUBLE_DOTTED;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final RecRunnable lw(RecRunnable inner) throws ParseException {
        this.jj_consume_token(15);
        final double newLineWidth = this.unsignedDoubleConstant();
        return new RecRunnable(inner){

            @Override
            public void run() {
                double oldLineWidth = CustomDrawingParser.this.getDrawHandler().getLineWidth();
                CustomDrawingParser.this.getDrawHandler().setLineWidth(newLineWidth);
                this.runInner();
                CustomDrawingParser.this.getDrawHandler().setLineWidth(oldLineWidth);
            }
        };
    }

    public final RecRunnable transparency(RecRunnable inner) throws ParseException {
        this.jj_consume_token(16);
        final double transparencyVal = this.unsignedDoubleConstant();
        if (transparencyVal < 0.0 || transparencyVal > 100.0) {
            throw new CustomDrawingParserRuntimeException("The transparency value must be between 0 and 100");
        }
        return new RecRunnable(inner){

            @Override
            public void run() {
                ColorOwn oldColor = CustomDrawingParser.this.getDrawHandler().getBackgroundColor();
                double colorTransparencyValue = 255.0 - transparencyVal * 2.55;
                ColorOwn bgColor = CustomDrawingParser.this.getDrawHandler().getBackgroundColor();
                CustomDrawingParser.this.getDrawHandler().setBackgroundColor(bgColor.transparency((int)colorTransparencyValue));
                this.runInner();
                CustomDrawingParser.this.getDrawHandler().setBackgroundColor(oldColor);
            }
        };
    }

    public final String simpleString() throws ParseException {
        this.jj_consume_token(22);
        return this.token.image.substring(1, this.token.image.length() - 1).replace("\\\"", "\"").replace("\\\\", "\\");
    }

    public final boolean booleanConstant() throws ParseException {
        boolean value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                value = false;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                value = true;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final AlignHorizontal horizontalAlignment() throws ParseException {
        AlignHorizontal alignment;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                alignment = AlignHorizontal.LEFT;
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                alignment = AlignHorizontal.CENTER;
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                alignment = AlignHorizontal.RIGHT;
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return alignment;
    }

    public final double doubleTerm() throws ParseException {
        double v1;
        block8: {
            v1 = this.doubleProduct();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 32: 
                    case 38: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 38: {
                        this.jj_consume_token(38);
                        double v2 = this.doubleProduct();
                        v1 += v2;
                        continue block7;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        double v2 = this.doubleProduct();
                        v1 -= v2;
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[20] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return v1;
    }

    public final double doubleProduct() throws ParseException {
        double v1;
        block8: {
            v1 = this.doubleValue();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: 
                    case 40: {
                        break;
                    }
                    default: {
                        this.jj_la1[21] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        double v2 = this.doubleValue();
                        v1 *= v2;
                        continue block7;
                    }
                    case 40: {
                        this.jj_consume_token(40);
                        double v2 = this.doubleValue();
                        v1 /= v2;
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[22] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return v1;
    }

    public final double doubleValue() throws ParseException {
        double value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                value = this.getWidth();
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                value = this.getHeight();
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                value = this.unsignedDoubleConstant();
                value = -value;
                break;
            }
            case 17: {
                value = this.unsignedDoubleConstant();
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                value = this.doubleTerm();
                this.jj_consume_token(25);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final double unsignedDoubleConstant() throws ParseException {
        double value;
        this.jj_consume_token(17);
        try {
            value = Double.parseDouble(this.token.image);
        }
        catch (NumberFormatException e) {
            log.error("Fatal Error: The string '" + this.token.image + "' couldn't be parsed as double, but the grammar should ensure that the string is parsable.", (Throwable)e);
            throw (ParseException)new ParseException("Fatal Error: The string '" + this.token.image + "' couldn't be parsed as double, but the grammar should ensure that the string is parsable.").initCause(e);
        }
        return value;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-58720256, -58720256, 53248, 53248, 126976, 126976, 126976, 126976, 126976, 126976, 126976, 126976, 126976, 126976, 4096, 0x180000, 0, 384, 3584, 0, 0, 0, 0, 131168};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 65, 65, 384, 384, 513};
    }

    public CustomDrawingParser(Provider stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new CustomDrawingParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CustomDrawingParser(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new CustomDrawingParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CustomDrawingParser(CustomDrawingParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(CustomDrawingParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 24; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[42];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 24; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 42; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : CustomDrawingParserTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        CustomDrawingParser.jj_la1_init_0();
        CustomDrawingParser.jj_la1_init_1();
    }

    private abstract class RecRunnable {
        private RecRunnable inner;

        public RecRunnable(RecRunnable inner) {
            this.inner = inner;
        }

        public abstract void run();

        protected void runInner() {
            if (this.inner != null) {
                this.inner.run();
            }
        }
    }
}

