/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sre;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.imp;
import org.python.modules.sre.PatternObject;

public class MatchObject
extends PyObject
implements Traverseproc {
    public PyString string;
    public PyObject regs;
    PatternObject pattern;
    int pos;
    int endpos;
    int lastindex;
    int groups;
    int[] mark;

    public PyObject expand(PyObject[] args) {
        if (args.length == 0) {
            throw Py.TypeError("expand() takes exactly 1 argument (0 given)");
        }
        PyObject mod2 = imp.importName("re", true);
        PyObject func = mod2.__getattr__("_expand");
        return func.__call__(new PyObject[]{this.pattern, this, args[0]});
    }

    public PyObject group(PyObject[] args) {
        switch (args.length) {
            case 0: {
                return this.getslice(Py.Zero, Py.None);
            }
            case 1: {
                return this.getslice(args[0], Py.None);
            }
        }
        PyObject[] result = new PyObject[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.getslice(args[i], Py.None);
        }
        return new PyTuple(result);
    }

    public PyObject groups(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("groups", args, kws, "default");
        PyObject def = ap.getPyObject(0, Py.None);
        PyObject[] result = new PyObject[this.groups - 1];
        for (int i = 1; i < this.groups; ++i) {
            result[i - 1] = this.getslice_by_index(i, def);
        }
        return new PyTuple(result);
    }

    public PyObject groupdict(PyObject[] args, String[] kws) {
        PyObject key;
        ArgParser ap = new ArgParser("groupdict", args, kws, "default");
        PyObject def = ap.getPyObject(0, Py.None);
        PyDictionary result = new PyDictionary();
        if (this.pattern.groupindex == null) {
            return result;
        }
        PyObject keys = this.pattern.groupindex.invoke("keys");
        int i = 0;
        while ((key = keys.__finditem__(i)) != null) {
            PyObject item = this.getslice(key, def);
            ((PyObject)result).__setitem__(key, item);
            ++i;
        }
        return result;
    }

    public PyObject start() {
        return this.start(Py.Zero);
    }

    public PyObject start(PyObject index_) {
        int index = this.getindex(index_);
        if (index < 0 || index >= this.groups) {
            throw Py.IndexError("no such group");
        }
        return Py.newInteger(this.mark[index * 2]);
    }

    public PyObject end() {
        return this.end(Py.Zero);
    }

    public PyObject end(PyObject index_) {
        int index = this.getindex(index_);
        if (index < 0 || index >= this.groups) {
            throw Py.IndexError("no such group");
        }
        return Py.newInteger(this.mark[index * 2 + 1]);
    }

    public PyTuple span() {
        return this.span(Py.Zero);
    }

    public PyTuple span(PyObject index_) {
        int index = this.getindex(index_);
        if (index < 0 || index >= this.groups) {
            throw Py.IndexError("no such group");
        }
        int start = this.mark[index * 2];
        int end = this.mark[index * 2 + 1];
        return this._pair(start, end);
    }

    public PyObject regs() {
        PyObject[] regs = new PyObject[this.groups];
        for (int index = 0; index < this.groups; ++index) {
            regs[index] = this._pair(this.mark[index * 2], this.mark[index * 2 + 1]);
        }
        return new PyTuple(regs);
    }

    PyTuple _pair(int i1, int i2) {
        return new PyTuple(Py.newInteger(i1), Py.newInteger(i2));
    }

    private PyObject getslice(PyObject index, PyObject def) {
        return this.getslice_by_index(this.getindex(index), def);
    }

    private int getindex(PyObject index) {
        if (index instanceof PyInteger) {
            return ((PyInteger)index).getValue();
        }
        int i = -1;
        if (this.pattern.groupindex != null && (index = this.pattern.groupindex.__finditem__(index)) != null && index instanceof PyInteger) {
            return ((PyInteger)index).getValue();
        }
        return i;
    }

    private PyObject getslice_by_index(int index, PyObject def) {
        if (index < 0 || index >= this.groups) {
            throw Py.IndexError("no such group");
        }
        int start = this.mark[index *= 2];
        int end = this.mark[index + 1];
        if (this.string == null || start < 0) {
            return def;
        }
        return this.string.__getslice__(Py.newInteger(start), Py.newInteger(end));
    }

    @Override
    public PyObject __findattr_ex__(String key) {
        if (key == "flags") {
            return Py.newInteger(this.pattern.flags);
        }
        if (key == "groupindex") {
            return this.pattern.groupindex;
        }
        if (key == "re") {
            return this.pattern;
        }
        if (key == "pos") {
            return Py.newInteger(this.pos);
        }
        if (key == "endpos") {
            return Py.newInteger(this.endpos);
        }
        if (key == "lastindex") {
            return this.lastindex == -1 ? Py.None : Py.newInteger(this.lastindex);
        }
        if (key == "lastgroup") {
            if (this.pattern.indexgroup != null && this.lastindex >= 0) {
                return this.pattern.indexgroup.__getitem__(this.lastindex);
            }
            return Py.None;
        }
        if (key == "regs") {
            return this.regs();
        }
        return super.__findattr_ex__(key);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.pattern != null && (retVal = visit.visit(this.pattern, arg)) != 0) {
            return retVal;
        }
        if (this.string != null && (retVal = visit.visit(this.string, arg)) != 0) {
            return retVal;
        }
        return this.regs != null ? visit.visit(this.regs, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.pattern || ob == this.string || ob == this.regs);
    }
}

