/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.PagePreviewOpener;
import org.pdfsam.guiclient.business.PagesWorker;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.listeners.VisualPdfSelectionActionListener;
import org.pdfsam.guiclient.commons.business.listeners.adapters.PageOpenerMouseAdapter;
import org.pdfsam.guiclient.commons.business.listeners.adapters.VisualPdfSelectionKeyAdapter;
import org.pdfsam.guiclient.commons.business.listeners.adapters.VisualPdfSelectionMouseAdapter;
import org.pdfsam.guiclient.commons.business.listeners.mediators.PagesActionsMediator;
import org.pdfsam.guiclient.commons.business.loaders.PdfThumbnailsLoader;
import org.pdfsam.guiclient.commons.components.JVisualSelectionList;
import org.pdfsam.guiclient.commons.dnd.handlers.VisualListExportTransferHandler;
import org.pdfsam.guiclient.commons.dnd.handlers.VisualListTransferHandler;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.commons.renderers.VisualListRenderer;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.DocumentInfo;
import org.pdfsam.guiclient.dto.Rotation;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.dto.VisualSelectedItem;
import org.pdfsam.i18n.GettextResource;

public class JVisualPdfPageSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1384691784810385438L;
    private static final Logger log = Logger.getLogger(JVisualPdfPageSelectionPanel.class.getPackage().getName());
    public static final int HORIZONTAL_ORIENTATION = 1;
    public static final int VERTICAL_ORIENTATION = 2;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    public static final int SINGLE_SELECTION = 0;
    public static final int STYLE_TOP_PANEL_HIDE = 0;
    public static final int STYLE_TOP_PANEL_MINIMAL = 1;
    public static final int STYLE_TOP_PANEL_MEDIUM = 2;
    public static final int STYLE_TOP_PANEL_FULL = 3;
    public static final int DND_SUPPORT_NONE = 0;
    public static final int DND_SUPPORT_FILES = 1;
    public static final int DND_SUPPORT_JAVAOBJECTS = 2;
    public static final int DND_SUPPORT_FILES_AND_JAVAOBJECTS = 3;
    public static final String OUTPUT_PATH_PROPERTY = "defaultOutputPath";
    private int orientation = 1;
    private File selectedPdfDocument = null;
    private String selectedPdfDocumentPassword = "";
    private boolean showButtonPanel = true;
    private int topPanelStyle = 3;
    private boolean showContextMenu = true;
    private int dndSupport = 0;
    private int selectionType = 1;
    private final JMenuItem menuItemSetOutputPath = new JMenuItem();
    private boolean drawDeletedItems = true;
    private boolean wrap = false;
    private Configuration config;
    private PagesWorker pagesWorker;
    private final JButton loadFileButton = new JButton();
    private final JButton clearButton = new JButton();
    private final JButton zoomInButton = new JButton();
    private final JButton zoomOutButton = new JButton();
    private final JLabel documentProperties = new JLabel();
    private final JVisualSelectionList thumbnailList = new JVisualSelectionList();
    private PdfThumbnailsLoader pdfLoader;
    private VisualPdfSelectionActionListener pdfSelectionActionListener;
    private PagesActionsMediator pageActionListener;
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JMenuItem menuItemPreview = new JMenuItem();
    private final JPanel topPanel = new JPanel();
    private JPanel buttonPanel;
    private JButton undeleteButton;
    private JButton removeButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JButton rotateButton;
    private JButton rotateAntiButton;
    private JButton reverseButton;

    public JVisualPdfPageSelectionPanel() {
        this(1);
    }

    public JVisualPdfPageSelectionPanel(int orientation) {
        this(orientation, true, true);
    }

    public JVisualPdfPageSelectionPanel(int orientation, boolean drawDeletedItems, boolean showButtonPanel) {
        this(orientation, drawDeletedItems, showButtonPanel, true, 3);
    }

    public JVisualPdfPageSelectionPanel(int orientation, boolean drawDeletedItems, boolean showButtonPanel, boolean showContextMenu, int topPanelStyle) {
        this(orientation, drawDeletedItems, showButtonPanel, showContextMenu, topPanelStyle, 3, 1);
    }

    public JVisualPdfPageSelectionPanel(int orientation, boolean drawDeletedItems, boolean showButtonPanel, boolean showContextMenu, int topPanelStyle, int dndSupport, int selectionType) {
        this.orientation = orientation;
        this.config = Configuration.getInstance();
        this.pdfLoader = new PdfThumbnailsLoader(this);
        this.drawDeletedItems = drawDeletedItems;
        this.showButtonPanel = showButtonPanel;
        this.showContextMenu = showContextMenu;
        this.topPanelStyle = topPanelStyle;
        this.dndSupport = dndSupport;
        this.selectionType = selectionType;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.thumbnailList.setDrawDeletedItems(this.drawDeletedItems);
        if (this.dndSupport == 1) {
            this.thumbnailList.setTransferHandler(new VisualListExportTransferHandler(this.pdfLoader));
        } else if (this.dndSupport == 2) {
            this.thumbnailList.setTransferHandler(new VisualListTransferHandler());
        } else if (this.dndSupport == 3) {
            this.thumbnailList.setTransferHandler(new VisualListTransferHandler(this.pdfLoader));
        } else {
            this.thumbnailList.setTransferHandler(new VisualListExportTransferHandler(null));
        }
        this.thumbnailList.setDragEnabled(true);
        this.thumbnailList.setDropMode(DropMode.INSERT);
        this.pagesWorker = new PagesWorker(this.thumbnailList);
        this.thumbnailList.addKeyListener(new VisualPdfSelectionKeyAdapter(this.pagesWorker));
        this.thumbnailList.addMouseListener(new PageOpenerMouseAdapter(this.thumbnailList));
        if (this.showButtonPanel) {
            this.initButtonPanel(this.pagesWorker);
            this.initKeyListener();
        }
        if (1 == this.orientation) {
            this.thumbnailList.setLayoutOrientation(2);
        } else if (this.wrap) {
            this.thumbnailList.setLayoutOrientation(1);
        }
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 2));
        this.topPanel.setPreferredSize(new Dimension(400, 30));
        this.pdfSelectionActionListener = new VisualPdfSelectionActionListener(this, this.pdfLoader);
        if (this.topPanelStyle >= 3) {
            this.loadFileButton.setMargin(new Insets(1, 1, 1, 1));
            this.loadFileButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Open"));
            this.loadFileButton.setPreferredSize(new Dimension(100, 30));
            this.loadFileButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Load a pdf document"));
            this.loadFileButton.setIcon(new ImageIcon(this.getClass().getResource("/images/add.png")));
            this.loadFileButton.addKeyListener(new EnterDoClickListener(this.loadFileButton));
            this.loadFileButton.setAlignmentX(0.5f);
            this.loadFileButton.setAlignmentY(0.5f);
            this.loadFileButton.setActionCommand("add");
            this.loadFileButton.addActionListener(this.pdfSelectionActionListener);
        }
        this.documentProperties.setIcon(new ImageIcon(this.getClass().getResource("/images/info.png")));
        this.documentProperties.setVisible(false);
        if (this.topPanelStyle >= 2) {
            this.clearButton.setMargin(new Insets(1, 1, 1, 1));
            this.clearButton.setMinimumSize(new Dimension(30, 30));
            this.clearButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Clear"));
            this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/images/clear.png")));
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JVisualPdfPageSelectionPanel.this.resetPanel();
                }
            });
        }
        this.zoomInButton.setMargin(new Insets(1, 1, 1, 1));
        this.zoomInButton.setMinimumSize(new Dimension(30, 30));
        this.zoomInButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Zoom in"));
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/images/zoomin.png")));
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JVisualPdfPageSelectionPanel.this.thumbnailList.incZoomLevel();
                    JVisualPdfPageSelectionPanel.this.zoomOutButton.setEnabled(true);
                    if (JVisualPdfPageSelectionPanel.this.thumbnailList.getCurrentZoomLevel() >= 0) {
                        JVisualPdfPageSelectionPanel.this.zoomInButton.setEnabled(false);
                    }
                    ((VisualListModel)JVisualPdfPageSelectionPanel.this.thumbnailList.getModel()).elementsChanged();
                }
                catch (Exception ex) {
                    log.error(GettextResource.gettext((ResourceBundle)JVisualPdfPageSelectionPanel.this.config.getI18nResourceBundle(), (String)"Error setting zoom level."), ex);
                }
            }
        });
        this.zoomOutButton.setMargin(new Insets(1, 1, 1, 1));
        this.zoomOutButton.setMinimumSize(new Dimension(30, 30));
        this.zoomOutButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Zoom out"));
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/images/zoomout.png")));
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JVisualPdfPageSelectionPanel.this.thumbnailList.deincZoomLevel();
                    JVisualPdfPageSelectionPanel.this.zoomInButton.setEnabled(true);
                    if (JVisualPdfPageSelectionPanel.this.thumbnailList.getCurrentZoomLevel() <= -7) {
                        JVisualPdfPageSelectionPanel.this.zoomOutButton.setEnabled(false);
                    }
                    ((VisualListModel)JVisualPdfPageSelectionPanel.this.thumbnailList.getModel()).elementsChanged();
                }
                catch (Exception ex) {
                    log.error(GettextResource.gettext((ResourceBundle)JVisualPdfPageSelectionPanel.this.config.getI18nResourceBundle(), (String)"Error setting zoom level."), ex);
                }
            }
        });
        this.thumbnailList.setModel(new VisualListModel());
        this.thumbnailList.setCellRenderer(new VisualListRenderer());
        this.thumbnailList.setVisibleRowCount(-1);
        this.thumbnailList.setSelectionMode(this.selectionType);
        JScrollPane listScroller = new JScrollPane(this.thumbnailList);
        this.menuItemPreview.setIcon(new ImageIcon(this.getClass().getResource("/images/preview-viewer.png")));
        this.menuItemPreview.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Preview"));
        this.menuItemPreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int[] selection = JVisualPdfPageSelectionPanel.this.thumbnailList.getSelectedIndices();
                if (selection != null && selection.length == 1) {
                    VisualPageListItem item = (VisualPageListItem)JVisualPdfPageSelectionPanel.this.thumbnailList.getModel().getElementAt(selection[0]);
                    PagePreviewOpener.getInstance().openPreview(item.getParentFileCanonicalPath(), item.getDocumentPassword(), item.getPageNumber());
                }
            }
        });
        if (this.showContextMenu) {
            JMenuItem menuItemMoveUp = new JMenuItem();
            menuItemMoveUp.setIcon(new ImageIcon(this.getClass().getResource("/images/up.png")));
            menuItemMoveUp.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move Up"));
            menuItemMoveUp.addMouseListener(new VisualPdfSelectionMouseAdapter("moveUp", this.pagesWorker));
            this.popupMenu.add(menuItemMoveUp);
            JMenuItem menuItemMoveDown = new JMenuItem();
            menuItemMoveDown.setIcon(new ImageIcon(this.getClass().getResource("/images/down.png")));
            menuItemMoveDown.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move Down"));
            menuItemMoveDown.addMouseListener(new VisualPdfSelectionMouseAdapter("moveDown", this.pagesWorker));
            this.popupMenu.add(menuItemMoveDown);
            JMenuItem menuItemRemove = new JMenuItem();
            menuItemRemove.setIcon(new ImageIcon(this.getClass().getResource("/images/remove.png")));
            menuItemRemove.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Delete"));
            menuItemRemove.addMouseListener(new VisualPdfSelectionMouseAdapter("remove", this.pagesWorker));
            this.popupMenu.add(menuItemRemove);
            if (this.drawDeletedItems) {
                JMenuItem menuItemUndelete = new JMenuItem();
                menuItemUndelete.setIcon(new ImageIcon(this.getClass().getResource("/images/remove.png")));
                menuItemUndelete.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Undelete"));
                menuItemUndelete.addMouseListener(new VisualPdfSelectionMouseAdapter("undelete", this.pagesWorker));
                this.popupMenu.add(menuItemUndelete);
            }
            JMenuItem menuItemRotate = new JMenuItem();
            menuItemRotate.setIcon(new ImageIcon(this.getClass().getResource("/images/clockwise.png")));
            menuItemRotate.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate clockwise"));
            menuItemRotate.addMouseListener(new VisualPdfSelectionMouseAdapter("rotateclock", this.pagesWorker));
            this.popupMenu.add(menuItemRotate);
            JMenuItem menuItemAntiRotate = new JMenuItem();
            menuItemAntiRotate.setIcon(new ImageIcon(this.getClass().getResource("/images/anticlockwise.png")));
            menuItemAntiRotate.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate anticlockwise"));
            menuItemAntiRotate.addMouseListener(new VisualPdfSelectionMouseAdapter("rotateanticlock", this.pagesWorker));
            this.popupMenu.add(menuItemAntiRotate);
            JMenuItem menuItemReverse = new JMenuItem();
            menuItemReverse.setIcon(new ImageIcon(this.getClass().getResource("/images/reverse.png")));
            menuItemReverse.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Reverse"));
            menuItemReverse.addMouseListener(new VisualPdfSelectionMouseAdapter("reverse", this.pagesWorker));
            this.popupMenu.add(menuItemReverse);
            this.enableSetOutputPathMenuItem();
            this.addPopupShower();
        }
        this.popupMenu.add(this.menuItemPreview);
        if (this.topPanelStyle >= 3) {
            this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.topPanel.add(this.loadFileButton);
        }
        if (this.topPanelStyle >= 2) {
            this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.topPanel.add(this.clearButton);
        }
        this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.topPanel.add(this.documentProperties);
        this.topPanel.add(Box.createHorizontalGlue());
        this.topPanel.add(this.zoomInButton);
        this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.topPanel.add(this.zoomOutButton);
        GridBagConstraints topConstraints = new GridBagConstraints();
        topConstraints.fill = 1;
        topConstraints.gridx = 0;
        topConstraints.gridy = 0;
        topConstraints.gridwidth = 3;
        topConstraints.gridheight = 1;
        topConstraints.insets = new Insets(5, 5, 5, 5);
        topConstraints.weightx = 1.0;
        topConstraints.weighty = 0.0;
        if (this.topPanelStyle > 0) {
            this.add((Component)this.topPanel, topConstraints);
        }
        GridBagConstraints thumbConstraints = new GridBagConstraints();
        thumbConstraints.fill = 1;
        thumbConstraints.gridx = 0;
        thumbConstraints.gridy = 1;
        thumbConstraints.gridwidth = this.showButtonPanel ? 2 : 3;
        thumbConstraints.gridheight = 2;
        thumbConstraints.insets = new Insets(5, 5, 5, 5);
        thumbConstraints.weightx = 1.0;
        thumbConstraints.weighty = 1.0;
        this.add((Component)listScroller, thumbConstraints);
        if (this.showButtonPanel) {
            GridBagConstraints buttonsConstraints = new GridBagConstraints();
            buttonsConstraints.fill = 1;
            buttonsConstraints.gridx = 2;
            buttonsConstraints.gridy = 1;
            buttonsConstraints.gridwidth = 1;
            buttonsConstraints.gridheight = 2;
            buttonsConstraints.insets = new Insets(5, 5, 5, 5);
            buttonsConstraints.weightx = 0.0;
            buttonsConstraints.weighty = 1.0;
            this.add((Component)this.buttonPanel, buttonsConstraints);
        }
    }

    private void addButtonToButtonPanel(JButton button) {
        button.setMinimumSize(new Dimension(90, 25));
        button.setMaximumSize(new Dimension(160, 25));
        this.buttonPanel.add(button);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    private void initButtonPanel(PagesWorker pagesWorker) {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.pageActionListener = new PagesActionsMediator(pagesWorker);
        this.moveUpButton = new JButton();
        this.moveUpButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveUpButton.addActionListener(this.pageActionListener);
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/images/up.png")));
        this.moveUpButton.setActionCommand("moveUp");
        this.moveUpButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move Up"));
        this.moveUpButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move up selected pages") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"(Alt+ArrowUp)"));
        this.moveUpButton.addKeyListener(new EnterDoClickListener(this.moveUpButton));
        this.moveUpButton.setAlignmentX(0.5f);
        this.addButtonToButtonPanel(this.moveUpButton);
        this.moveDownButton = new JButton();
        this.moveDownButton.addActionListener(this.pageActionListener);
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/images/down.png")));
        this.moveDownButton.setActionCommand("moveDown");
        this.moveDownButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveDownButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move Down"));
        this.moveDownButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move down selected pages") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"(Alt+ArrowDown)"));
        this.moveDownButton.addKeyListener(new EnterDoClickListener(this.moveDownButton));
        this.moveDownButton.setAlignmentX(0.5f);
        this.addButtonToButtonPanel(this.moveDownButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(this.pageActionListener);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/images/remove.png")));
        this.removeButton.setActionCommand("remove");
        this.removeButton.setMargin(new Insets(2, 2, 2, 2));
        this.removeButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Delete"));
        this.removeButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Delete selected pages") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"(Canc)"));
        this.removeButton.addKeyListener(new EnterDoClickListener(this.removeButton));
        this.removeButton.setAlignmentX(0.5f);
        this.addButtonToButtonPanel(this.removeButton);
        if (this.drawDeletedItems) {
            this.undeleteButton = new JButton();
            this.undeleteButton.addActionListener(this.pageActionListener);
            this.undeleteButton.setIcon(new ImageIcon(this.getClass().getResource("/images/remove.png")));
            this.undeleteButton.setActionCommand("undelete");
            this.undeleteButton.setMargin(new Insets(2, 2, 2, 2));
            this.undeleteButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Undelete"));
            this.undeleteButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Undelete selected pages") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"(Ctrl+Z)"));
            this.undeleteButton.addKeyListener(new EnterDoClickListener(this.undeleteButton));
            this.undeleteButton.setAlignmentX(0.5f);
            this.addButtonToButtonPanel(this.undeleteButton);
        }
        this.rotateButton = new JButton();
        this.rotateButton.addActionListener(this.pageActionListener);
        this.rotateButton.setIcon(new ImageIcon(this.getClass().getResource("/images/clockwise.png")));
        this.rotateButton.setActionCommand("rotateclock");
        this.rotateButton.setMargin(new Insets(2, 2, 2, 2));
        this.rotateButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate right"));
        this.rotateButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate clockwise selected pages") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"(Alt+ArrowRight)"));
        this.rotateButton.addKeyListener(new EnterDoClickListener(this.rotateButton));
        this.rotateButton.setAlignmentX(0.5f);
        this.addButtonToButtonPanel(this.rotateButton);
        this.rotateAntiButton = new JButton();
        this.rotateAntiButton.addActionListener(this.pageActionListener);
        this.rotateAntiButton.setIcon(new ImageIcon(this.getClass().getResource("/images/anticlockwise.png")));
        this.rotateAntiButton.setActionCommand("rotateanticlock");
        this.rotateAntiButton.setMargin(new Insets(2, 2, 2, 2));
        this.rotateAntiButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate left"));
        this.rotateAntiButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Rotate anticlockwise selected pages") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"(Alt+ArrowLeft)"));
        this.rotateAntiButton.addKeyListener(new EnterDoClickListener(this.rotateAntiButton));
        this.rotateAntiButton.setAlignmentX(0.5f);
        this.addButtonToButtonPanel(this.rotateAntiButton);
        this.reverseButton = new JButton();
        this.reverseButton.addActionListener(this.pageActionListener);
        this.reverseButton.setIcon(new ImageIcon(this.getClass().getResource("/images/reverse.png")));
        this.reverseButton.setActionCommand("reverse");
        this.reverseButton.setMargin(new Insets(2, 2, 2, 2));
        this.reverseButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Reverse"));
        this.reverseButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Reverse pages order"));
        this.reverseButton.addKeyListener(new EnterDoClickListener(this.reverseButton));
        this.reverseButton.setAlignmentX(0.5f);
        this.addButtonToButtonPanel(this.reverseButton);
    }

    private void initKeyListener() {
        this.thumbnailList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() && e.getKeyCode() == 38) {
                    JVisualPdfPageSelectionPanel.this.moveUpButton.doClick();
                } else if (e.isAltDown() && e.getKeyCode() == 40) {
                    JVisualPdfPageSelectionPanel.this.moveDownButton.doClick();
                } else if (e.getKeyCode() == 127) {
                    JVisualPdfPageSelectionPanel.this.removeButton.doClick();
                } else if (JVisualPdfPageSelectionPanel.this.drawDeletedItems && e.isControlDown() && e.getKeyCode() == 90) {
                    JVisualPdfPageSelectionPanel.this.undeleteButton.doClick();
                } else if (e.isAltDown() && e.getKeyCode() == 39) {
                    JVisualPdfPageSelectionPanel.this.rotateButton.doClick();
                } else if (e.isAltDown() && e.getKeyCode() == 37) {
                    JVisualPdfPageSelectionPanel.this.rotateAntiButton.doClick();
                }
            }
        });
    }

    public void resetPanel() {
        this.thumbnailList.setCurrentZoomLevel(-4);
        this.zoomInButton.setEnabled(true);
        this.zoomOutButton.setEnabled(true);
        ((VisualListModel)this.thumbnailList.getModel()).clearData();
        this.selectedPdfDocument = null;
        this.selectedPdfDocumentPassword = "";
        this.setDocumentPropertiesVisible(false);
        this.getPdfLoader().cleanCreator();
    }

    public void setDocumentPropertiesVisible(boolean visible) {
        this.documentProperties.setVisible(visible);
    }

    public void setDocumentProperties(DocumentInfo documetnInfo) {
        if (documetnInfo != null) {
            String encrypted = documetnInfo.isEncrypted() ? GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Yes") : GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"No");
            this.documentProperties.setToolTipText("<html><body><b><p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"File: ") + "</b>" + documetnInfo.getFileName() + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Pages: ") + "</b>" + documetnInfo.getPages() + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Pdf version: ") + "</b>" + (documetnInfo.getPdfVersion() != null ? documetnInfo.getPdfVersion() : "") + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Title: ") + "</b>" + StringUtils.trimToEmpty((String)documetnInfo.getDocumentMetaData().getTitle()) + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Author: ") + "</b>" + StringUtils.trimToEmpty((String)documetnInfo.getDocumentMetaData().getAuthor()) + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Creator: ") + "</b>" + StringUtils.trimToEmpty((String)documetnInfo.getDocumentMetaData().getCreator()) + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Producer: ") + "</b>" + StringUtils.trimToEmpty((String)documetnInfo.getDocumentMetaData().getProducer()) + "</p>" + "<p><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Encrypted: ") + "</b>" + encrypted + "</p>" + "</body></html>");
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public File getSelectedPdfDocument() {
        return this.selectedPdfDocument;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public JVisualSelectionList getThumbnailList() {
        return this.thumbnailList;
    }

    public void setSelectedPdfDocument(File selectedPdfDocument) {
        this.selectedPdfDocument = selectedPdfDocument;
    }

    public int getDndSupport() {
        return this.dndSupport;
    }

    public boolean isDrawDeletedItems() {
        return this.drawDeletedItems;
    }

    public void setDrawDeletedItems(boolean drawDeletedItems) {
        this.drawDeletedItems = drawDeletedItems;
    }

    public PdfThumbnailsLoader getPdfLoader() {
        return this.pdfLoader;
    }

    public JPanel getTopPanel() {
        return this.topPanel;
    }

    private String getSelectionString(Set<Integer> pages) {
        StringBuilder buffer = new StringBuilder();
        for (Integer page : pages) {
            buffer.append(page.toString()).append(",");
        }
        return StringUtils.chomp((String)buffer.toString(), (String)",");
    }

    private List<VisualSelectedItem> getSelectedItemsList() {
        ArrayList<VisualSelectedItem> retVal = new ArrayList<VisualSelectedItem>();
        List<VisualPageListItem> validElements = ((VisualListModel)this.thumbnailList.getModel()).getValidElements();
        VisualSelectedItem tmpElement = null;
        LinkedHashSet<Integer> pages = new LinkedHashSet<Integer>();
        for (VisualPageListItem currentElement : validElements) {
            if (tmpElement == null) {
                tmpElement = new VisualSelectedItem(currentElement.getParentFileCanonicalPath(), currentElement.getDocumentPassword());
                pages.add(currentElement.getPageNumber());
                continue;
            }
            if (!tmpElement.getSelectedFile().equals(currentElement.getParentFileCanonicalPath())) {
                tmpElement.setPagesSelection(this.getSelectionString(pages));
                retVal.add(tmpElement);
                tmpElement = new VisualSelectedItem(currentElement.getParentFileCanonicalPath(), currentElement.getDocumentPassword());
                pages.clear();
                pages.add(currentElement.getPageNumber());
                continue;
            }
            if (pages.add(currentElement.getPageNumber())) continue;
            tmpElement.setPagesSelection(this.getSelectionString(pages));
            retVal.add(tmpElement);
            tmpElement = new VisualSelectedItem(currentElement.getParentFileCanonicalPath(), currentElement.getDocumentPassword());
            pages.clear();
            pages.add(currentElement.getPageNumber());
        }
        tmpElement.setPagesSelection(this.getSelectionString(pages));
        retVal.add(tmpElement);
        return retVal;
    }

    public List<String> getValidConsoleParameters() {
        ArrayList<String> retVal = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (VisualSelectedItem item : this.getSelectedItemsList()) {
            builder.append(item.getPagesSelection()).append(":");
            retVal.add("-f");
            if (StringUtils.isEmpty((String)item.getPassword())) {
                retVal.add(item.getSelectedFile());
                continue;
            }
            retVal.add(item.getSelectedFile() + ":" + item.getPassword());
        }
        retVal.add("-u");
        retVal.add(builder.toString());
        return retVal;
    }

    public boolean hasValidElements() {
        List<VisualPageListItem> elements = ((VisualListModel)this.thumbnailList.getModel()).getValidElements();
        return elements != null && !elements.isEmpty();
    }

    public String getRotatedElementsString() {
        StringBuilder retVal = new StringBuilder();
        List<VisualPageListItem> validElements = ((VisualListModel)this.thumbnailList.getModel()).getValidElements();
        if (validElements != null && !validElements.isEmpty()) {
            int i = 0;
            for (VisualPageListItem currentElement : validElements) {
                ++i;
                if (Rotation.DEGREES_0.equals((Object)currentElement.getRotation())) continue;
                retVal.append(i).append(":").append(currentElement.getRotation().getDegrees()).append(",");
            }
        }
        return retVal.toString();
    }

    public void addToTopPanel(Component c) {
        this.topPanel.removeAll();
        if (c != null) {
            this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.topPanel.add(c);
        }
        if (this.topPanelStyle >= 3) {
            this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.topPanel.add(this.loadFileButton);
        }
        if (this.topPanelStyle >= 2) {
            this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.topPanel.add(this.clearButton);
        }
        this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.topPanel.add(this.documentProperties);
        this.topPanel.add(Box.createHorizontalGlue());
        this.topPanel.add(this.zoomInButton);
        this.topPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.topPanel.add(this.zoomOutButton);
    }

    public VisualPageListItem[] getSelectedElements() {
        Object[] elems = this.thumbnailList.getSelectedValues();
        VisualPageListItem[] visElems = new VisualPageListItem[elems.length];
        System.arraycopy(elems, 0, visElems, 0, elems.length);
        return visElems;
    }

    public void appendElements(Collection<VisualPageListItem> c) {
        ((VisualListModel)this.thumbnailList.getModel()).appendAllElements(c);
    }

    public void prependElements(Collection<VisualPageListItem> c) {
        ((VisualListModel)this.thumbnailList.getModel()).prependAllElements(c);
    }

    public void addMenuItem(JMenuItem item) {
        this.popupMenu.add(item);
    }

    public void enableSetOutputPathMenuItem() {
        this.menuItemSetOutputPath.setIcon(new ImageIcon(this.getClass().getResource("/images/set_outfile.png")));
        this.menuItemSetOutputPath.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set output file"));
        this.menuItemSetOutputPath.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (JVisualPdfPageSelectionPanel.this.selectedPdfDocument != null) {
                    try {
                        String defaultOutputPath = JVisualPdfPageSelectionPanel.this.selectedPdfDocument.getParent();
                        JVisualPdfPageSelectionPanel.this.firePropertyChange(JVisualPdfPageSelectionPanel.OUTPUT_PATH_PROPERTY, "", defaultOutputPath);
                    }
                    catch (Exception ex) {
                        log.error(GettextResource.gettext((ResourceBundle)JVisualPdfPageSelectionPanel.this.config.getI18nResourceBundle(), (String)"Error: Unable to get the file path."), ex);
                    }
                }
            }
        });
        this.popupMenu.add(this.menuItemSetOutputPath);
        if (!this.showContextMenu) {
            this.addPopupShower();
        }
    }

    private void addPopupShower() {
        this.thumbnailList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                int[] selection = JVisualPdfPageSelectionPanel.this.thumbnailList.getSelectedIndices();
                if (selection == null || selection.length <= 1) {
                    JVisualPdfPageSelectionPanel.this.thumbnailList.setSelectedIndex(JVisualPdfPageSelectionPanel.this.thumbnailList.locationToIndex(e.getPoint()));
                    selection = JVisualPdfPageSelectionPanel.this.thumbnailList.getSelectedIndices();
                }
                JVisualPdfPageSelectionPanel.this.menuItemPreview.setEnabled(selection != null && selection.length == 1);
                JVisualPdfPageSelectionPanel.this.popupMenu.show(JVisualPdfPageSelectionPanel.this.thumbnailList, e.getX(), e.getY());
            }
        });
    }

    public void disableSetOutputPathMenuItem() {
        this.popupMenu.remove(this.menuItemSetOutputPath);
    }

    public String getSelectedPdfDocumentPassword() {
        return this.selectedPdfDocumentPassword;
    }

    public void setSelectedPdfDocumentPassword(String selectedPdfDocumentPassword) {
        this.selectedPdfDocumentPassword = selectedPdfDocumentPassword;
    }

    public JButton getClearButton() {
        return this.clearButton;
    }

    public JButton getZoomInButton() {
        return this.zoomInButton;
    }

    public JButton getZoomOutButton() {
        return this.zoomOutButton;
    }

    public JButton getUndeleteButton() {
        return this.undeleteButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    public JButton getMoveUpButton() {
        return this.moveUpButton;
    }

    public JButton getMoveDownButton() {
        return this.moveDownButton;
    }

    public JButton getRotateButton() {
        return this.rotateButton;
    }

    public JButton getRotateAntiButton() {
        return this.rotateAntiButton;
    }

    public JButton getLoadFileButton() {
        return this.loadFileButton;
    }

    public JButton getReverseButton() {
        return this.reverseButton;
    }
}

