/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.l10n;

import java.util.Locale;
import java.util.ResourceBundle;

public class LanguageLoader {
    public static final String DEFAULT_LANGUAGE = "en_GB";
    public static final Locale DEFAULT_LOCALE = Locale.UK;
    private String bundleName;
    private Locale currentLocale;

    public LanguageLoader(String languageCode, String bundle) {
        this.bundleName = bundle;
        String[] i18nInfos = languageCode.split("_");
        try {
            this.currentLocale = i18nInfos.length > 1 ? new Locale(i18nInfos[0].toLowerCase(), i18nInfos[1].toUpperCase()) : new Locale(i18nInfos[0].toLowerCase());
        }
        catch (Exception ex) {
            this.currentLocale = DEFAULT_LOCALE;
        }
    }

    public ResourceBundle getBundle() {
        try {
            return ResourceBundle.getBundle(this.bundleName, this.currentLocale);
        }
        catch (Exception exc) {
            return ResourceBundle.getBundle(this.bundleName, DEFAULT_LOCALE);
        }
    }

    public ResourceBundle getBundle(ClassLoader cl) {
        try {
            return ResourceBundle.getBundle(this.bundleName, this.currentLocale, cl);
        }
        catch (Exception exc) {
            return ResourceBundle.getBundle(this.bundleName, DEFAULT_LOCALE, cl);
        }
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setLocale(Locale currentLocale) {
        this.currentLocale = currentLocale;
    }
}

