/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.dom.ElementChildrenArgsAdapter;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ElementArgsAdapter
implements IArgs {
    private final Element element;

    public ElementArgsAdapter(Element element) {
        this.element = element;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        throw new UnsupportedOperationException("can't write");
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new Iterator<IArgs.IBinding>(){
            private Iterator elements;
            private Iterator attributes;
            {
                this.elements = DOMTools.getElementIterator(ElementArgsAdapter.this.element);
                this.attributes = DOMTools.getAttributeIterator(ElementArgsAdapter.this.element);
            }

            @Override
            public boolean hasNext() {
                return this.elements.hasNext() || this.attributes.hasNext();
            }

            @Override
            public IArgs.IBinding next() {
                if (this.elements.hasNext()) {
                    Element element = (Element)this.elements.next();
                    return new Binding(element.getTagName());
                }
                if (this.attributes.hasNext()) {
                    Attr attr = (Attr)this.attributes.next();
                    return new Binding(attr.getName());
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("can't write");
    }

    @Override
    public IArgs copy() {
        return new ElementArgsAdapter(this.element);
    }

    @Override
    public IArgs.IBinding declare(String string) {
        return new Binding(string);
    }

    @Override
    public Object get(int n) {
        return null;
    }

    @Override
    public Object get(int n, Object object) {
        return object;
    }

    @Override
    public Object get(String string) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            Element[] elementArray = DOMTools.getElements(this.element, string);
            if (elementArray != null && elementArray.length > 0) {
                return new ElementChildrenArgsAdapter(elementArray);
            }
            return null;
        }
        return attr.getValue();
    }

    @Override
    public Object get(String string, Object object) {
        Attr attr = this.element.getAttributeNode(string);
        if (attr == null) {
            Element[] elementArray = DOMTools.getElements(this.element, string);
            if (elementArray != null && elementArray.length > 0) {
                return new ElementChildrenArgsAdapter(elementArray);
            }
            return object;
        }
        return attr.getValue();
    }

    @Override
    public boolean isDefined(String string) {
        return this.get(string) != null;
    }

    public Set names() {
        return Collections.EMPTY_SET;
    }

    @Override
    public IArgs.IBinding put(int n, Object object) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    @Override
    public IArgs.IBinding put(String string, Object object) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    @Override
    public int size() {
        return 0;
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }

    @Override
    public void undefine(int n) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    @Override
    public void undefine(String string) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    protected class Binding
    implements IArgs.IBinding {
        private String name;

        public Binding(String string) {
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return ElementArgsAdapter.this.get(this.name);
        }

        @Override
        public boolean isDefined() {
            return ElementArgsAdapter.this.isDefined(this.name);
        }

        @Override
        public void setValue(Object object) {
            ElementArgsAdapter.this.put(this.name, object);
        }
    }
}

