/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FileSnapshot {
    private final File file;
    private List<FileSnapshot> children;
    private final boolean directory;
    private long fileLength = 0L;
    private long lastModified = 0L;

    public FileSnapshot(File file) {
        this.file = file;
        this.directory = file.isDirectory();
        this.updateLocal(file.length(), file.lastModified());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.updateChildren(Arrays.asList(fileArray));
        }
    }

    public FileSnapshot[] getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.toArray(new FileSnapshot[this.children.size()]);
    }

    public File getFile() {
        return this.file;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    /*
     * Loose catch block
     */
    public boolean isAvailable() {
        if (this.children != null) {
            for (FileSnapshot fileSnapshot : this.children) {
                if (fileSnapshot.isAvailable()) continue;
                return false;
            }
            return true;
        }
        if (this.directory) {
            return !this.isLost();
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getFile());
        }
        catch (Exception exception) {
            StreamTools.close(fileInputStream);
            return false;
            catch (Throwable throwable) {
                StreamTools.close(fileInputStream);
                throw throwable;
            }
        }
        StreamTools.close(fileInputStream);
        return true;
    }

    public boolean isChanged() {
        long l = this.getFile().lastModified();
        long l2 = this.getFile().length();
        File[] fileArray = this.getFile().listFiles();
        ArrayList<File> arrayList = fileArray == null ? null : new ArrayList<File>(Arrays.asList(fileArray));
        boolean bl = this.getFile().exists();
        if (!bl) {
            this.children = null;
            return true;
        }
        boolean bl2 = false;
        if (this.children != null) {
            Iterator<FileSnapshot> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                FileSnapshot fileSnapshot = iterator.next();
                if (fileSnapshot.isChanged()) {
                    bl2 = true;
                    if (fileSnapshot.isLost()) {
                        iterator.remove();
                    }
                }
                if (arrayList == null) continue;
                arrayList.remove(fileSnapshot.getFile());
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            this.updateChildren(arrayList);
            bl2 = true;
        }
        if (l != this.lastModified || l2 != this.fileLength) {
            this.updateLocal(l2, l);
            bl2 = true;
        }
        return bl2;
    }

    public boolean isLost() {
        return !this.getFile().exists();
    }

    protected void updateChildren(List<File> list) {
        if (this.children == null) {
            this.children = new ArrayList<FileSnapshot>();
        }
        for (File file : list) {
            this.children.add(new FileSnapshot(file));
        }
    }

    protected void updateLocal(long l, long l2) {
        this.fileLength = l;
        this.lastModified = l2;
    }
}

