/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reporter;

import de.intarsys.tools.reporter.IReporter;
import de.intarsys.tools.reporter.IReporterSupport;

public class ReportDispatcher
implements IReporterSupport,
IReporter {
    private final Object owner;
    private IReporter[] reporters = new IReporter[2];

    public ReportDispatcher(Object object) {
        this.owner = object;
    }

    @Override
    public synchronized void addReporter(IReporter iReporter) {
        if (iReporter == null) {
            throw new NullPointerException("reporter may not be null");
        }
        int n = this.reporters.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.reporters[n2] == null) break;
            ++n2;
        }
        if (n2 >= n) {
            IReporter[] iReporterArray = new IReporter[n + 4];
            System.arraycopy(this.reporters, 0, iReporterArray, 0, n);
            this.reporters = iReporterArray;
        }
        this.reporters[n2] = iReporter;
    }

    public synchronized void attach(IReporterSupport iReporterSupport) {
        int n = this.reporters.length;
        int n2 = 0;
        while (n2 < n) {
            iReporterSupport.addReporter(this.reporters[n2]);
            ++n2;
        }
    }

    public synchronized void clear() {
        this.reporters = new IReporter[4];
    }

    public synchronized void detach(IReporterSupport iReporterSupport) {
        int n = this.reporters.length;
        int n2 = 0;
        while (n2 < n) {
            iReporterSupport.removeReporter(this.reporters[n2]);
            ++n2;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized boolean isEmpty() {
        int n = 0;
        while (n < this.reporters.length) {
            if (this.reporters[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public synchronized void removeReporter(IReporter iReporter) {
        int n = this.reporters.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.reporters[n2] == iReporter) {
                this.reporters[n2] = null;
                break;
            }
            ++n2;
        }
    }

    @Override
    public void reportActivityEnd() {
        int n = this.reporters.length;
        int n2 = 0;
        while (n2 < n) {
            IReporter iReporter = this.reporters[n2];
            if (iReporter != null) {
                iReporter.reportActivityEnd();
            }
            ++n2;
        }
    }

    @Override
    public void reportActivityStart(String string, int n) {
        int n2 = this.reporters.length;
        int n3 = 0;
        while (n3 < n2) {
            IReporter iReporter = this.reporters[n3];
            if (iReporter != null) {
                iReporter.reportActivityStart(string, n);
            }
            ++n3;
        }
    }

    @Override
    public void reportError(String string, String string2, Throwable throwable, int n) {
        int n2 = this.reporters.length;
        int n3 = 0;
        while (n3 < n2) {
            IReporter iReporter = this.reporters[n3];
            if (iReporter != null) {
                iReporter.reportError(string, string2, throwable, n);
            }
            ++n3;
        }
    }

    @Override
    public void reportMessage(String string, String string2, int n) {
        int n2 = this.reporters.length;
        int n3 = 0;
        while (n3 < n2) {
            IReporter iReporter = this.reporters[n3];
            if (iReporter != null) {
                iReporter.reportMessage(string, string2, n);
            }
            ++n3;
        }
    }

    @Override
    public void reportProgress(String string, int n, int n2) {
        int n3 = this.reporters.length;
        int n4 = 0;
        while (n4 < n3) {
            IReporter iReporter = this.reporters[n4];
            if (iReporter != null) {
                iReporter.reportProgress(string, n, n2);
            }
            ++n4;
        }
    }

    @Override
    public void reportStatus(String string, int n) {
        int n2 = this.reporters.length;
        int n3 = 0;
        while (n3 < n2) {
            IReporter iReporter = this.reporters[n3];
            if (iReporter != null) {
                iReporter.reportStatus(string, n);
            }
            ++n3;
        }
    }
}

