/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.file.FileTools;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

public class StringTools {
    public static final String CR = "\r";
    public static final String CRLF = "\r\n";
    public static final String DATEFORMAT_SIMPLE = "yy-MM-dd HH:mm:ss:SSSS";
    private static DateFormat DEFAULT_DATEFORMAT;
    public static final String EMPTY = "";
    public static final String FORMAT_D = "d";
    public static final String FORMAT_F = "f";
    public static final String FORMAT_I = "i";
    public static final String FORMAT_P = "p";
    public static final String FORMAT_S = "s";
    public static final String LF = "\n";
    private static final String[] NO_ARGS;
    public static final String SPACE = " ";

    static {
        NO_ARGS = new String[0];
    }

    public static String breakForced(String string, int n, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            int n2;
            int n3 = 0;
            int n4 = n;
            int n5 = n2 = string.length();
            while (n5 > n) {
                stringBuilder.append(string.substring(n3, n4));
                n3 += n;
                n4 += n;
                if ((n5 -= n) <= 0) continue;
                stringBuilder.append(string2);
            }
            if (n4 > n2) {
                n4 = n2;
            }
            stringBuilder.append(string.substring(n3, n4));
        }
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        if (StringTools.isEmpty(string)) {
            return EMPTY;
        }
        String string2 = string.substring(0, 1);
        string2 = string2.toUpperCase();
        if (string.length() > 1) {
            return String.valueOf(string2) + string.substring(1);
        }
        return string2;
    }

    public static void clear(char[] cArray) {
        if (cArray == null) {
            return;
        }
        Arrays.fill(cArray, '0');
    }

    public static String format(Object object, String string) {
        if (object == null) {
            return EMPTY;
        }
        if (string.startsWith(FORMAT_S)) {
            return StringTools.formatString(object, string.substring(1));
        }
        if (string.startsWith(FORMAT_F)) {
            return StringTools.formatFloat(object, string.substring(1));
        }
        if (string.startsWith(FORMAT_I)) {
            return StringTools.formatInteger(object, string.substring(1));
        }
        if (string.startsWith(FORMAT_D)) {
            return StringTools.formatDate(object, string.substring(1));
        }
        if (string.startsWith(FORMAT_P)) {
            return StringTools.formatPath(object, string.substring(1));
        }
        if (object instanceof Date) {
            return new SimpleDateFormat(DATEFORMAT_SIMPLE).format(object);
        }
        if (object instanceof Long) {
            return Long.toString((Long)object, 32);
        }
        return object.toString();
    }

    protected static String formatDate(Object object, String string) {
        Date date = null;
        if (object instanceof Date) {
            date = (Date)object;
        } else if (object instanceof Number) {
            date = new Date(((Number)object).longValue());
        } else {
            if (object instanceof String) {
                return (String)object;
            }
            return EMPTY;
        }
        if (StringTools.isEmpty(string)) {
            return StringTools.formatDateDefault(date);
        }
        String string2 = StringTools.parseArgsString(string);
        if (string2 == null) {
            int n = 43;
            int n2 = string.charAt(0);
            if (n2 == 100 || n2 == 116) {
                n = n2;
                n2 = string.length() > 1 ? (int)string.charAt(1) : 102;
            }
            if (n == 100) {
                if (n2 == 115) {
                    DateFormat dateFormat = DateFormat.getDateInstance(3);
                    return dateFormat.format(date);
                }
                if (n2 == 109) {
                    DateFormat dateFormat = DateFormat.getDateInstance(2);
                    return dateFormat.format(date);
                }
                if (n2 == 102) {
                    DateFormat dateFormat = DateFormat.getDateInstance(0);
                    return dateFormat.format(date);
                }
            } else if (n == 116) {
                if (n2 == 115) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(3);
                    return dateFormat.format(date);
                }
                if (n2 == 109) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(2);
                    return dateFormat.format(date);
                }
                if (n2 == 102) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(0);
                    return dateFormat.format(date);
                }
            } else {
                if (n2 == 115) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                    return dateFormat.format(date);
                }
                if (n2 == 109) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
                    return dateFormat.format(date);
                }
                if (n2 == 102) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
                    return dateFormat.format(date);
                }
            }
            return StringTools.formatDateDefault(date);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        try {
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return StringTools.formatDateDefault(date);
        }
    }

    protected static synchronized String formatDateDefault(Date date) {
        if (DEFAULT_DATEFORMAT == null) {
            DEFAULT_DATEFORMAT = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss_SSS");
        }
        return DEFAULT_DATEFORMAT.format(date);
    }

    protected static String formatFloat(Object object, String string) {
        if (object == null) {
            return EMPTY;
        }
        double d = 0.0;
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else if (object instanceof Date) {
            d = ((Date)object).getTime();
        } else if (object instanceof String) {
            try {
                d = Double.parseDouble((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return (String)object;
            }
        } else {
            return object.toString();
        }
        String string2 = StringTools.parseArgsString(string);
        NumberFormat numberFormat = null;
        numberFormat = string2 == null ? NumberFormat.getNumberInstance() : new DecimalFormat(string2);
        try {
            return numberFormat.format(d);
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    protected static String formatInteger(Object object, String string) {
        if (object == null) {
            return EMPTY;
        }
        int n = 100;
        if (string.length() > 1) {
            n = string.charAt(1);
        }
        long l = 0L;
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        } else if (object instanceof Date) {
            l = ((Date)object).getTime();
        } else if (object instanceof String) {
            try {
                l = Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                return (String)object;
            }
        } else {
            return object.toString();
        }
        try {
            if (n == 98) {
                return Long.toString(l, 2);
            }
            if (n == 111) {
                return Long.toString(l, 8);
            }
            if (n == 100) {
                return Long.toString(l, 10);
            }
            if (n == 120) {
                return Long.toString(l, 16);
            }
            return Long.toString(l, 10);
        }
        catch (Exception exception) {
            return object.toString();
        }
    }

    protected static String formatPath(Object object, String string) {
        return FileTools.trimPath(StringTools.safeString(object));
    }

    protected static String formatString(Object object, String string) {
        String string2 = null;
        string2 = object == null ? EMPTY : object.toString();
        String[] stringArray = StringTools.parseArgs(string);
        if (stringArray.length == 0) {
            return string2;
        }
        int n = 0;
        int n2 = string2.length() - 1;
        try {
            n = Integer.parseInt(stringArray[0]);
            if (stringArray.length == 2) {
                n2 = Integer.parseInt(stringArray[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return string2;
        }
        if (n < 0) {
            n = string2.length() + n;
        }
        if (n2 < 0) {
            n2 = string2.length() + n2;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n > n2) {
            n2 = n - 1;
        }
        if (n > string2.length()) {
            n = string2.length();
        }
        if (n2 >= string2.length()) {
            n2 = string2.length() - 1;
        }
        return string2.substring(n, n2 + 1);
    }

    public static String getCommonPrefix(String string, String string2, boolean bl) {
        String string3;
        String string4;
        int n;
        int n2 = string.length();
        int n3 = n2 > (n = string2.length()) ? n : n2;
        int n4 = 0;
        if (bl) {
            string4 = string.toLowerCase();
            string3 = string2.toLowerCase();
        } else {
            string4 = string;
            string3 = string2;
        }
        while (n4 < n3) {
            if (string4.charAt(n4) != string3.charAt(n4)) break;
            ++n4;
        }
        return string.substring(0, n4);
    }

    public static String getFirstLine(String string) {
        int n;
        if (string == null) {
            return EMPTY;
        }
        int n2 = string.indexOf(CR);
        if (n2 == -1) {
            n2 = string.length();
        }
        if ((n = string.indexOf(LF)) == -1) {
            n = string.length();
        }
        return string.substring(0, n2 > n ? n : n2);
    }

    public static String getLeading(String string, int n) {
        if (string == null || string.length() <= n || n <= 3) {
            return string;
        }
        return String.valueOf(string.substring(0, n - 3)) + "...";
    }

    public static int getLineCount(String string) {
        int n = 1;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\n') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static String getTrailing(String string, int n) {
        if (string == null || string.length() <= n) {
            return string;
        }
        return "..." + string.substring(string.length() - n + 3, string.length());
    }

    public static boolean isEmpty(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return true;
        }
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isWhitespace(cArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0 || string.trim().length() == 0;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return Character.isDigit(c) || c == '-' || c == '+' || c == '.';
    }

    public static String join(List<String> list, String string) {
        return StringTools.join(list.toArray(new String[0]), string);
    }

    public static String join(String[] stringArray, String string) {
        int n = stringArray.length - 1;
        if (n == -1) {
            return EMPTY;
        }
        if (n == 0) {
            return stringArray[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(stringArray[n2]);
            if (string != null) {
                stringBuilder.append(string);
            }
            ++n2;
        }
        stringBuilder.append(stringArray[n]);
        return stringBuilder.toString();
    }

    public static String padLeft(String string, int n) {
        if (string == null || string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n - string.length();
        while (n2 > 0) {
            stringBuilder.append(SPACE);
            --n2;
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String padRight(String string, int n) {
        if (string == null || string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        int n2 = n - string.length();
        while (n2 > 0) {
            stringBuilder.append(SPACE);
            --n2;
        }
        return stringBuilder.toString();
    }

    protected static String[] parseArgs(String string) {
        String string2 = StringTools.parseArgsString(string);
        if (string2 == null) {
            return NO_ARGS;
        }
        return string2.split(",");
    }

    protected static String parseArgsString(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n == -1 || n2 == -1 || n > n2) {
            return null;
        }
        return string.substring(n + 1, n2);
    }

    public static String[] parseCommandline(String string) {
        return StringTools.parseCommandline(string, '\\');
    }

    public static String[] parseCommandline(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (bl3) {
                if (c2 == '\n') {
                    bl3 = false;
                }
            } else if (bl) {
                bl = false;
                if (c2 != '\"') {
                    stringBuilder.append(c);
                }
                stringBuilder.append(c2);
            } else if (c2 == c) {
                bl = true;
            } else if (c2 == '\"') {
                bl2 = !bl2;
            } else if (!bl2 && c2 == '#') {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                bl3 = true;
            } else if (!bl2 && Character.isWhitespace(c2)) {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
            } else {
                stringBuilder.append(c2);
            }
            ++n;
        }
        if (bl) {
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String pathAppend(String string, String string2, String string3) {
        if (StringTools.isEmpty(string)) {
            return string3;
        }
        return String.valueOf(string) + string2 + string3;
    }

    public static String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '\"') {
                stringBuilder.append('\\');
            } else if (c == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
            ++n;
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static String safeString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (RuntimeException runtimeException) {
            return "<unprintable>";
        }
    }

    public static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        return byArray;
    }

    public static String toCamelCase(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String[] stringArray;
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) >= 0) continue;
            String string4 = EMPTY;
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            if ((n = (stringArray = string3.split("[^a-zA-Z0-9]")).length) == 1) {
                String string5 = stringArray[0];
                if (string5.length() > 0) {
                    if (Character.isLowerCase(string5.charAt(0))) {
                        stringBuilder.append(string5);
                    } else {
                        stringBuilder.append(string5.toLowerCase());
                    }
                } else {
                    stringBuilder.append(string5.toLowerCase());
                }
            } else {
                int n2 = 0;
                while (n2 < n) {
                    String string6 = stringArray[n2];
                    if (string6.length() > 0) {
                        if (n2 == 0) {
                            stringBuilder.append(Character.toLowerCase(string6.charAt(0)));
                        } else {
                            stringBuilder.append(Character.toUpperCase(string6.charAt(0)));
                        }
                        stringBuilder.append(string6.substring(1).toLowerCase());
                    }
                    ++n2;
                }
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public static String toString(byte[] byArray) {
        return new String(byArray, 0);
    }

    public static String trimAlphaNumeric(String string) {
        StringReader stringReader = new StringReader(string);
        char[] cArray = new char[1];
        StringWriter stringWriter = new StringWriter();
        try {
            while (stringReader.read(cArray) != -1) {
                if (!Character.isLetterOrDigit(cArray[0])) continue;
                stringWriter.write(cArray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String trimLeft(String string) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isWhitespace(string.charAt(n))) break;
            ++n;
        }
        return string.substring(n);
    }

    public static String trimRight(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            if (!Character.isWhitespace(string.charAt(n))) break;
            --n;
        }
        return string.substring(0, n + 1);
    }

    public static String unquote(String string) throws IOException {
        char c;
        int n = 0;
        char[] cArray = string.toCharArray();
        if (n == cArray.length) {
            return EMPTY;
        }
        if ((c = cArray[n++]) != '\"') {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (n == cArray.length) {
                throw new IOException("preliminary end of input");
            }
            if ((c = cArray[n++]) == '\\') {
                if (n == cArray.length) {
                    throw new IOException("preliminary end of input");
                }
                c = cArray[n++];
                stringBuilder.append(c);
                continue;
            }
            if (c == '\"') {
                if (n == cArray.length) break;
                throw new IOException("preliminary end of quoted string");
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

