/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.eclipse.jdt.internal.compiler.apt.util.Util;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;

public class ArchiveFileObject
implements JavaFileObject {
    private ZipEntry zipEntry;
    private ZipFile zipFile;
    private String entryName;
    private File file;
    private Charset charset;

    public ArchiveFileObject(File file, ZipFile zipFile, String string, Charset charset) {
        this.zipFile = zipFile;
        this.zipEntry = zipFile.getEntry(string);
        this.entryName = string;
        this.file = file;
        this.charset = charset;
    }

    @Override
    public Modifier getAccessLevel() {
        if (this.getKind() != JavaFileObject.Kind.CLASS) {
            return null;
        }
        ClassFileReader classFileReader = null;
        try {
            classFileReader = ClassFileReader.read(this.zipFile, this.entryName);
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (classFileReader == null) {
            return null;
        }
        int n = classFileReader.accessFlags();
        if ((n & 1) != 0) {
            return Modifier.PUBLIC;
        }
        if ((n & 0x400) != 0) {
            return Modifier.ABSTRACT;
        }
        if ((n & 0x10) != 0) {
            return Modifier.FINAL;
        }
        return null;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        String string = this.entryName.toLowerCase();
        if (string.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (string.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (string.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public NestingKind getNestingKind() {
        switch (this.getKind()) {
            case SOURCE: {
                return NestingKind.TOP_LEVEL;
            }
            case CLASS: {
                ClassFileReader classFileReader = null;
                try {
                    classFileReader = ClassFileReader.read(this.zipFile, this.entryName);
                }
                catch (ClassFormatException classFormatException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (classFileReader == null) {
                    return null;
                }
                if (classFileReader.isAnonymous()) {
                    return NestingKind.ANONYMOUS;
                }
                if (classFileReader.isLocal()) {
                    return NestingKind.LOCAL;
                }
                if (classFileReader.isMember()) {
                    return NestingKind.MEMBER;
                }
                return NestingKind.TOP_LEVEL;
            }
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        return this.zipEntry.getName().endsWith(string + kind.extension);
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArchiveFileObject)) {
            return false;
        }
        ArchiveFileObject archiveFileObject = (ArchiveFileObject)object;
        return archiveFileObject.toUri().equals(this.toUri());
    }

    @Override
    public CharSequence getCharContent(boolean bl) throws IOException {
        if (this.getKind() == JavaFileObject.Kind.SOURCE) {
            return Util.getCharContents(this, bl, org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(this.zipEntry, this.zipFile), this.charset.name());
        }
        return null;
    }

    @Override
    public long getLastModified() {
        return this.zipEntry.getTime();
    }

    @Override
    public String getName() {
        return this.zipEntry.getName();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.zipFile.getInputStream(this.zipEntry);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URI toUri() {
        try {
            return new URI("jar:" + this.file.toURI().getPath() + "!" + this.zipEntry.getName());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        return this.file.getAbsolutePath() + "[" + this.zipEntry.getName() + "]";
    }
}

