/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.lib.profiler.heap.AbstractLongMap;
import org.netbeans.lib.profiler.heap.NumberList;

class LongMap
extends AbstractLongMap {
    private NumberList referenceList;

    LongMap(int n, int n2, int n3) throws FileNotFoundException, IOException {
        super(n, n2, n3, n3 + 4 + 1 + n2 + 4);
        this.referenceList = new NumberList(this.ID_SIZE);
    }

    @Override
    Entry createEntry(long l) {
        return new Entry(l);
    }

    @Override
    Entry createEntry(long l, long l2) {
        return new Entry(l, l2);
    }

    @Override
    Entry get(long l) {
        return (Entry)super.get(l);
    }

    @Override
    Entry put(long l, long l2) {
        return (Entry)super.put(l, l2);
    }

    void flush() {
        this.referenceList.flush();
    }

    long[] getBiggestObjectsByRetainedSize(int n) {
        TreeSet<RetainedSizeEntry> treeSet = new TreeSet<RetainedSizeEntry>();
        long[] lArray = new long[n];
        int n2 = 0;
        for (long i = 0L; i < this.fileSize; i += (long)this.ENTRY_SIZE) {
            long l = this.getID(i);
            if (l == 0L) continue;
            int n3 = this.createEntry(i).getRetainedSize();
            if (treeSet.size() < n) {
                treeSet.add(new RetainedSizeEntry(l, n3));
                n2 = ((RetainedSizeEntry)treeSet.last()).retainedSize;
                continue;
            }
            if (n3 <= n2) continue;
            treeSet.remove(treeSet.last());
            treeSet.add(new RetainedSizeEntry(l, n3));
            n2 = ((RetainedSizeEntry)treeSet.last()).retainedSize;
        }
        int n4 = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            lArray[n4++] = ((RetainedSizeEntry)iterator.next()).instanceId;
        }
        return lArray;
    }

    private static class RetainedSizeEntry
    implements Comparable {
        private final long instanceId;
        private final int retainedSize;

        private RetainedSizeEntry(long l, int n) {
            this.instanceId = l;
            this.retainedSize = n;
        }

        public int compareTo(Object object) {
            RetainedSizeEntry retainedSizeEntry = (RetainedSizeEntry)object;
            int n = retainedSizeEntry.retainedSize - this.retainedSize;
            if (n == 0) {
                long l = retainedSizeEntry.instanceId - this.instanceId;
                if (l < 0L) {
                    return -1;
                }
                if (l > 0L) {
                    return 1;
                }
                return 0;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            RetainedSizeEntry retainedSizeEntry = (RetainedSizeEntry)object;
            return this.instanceId == retainedSizeEntry.instanceId;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + (int)(this.instanceId ^ this.instanceId >>> 32);
            return n;
        }
    }

    class Entry
    extends AbstractLongMap.Entry {
        private static final byte NUMBER_LIST = 1;
        private static final byte GC_ROOT = 2;
        private static final byte TREE_OBJ = 4;
        private long offset;

        private Entry(long l) {
            this.offset = l;
        }

        private Entry(long l, long l2) {
            this.offset = l;
            LongMap.this.putFoffset(this.offset + (long)LongMap.this.KEY_SIZE, l2);
        }

        void setIndex(int n) {
            LongMap.this.dumpBuffer.putInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE, n);
        }

        int getIndex() {
            return LongMap.this.dumpBuffer.getInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE);
        }

        void setTreeObj() {
            byte by = (byte)(this.getFlags() | 4);
            this.setFlags(by);
        }

        boolean isTreeObj() {
            return (this.getFlags() & 4) != 0;
        }

        boolean hasOnlyOneReference() {
            return (this.getFlags() & 1) == 0;
        }

        void setNearestGCRootPointer(long l) {
            byte by = (byte)(this.getFlags() | 2);
            this.setFlags(by);
            if ((by & 1) != 0) {
                try {
                    LongMap.this.referenceList.putFirst(this.getReferencesPointer(), l);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }

        long getNearestGCRootPointer() {
            try {
                byte by = this.getFlags();
                if ((by & 2) != 0) {
                    long l = this.getReferencesPointer();
                    if ((by & 1) != 0) {
                        return LongMap.this.referenceList.getFirstNumber(l);
                    }
                    return l;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return 0L;
        }

        void addReference(long l) {
            try {
                byte by = this.getFlags();
                long l2 = this.getReferencesPointer();
                if ((by & 1) == 0) {
                    if (l2 == 0L) {
                        this.setReferencesPointer(l);
                    } else if (l2 != l) {
                        this.setFlags((byte)(by | 1));
                        long l3 = LongMap.this.referenceList.addFirstNumber(l2, l);
                        this.setReferencesPointer(l3);
                    }
                } else {
                    long l4 = LongMap.this.referenceList.addNumber(l2, l);
                    if (l4 != l2) {
                        this.setReferencesPointer(l4);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        List getReferences() {
            byte by = this.getFlags();
            long l = this.getReferencesPointer();
            if ((by & 1) == 0) {
                if (l == 0L) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.singletonList(new Long(l));
            }
            try {
                return LongMap.this.referenceList.getNumbers(l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return Collections.EMPTY_LIST;
            }
        }

        long getOffset() {
            return LongMap.this.getFoffset(this.offset + (long)LongMap.this.KEY_SIZE);
        }

        void setRetainedSize(int n) {
            LongMap.this.dumpBuffer.putInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L + (long)LongMap.this.ID_SIZE, n);
        }

        int getRetainedSize() {
            return LongMap.this.dumpBuffer.getInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L + (long)LongMap.this.ID_SIZE);
        }

        private void setReferencesPointer(long l) {
            LongMap.this.putID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L, l);
        }

        private long getReferencesPointer() {
            return LongMap.this.getID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L);
        }

        private void setFlags(byte by) {
            LongMap.this.dumpBuffer.putByte(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L, by);
        }

        private byte getFlags() {
            return LongMap.this.dumpBuffer.getByte(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L);
        }
    }
}

