/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.jdk;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.common.logging.jdk.ESLogRecord;
import org.elasticsearch.common.logging.support.AbstractESLogger;

public class JdkESLogger
extends AbstractESLogger {
    private final Logger logger;

    public JdkESLogger(String prefix, Logger logger) {
        super(prefix);
        this.logger = logger;
    }

    @Override
    public void setLevel(String level) {
        if (level == null) {
            this.logger.setLevel(null);
        } else if ("error".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.SEVERE);
        } else if ("warn".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.WARNING);
        } else if ("info".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.INFO);
        } else if ("debug".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.FINE);
        } else if ("trace".equalsIgnoreCase(level)) {
            this.logger.setLevel(Level.FINEST);
        }
    }

    @Override
    public String getLevel() {
        if (this.logger.getLevel() == null) {
            return null;
        }
        return this.logger.getLevel().toString();
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    protected void internalTrace(String msg) {
        ESLogRecord record = new ESLogRecord(Level.FINEST, msg);
        this.logger.log(record);
    }

    @Override
    protected void internalTrace(String msg, Throwable cause) {
        ESLogRecord record = new ESLogRecord(Level.FINEST, msg);
        record.setThrown(cause);
        this.logger.log(record);
    }

    @Override
    protected void internalDebug(String msg) {
        ESLogRecord record = new ESLogRecord(Level.FINE, msg);
        this.logger.log(record);
    }

    @Override
    protected void internalDebug(String msg, Throwable cause) {
        ESLogRecord record = new ESLogRecord(Level.FINE, msg);
        record.setThrown(cause);
        this.logger.log(record);
    }

    @Override
    protected void internalInfo(String msg) {
        ESLogRecord record = new ESLogRecord(Level.INFO, msg);
        this.logger.log(record);
    }

    @Override
    protected void internalInfo(String msg, Throwable cause) {
        ESLogRecord record = new ESLogRecord(Level.INFO, msg);
        record.setThrown(cause);
        this.logger.log(record);
    }

    @Override
    protected void internalWarn(String msg) {
        ESLogRecord record = new ESLogRecord(Level.WARNING, msg);
        this.logger.log(record);
    }

    @Override
    protected void internalWarn(String msg, Throwable cause) {
        ESLogRecord record = new ESLogRecord(Level.WARNING, msg);
        record.setThrown(cause);
        this.logger.log(record);
    }

    @Override
    protected void internalError(String msg) {
        ESLogRecord record = new ESLogRecord(Level.SEVERE, msg);
        this.logger.log(record);
    }

    @Override
    protected void internalError(String msg, Throwable cause) {
        ESLogRecord record = new ESLogRecord(Level.SEVERE, msg);
        record.setThrown(cause);
        this.logger.log(record);
    }

    protected Logger logger() {
        return this.logger;
    }
}

