/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.ScaleAtom;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.SmashedAtom;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;

public class XLeftRightArrowFactory {
    private static final Atom MINUS = SymbolAtom.get("minus");
    private static final Atom LEFT = SymbolAtom.get("leftarrow");
    private static final Atom RIGHT = SymbolAtom.get("rightarrow");

    public static Box create(boolean bl, TeXEnvironment teXEnvironment, float f) {
        float f2;
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Box box = bl ? LEFT.createBox(teXEnvironment) : RIGHT.createBox(teXEnvironment);
        float f3 = box.getHeight();
        float f4 = box.getDepth();
        float f5 = box.getWidth();
        if (f <= f5) {
            box.setDepth(f4 / 2.0f);
            return box;
        }
        Box box2 = new SmashedAtom(MINUS, "").createBox(teXEnvironment);
        Box box3 = new SpaceAtom(5, -4.0f, 0.0f, 0.0f).createBox(teXEnvironment);
        float f6 = box2.getWidth() + box3.getWidth();
        f5 += box3.getWidth();
        HorizontalBox horizontalBox = new HorizontalBox();
        for (f2 = 0.0f; f2 < f - f5 - f6; f2 += f6) {
            horizontalBox.add(box2);
            horizontalBox.add(box3);
        }
        float f7 = (f - f5 - f2) / box2.getWidth();
        horizontalBox.add(new SpaceAtom(5, -2.0f * f7, 0.0f, 0.0f).createBox(teXEnvironment));
        horizontalBox.add(new ScaleAtom(MINUS, f7, 1.0).createBox(teXEnvironment));
        if (bl) {
            horizontalBox.add(0, new SpaceAtom(5, -3.5f, 0.0f, 0.0f).createBox(teXEnvironment));
            horizontalBox.add(0, box);
        } else {
            horizontalBox.add(new SpaceAtom(5, -2.0f * f7 - 2.0f, 0.0f, 0.0f).createBox(teXEnvironment));
            horizontalBox.add(box);
        }
        horizontalBox.setDepth(f4 / 2.0f);
        horizontalBox.setHeight(f3);
        return horizontalBox;
    }

    public static Box create(TeXEnvironment teXEnvironment, float f) {
        float f2;
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Box box = LEFT.createBox(teXEnvironment);
        Box box2 = RIGHT.createBox(teXEnvironment);
        float f3 = box.getWidth() + box2.getWidth();
        if (f < f3) {
            HorizontalBox horizontalBox = new HorizontalBox(box);
            horizontalBox.add(new StrutBox(-Math.min(f3 - f, box.getWidth()), 0.0f, 0.0f, 0.0f));
            horizontalBox.add(box2);
            return horizontalBox;
        }
        Box box3 = new SmashedAtom(MINUS, "").createBox(teXEnvironment);
        Box box4 = new SpaceAtom(5, -3.4f, 0.0f, 0.0f).createBox(teXEnvironment);
        float f4 = box3.getWidth() + box4.getWidth();
        f3 += 2.0f * box4.getWidth();
        HorizontalBox horizontalBox = new HorizontalBox();
        for (f2 = 0.0f; f2 < f - f3 - f4; f2 += f4) {
            horizontalBox.add(box3);
            horizontalBox.add(box4);
        }
        horizontalBox.add(new ScaleBox(box3, (f - f3 - f2) / box3.getWidth(), 1.0));
        horizontalBox.add(0, box4);
        horizontalBox.add(0, box);
        horizontalBox.add(box4);
        horizontalBox.add(box2);
        return horizontalBox;
    }
}

