/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.InputStream;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.util.GFileUtils;

public class DefaultFileTreeElement
extends AbstractFileTreeElement {
    private final File file;
    private final RelativePath relativePath;
    private final Stat stat;

    public DefaultFileTreeElement(File file, RelativePath relativePath, Chmod chmod, Stat stat) {
        super(chmod);
        this.file = file;
        this.relativePath = relativePath;
        this.stat = stat;
    }

    public File getFile() {
        return this.file;
    }

    public String getDisplayName() {
        return String.format("file '%s'", this.file);
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public long getSize() {
        return this.file.length();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public InputStream open() {
        return GFileUtils.openInputStream(this.file);
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public int getMode() {
        return this.stat.getUnixMode(this.file);
    }
}

