/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.sun.nio.file.ExtendedWatchEventModifier;
import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.internal.FileUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.os.OperatingSystem;

class WatchServiceRegistrar
implements FileWatcherListener {
    private static final boolean FILE_TREE_WATCHING_SUPPORTED;
    private static final WatchEvent.Modifier[] WATCH_MODIFIERS;
    private static final WatchEvent.Kind[] WATCH_KINDS;
    private final WatchService watchService;
    private final FileWatcherListener delegate;
    private FileSystemSubset fileSystemSubset;
    private FileSystemSubset unfilteredFileSystemSubset;
    private Iterable<? extends File> roots;

    WatchServiceRegistrar(WatchService watchService, FileWatcherListener delegate) {
        this.watchService = watchService;
        this.delegate = delegate;
    }

    void watch(FileSystemSubset fileSystemSubset) throws IOException {
        this.fileSystemSubset = fileSystemSubset;
        this.unfilteredFileSystemSubset = fileSystemSubset.unfiltered();
        this.roots = fileSystemSubset.getRoots();
        Iterable enclosingDirsThatExist = Iterables.transform(this.roots, (Function)new Function<File, File>(){

            public File apply(File input) {
                File target = input;
                while (!target.isDirectory()) {
                    target = target.getParentFile();
                }
                return target;
            }
        });
        Collection startingWatchPoints = FileUtils.calculateRoots((Iterable)enclosingDirsThatExist);
        for (File dir : startingWatchPoints) {
            if (FILE_TREE_WATCHING_SUPPORTED) {
                if (!this.inUnfilteredSubsetOrAncestorOfAnyRoot(dir)) continue;
                this.watchDir(dir.toPath());
                continue;
            }
            Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    if (WatchServiceRegistrar.this.inUnfilteredSubsetOrAncestorOfAnyRoot(path.toFile())) {
                        WatchServiceRegistrar.this.watchDir(path);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
    }

    private void watchDir(Path dir) throws IOException {
        block2: {
            try {
                dir.register(this.watchService, WATCH_KINDS, WATCH_MODIFIERS);
            }
            catch (IOException e) {
                if (!Files.exists(dir, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    private boolean inUnfilteredSubsetOrAncestorOfAnyRoot(File file) {
        if (this.unfilteredFileSystemSubset.contains(file)) {
            return true;
        }
        String absolutePathWithSeparator = file.getAbsolutePath() + File.separator;
        for (File file2 : this.roots) {
            if (!file2.equals(file) && !file2.getPath().startsWith(absolutePathWithSeparator)) continue;
            return true;
        }
        return false;
    }

    public void onChange(FileWatcher watcher, FileWatcherEvent event) {
        if (event.getType().equals((Object)FileWatcherEvent.Type.UNDEFINED) || event.getFile() == null) {
            this.delegate.onChange(watcher, event);
            return;
        }
        File file = event.getFile();
        this.maybeFire(watcher, event);
        if (watcher.isRunning() && file.isDirectory() && event.getType().equals((Object)FileWatcherEvent.Type.CREATE)) {
            try {
                this.newDirectory(watcher, file);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
    }

    private void maybeFire(FileWatcher watcher, FileWatcherEvent event) {
        if (this.fileSystemSubset.contains(event.getFile())) {
            this.delegate.onChange(watcher, event);
        }
    }

    private void newDirectory(FileWatcher watcher, File dir) throws IOException {
        if (!watcher.isRunning()) {
            return;
        }
        if (dir.exists()) {
            File[] contents;
            if (!FILE_TREE_WATCHING_SUPPORTED) {
                this.watchDir(dir.toPath());
            }
            if ((contents = dir.listFiles()) != null) {
                for (File file : contents) {
                    this.maybeFire(watcher, FileWatcherEvent.create(file));
                    if (!watcher.isRunning()) {
                        return;
                    }
                    if (!file.isDirectory()) continue;
                    this.newDirectory(watcher, file);
                }
            }
        }
    }

    static {
        WatchEvent.Modifier[] modifierArray;
        FILE_TREE_WATCHING_SUPPORTED = OperatingSystem.current().isWindows();
        if (FILE_TREE_WATCHING_SUPPORTED) {
            WatchEvent.Modifier[] modifierArray2 = new WatchEvent.Modifier[2];
            modifierArray2[0] = ExtendedWatchEventModifier.FILE_TREE;
            modifierArray = modifierArray2;
            modifierArray2[1] = SensitivityWatchEventModifier.HIGH;
        } else {
            WatchEvent.Modifier[] modifierArray3 = new WatchEvent.Modifier[1];
            modifierArray = modifierArray3;
            modifierArray3[0] = SensitivityWatchEventModifier.HIGH;
        }
        WATCH_MODIFIERS = modifierArray;
        WATCH_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }
}

