/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.gradle.util.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffUtil {
    public static <T> void diff(Set<T> newSet, Set<T> oldSet, ChangeListener<? super T> changeListener) {
        HashSet<T> added = new HashSet<T>(newSet);
        added.removeAll(oldSet);
        for (Object t : added) {
            changeListener.added(t);
        }
        HashSet<T> removed = new HashSet<T>(oldSet);
        removed.removeAll(newSet);
        for (Object t : removed) {
            changeListener.removed(t);
        }
    }

    public static <K, V> void diff(Map<K, V> newMap, Map<K, V> oldMap, ChangeListener<? super Map.Entry<K, V>> changeListener) {
        HashMap<K, V> added = new HashMap<K, V>(newMap);
        added.keySet().removeAll(oldMap.keySet());
        for (Map.Entry entry : added.entrySet()) {
            changeListener.added(entry);
        }
        HashMap<K, V> removed = new HashMap<K, V>(oldMap);
        removed.keySet().removeAll(newMap.keySet());
        for (Map.Entry entry : removed.entrySet()) {
            changeListener.removed(entry);
        }
        HashMap<K, V> same = new HashMap<K, V>(newMap);
        same.keySet().retainAll(oldMap.keySet());
        for (Map.Entry entry : same.entrySet()) {
            if (ObjectUtils.equals(entry.getValue(), oldMap.get(entry.getKey()))) continue;
            changeListener.changed(entry);
        }
    }
}

