/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import org.gradle.internal.Cast;
import org.gradle.model.internal.manage.schema.AbstractModelSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructSchema<T>
extends AbstractModelSchema<T>
implements StructSchema<T> {
    private final ImmutableSortedMap<String, ModelProperty<?>> properties;
    private final Map<Class<? extends ModelSchemaAspect>, ModelSchemaAspect> aspects;

    public AbstractStructSchema(ModelType<T> type, Iterable<ModelProperty<?>> properties, Iterable<ModelSchemaAspect> aspects) {
        super(type);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (ModelProperty<?> property : properties) {
            builder.put((Object)property.getName(), property);
        }
        this.properties = builder.build();
        this.aspects = Maps.uniqueIndex(aspects, (Function)new Function<ModelSchemaAspect, Class<? extends ModelSchemaAspect>>(){

            public Class<? extends ModelSchemaAspect> apply(ModelSchemaAspect aspect) {
                return aspect.getClass();
            }
        });
    }

    @Override
    public SortedSet<String> getPropertyNames() {
        return this.properties.keySet();
    }

    @Override
    public Collection<ModelProperty<?>> getProperties() {
        return this.properties.values();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey((Object)name);
    }

    @Override
    public ModelProperty<?> getProperty(String name) {
        return (ModelProperty)this.properties.get((Object)name);
    }

    @Override
    public boolean hasAspect(Class<? extends ModelSchemaAspect> aspectType) {
        return this.aspects.containsKey(aspectType);
    }

    @Override
    public <A extends ModelSchemaAspect> A getAspect(Class<A> aspectType) {
        return (A)((ModelSchemaAspect)Cast.uncheckedCast((Object)this.aspects.get(aspectType)));
    }

    @Override
    public Collection<ModelSchemaAspect> getAspects() {
        return this.aspects.values();
    }
}

