/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.nodes.Node;

public final class FindContextNode<C>
extends Node {
    private final Class<? extends TruffleLanguage<C>> languageClass;
    @CompilerDirectives.CompilationFinal
    private C context;
    @CompilerDirectives.CompilationFinal
    private Assumption oneVM;

    public FindContextNode(Class<? extends TruffleLanguage<C>> type) {
        this.languageClass = type;
    }

    public C executeFindContext() {
        if (this.context != null && this.oneVM.isValid()) {
            return this.context;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.oneVM = Accessor.oneVMAssumption();
        this.context = Accessor.findContext(this.languageClass);
        return this.context;
    }

    public Class<? extends TruffleLanguage<C>> getLanguageClass() {
        return this.languageClass;
    }
}

