/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;

@CoreClass(name="TrueClass")
public abstract class TrueClassNodes {

    @CoreMethod(names={"^"}, needsSelf=false, required=1)
    public static abstract class XorNode
    extends UnaryCoreMethodNode {
        public XorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean xor(boolean other) {
            return !other;
        }
    }

    @CoreMethod(names={"|"}, needsSelf=false, required=1)
    public static abstract class OrNode
    extends CoreMethodArrayArgumentsNode {
        public OrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean or(Object other) {
            return true;
        }
    }

    @CoreMethod(names={"&"}, needsSelf=false, required=1)
    public static abstract class AndNode
    extends UnaryCoreMethodNode {
        public AndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean and(boolean other) {
            return other;
        }
    }
}

