/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.dom.ElementConfigurationException;
import de.intarsys.tools.dom.ElementTools;
import de.intarsys.tools.format.TrivialIntegerFormat;
import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.MonitorStatistic;
import de.intarsys.tools.monitor.MonitorTrace;
import java.io.StringWriter;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class Monitor
extends AbstractMonitor {
    protected static final String TXT_VER_SEPARATOR = " | ";
    protected static final String TXT_HOR_SEPARATOR = "------------------------------------------------------------------------";
    protected static final int COLWIDTH_LABEL = 80;
    protected static final int COLWIDTH_NUMBER = 7;
    private static Format DEFAULT_FORMAT = TrivialIntegerFormat.getInstance();
    public static final String ATTR_NAME = "name";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_COUNT = "count";
    public static final String ATTR_TOTAL = "total";
    public static final String ATTR_EFFECTIVE = "effective";
    public static final String ATTR_AVG = "avg";
    public static final String ATTR_FIRST = "first";
    public static final String ATTR_LAST = "last";
    public static final String ATTR_MAXACTIVE = "maxactive";
    private boolean relative = true;
    protected volatile long first;
    protected volatile long last;
    protected volatile int active;
    protected int maxActive;
    protected MonitorStatistic statistic = new MonitorStatistic("stop", Integer.MAX_VALUE);
    protected Map sampleStatistics = new HashMap();

    public Monitor() {
    }

    public Monitor(String string) {
        super(string);
    }

    @Override
    public void configure(Element element) throws ElementConfigurationException {
        super.configure(element);
        if (ElementTools.getPathBoolean(element, "deltasamples", true)) {
            this.setRelative(true);
        }
    }

    protected abstract void doCalculation(MonitorTrace var1);

    public int getActive() {
        return this.active;
    }

    @Override
    public synchronized Map getData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ATTR_NAME, this.getName());
        hashMap.put(ATTR_FIRST, new Long(this.first));
        hashMap.put(ATTR_LAST, new Long(this.last));
        hashMap.put(ATTR_MAXACTIVE, new Integer(this.maxActive));
        hashMap.put(ATTR_MIN, new Long(this.statistic.min));
        hashMap.put(ATTR_MAX, new Long(this.statistic.max));
        hashMap.put(ATTR_COUNT, new Long(this.statistic.count));
        hashMap.put(ATTR_EFFECTIVE, new Long(this.statistic.total));
        hashMap.put(ATTR_AVG, new Long(this.statistic.avg));
        return hashMap;
    }

    protected Format getFormat() {
        return DEFAULT_FORMAT;
    }

    @Override
    public synchronized Map getFormattedData() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ATTR_NAME, this.getName());
        hashMap.put(ATTR_FIRST, this.getFormat().format(new Long(this.first)));
        hashMap.put(ATTR_LAST, this.getFormat().format(new Long(this.last)));
        hashMap.put(ATTR_MAXACTIVE, new Integer(this.maxActive));
        hashMap.put(ATTR_MIN, new Long(this.statistic.min));
        hashMap.put(ATTR_MAX, new Long(this.statistic.max));
        hashMap.put(ATTR_COUNT, new Long(this.statistic.count));
        hashMap.put(ATTR_EFFECTIVE, new Long(this.statistic.total));
        hashMap.put(ATTR_AVG, new Long(this.statistic.avg));
        return hashMap;
    }

    public boolean isRelative() {
        return this.relative;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.active = 0;
        this.first = -1L;
        this.last = -1L;
        this.maxActive = 0;
        this.statistic.reset();
        this.sampleStatistics = new HashMap();
    }

    public void setRelative(boolean bl) {
        this.relative = bl;
    }

    @Override
    protected synchronized void started(ITrace iTrace) {
        if (this.first == -1L) {
            this.first = ((MonitorTrace)iTrace).getStart();
        }
        ++this.active;
        if (this.active > this.maxActive) {
            this.maxActive = this.active;
        }
    }

    @Override
    protected synchronized void stopped(ITrace iTrace) {
        this.last = ((MonitorTrace)iTrace).getStop();
        --this.active;
        this.doCalculation((MonitorTrace)iTrace);
        super.stopped(iTrace);
    }

    protected String toFormattedString(String string, int n) {
        if (string == null) {
            string = "";
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        int n2 = string.length();
        while (n2 < n) {
            stringBuilder.append(' ');
            ++n2;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toTableString();
    }

    public String toTableString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(System.getProperty("line.separator"));
        stringWriter.write("   ");
        stringWriter.write(this.getName());
        stringWriter.write(System.getProperty("line.separator"));
        stringWriter.write(System.getProperty("line.separator"));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString("description", 80));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(ATTR_COUNT, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(ATTR_TOTAL, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString("total %", 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(ATTR_MIN, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(ATTR_MAX, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(ATTR_AVG, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(System.getProperty("line.separator"));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 80));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(System.getProperty("line.separator"));
        ArrayList arrayList = new ArrayList(this.sampleStatistics.values());
        Collections.sort(arrayList);
        for (MonitorStatistic monitorStatistic : arrayList) {
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(this.toFormattedString(monitorStatistic.description, 80));
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(this.toFormattedString(String.valueOf(monitorStatistic.count), 7));
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(this.toFormattedString(String.valueOf(monitorStatistic.total), 7));
            stringWriter.write(TXT_VER_SEPARATOR);
            float f = (float)Math.round((float)monitorStatistic.total / (float)this.statistic.total * 10000.0f) / 100.0f;
            stringWriter.write(this.toFormattedString(String.valueOf(f), 7));
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(this.toFormattedString(String.valueOf(monitorStatistic.min), 7));
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(this.toFormattedString(String.valueOf(monitorStatistic.max), 7));
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(this.toFormattedString(String.valueOf(monitorStatistic.avg), 7));
            stringWriter.write(TXT_VER_SEPARATOR);
            stringWriter.write(System.getProperty("line.separator"));
        }
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 80));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(TXT_HOR_SEPARATOR, 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(System.getProperty("line.separator"));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString("", 80));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(String.valueOf(this.statistic.count), 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(String.valueOf(this.statistic.total), 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(String.valueOf(100), 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(String.valueOf(this.statistic.min), 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(String.valueOf(this.statistic.max), 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(this.toFormattedString(String.valueOf(this.statistic.avg), 7));
        stringWriter.write(TXT_VER_SEPARATOR);
        stringWriter.write(System.getProperty("line.separator"));
        return stringWriter.toString();
    }
}

