/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.updates.checkers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.exceptions.CheckForUpdateException;
import org.pdfsam.guiclient.updates.checkers.UpdateChecker;
import org.pdfsam.i18n.GettextResource;

public class HttpUpdateChecker
implements UpdateChecker {
    private String httpUrl = null;

    public HttpUpdateChecker(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    @Override
    public String getLatestVersion() throws CheckForUpdateException {
        String xmlContent = this.getXmlContent();
        if (xmlContent != null) {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(new StringReader(xmlContent));
                Node node = document.selectSingleNode("/pdfsam/latestVersion/@value");
                if (node != null) {
                    return StringUtils.trimToEmpty((String)node.getText());
                }
            }
            catch (Exception e) {
                throw new CheckForUpdateException(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to get latest available version"), e);
            }
        }
        return "";
    }

    private String getXmlContent() throws CheckForUpdateException {
        String retVal = "";
        HttpURLConnection urlConn = null;
        BufferedReader br = null;
        try {
            URL url = new URL(this.httpUrl);
            urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setRequestProperty("user agent", "Mozilla/5.0 (compatible; MSIE 6.0; Windows NT 5.1");
            br = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String tmp = null;
            while ((tmp = br.readLine()) != null) {
                sb.append(tmp);
            }
            br.close();
            retVal = sb.toString();
        }
        catch (Exception e) {
            throw new CheckForUpdateException(e);
        }
        finally {
            if (urlConn != null) {
                urlConn.disconnect();
            }
        }
        return retVal;
    }
}

