/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateLicenseImpl;
import org.netbeans.modules.autoupdate.services.Utilities;
import org.netbeans.modules.autoupdate.updateprovider.ModuleItem;
import org.netbeans.modules.autoupdate.updateprovider.UpdateItemImpl;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateLicense;
import org.netbeans.updater.XMLUtil;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoupdateInfoParser
extends DefaultHandler {
    private static final String INFO_NAME = "info";
    private static final String INFO_EXT = ".xml";
    private static final String INFO_FILE = "info.xml";
    private static final String INFO_DIR = "Info";
    private static final String INFO_LOCALE = "locale";
    private final Map<String, UpdateItem> items;
    private final EntityResolver entityResolver;
    private final File nbmFile;
    private UpdateLicenseImpl currentUpdateLicenseImpl;
    private static final Logger ERR = Logger.getLogger(AutoupdateInfoParser.class.getName());
    private static final String LICENSE_ATTR_NAME = "name";
    private static final String MODULE_ATTR_CODE_NAME_BASE = "codenamebase";
    private static final String MODULE_ATTR_HOMEPAGE = "homepage";
    private static final String MODULE_ATTR_DOWNLOAD_SIZE = "downloadsize";
    private static final String MODULE_ATTR_NEEDS_RESTART = "needsrestart";
    private static final String MODULE_ATTR_MODULE_AUTHOR = "moduleauthor";
    private static final String MODULE_ATTR_RELEASE_DATE = "releasedate";
    private static final String MODULE_ATTR_IS_GLOBAL = "global";
    private static final String MODULE_ATTR_IS_PREFERRED_UPDATE = "preferredupdate";
    private static final String MODULE_ATTR_TARGET_CLUSTER = "targetcluster";
    private static final String MODULE_ATTR_EAGER = "eager";
    private static final String MODULE_ATTR_AUTOLOAD = "autoload";
    private static final String MODULE_ATTR_LICENSE = "license";
    private static final String MANIFEST_ATTR_SPECIFICATION_VERSION = "OpenIDE-Module-Specification-Version";
    private static final String L10N_ATTR_LOCALE = "langcode";
    private static final String L10N_ATTR_BRANDING = "brandingcode";
    private static final String L10N_ATTR_MODULE_SPECIFICATION = "module_spec_version";
    private static final String L10N_ATTR_MODULE_MAJOR_VERSION = "module_major_version";
    private static final String L10N_ATTR_LOCALIZED_MODULE_NAME = "OpenIDE-Module-Name";
    private static final String L10N_ATTR_LOCALIZED_MODULE_DESCRIPTION = "OpenIDE-Module-Long-Description";
    private Stack<ModuleDescriptor> currentModule = new Stack();
    private Stack<String> currentLicense = new Stack();
    private List<String> lines = new ArrayList<String>();
    public static final String BUNDLE_EXPORT_PACKAGE = "Export-Package";
    public static final String BUNDLE_IMPORT_PACKAGE = "Import-Package";
    private static final Set<String> JAVA_PLATFORM_PACKAGES = new TreeSet<String>(Arrays.asList("javax.accessibility", "javax.activation", "javax.activity", "javax.annotation", "javax.annotation.processing", "javax.crypto", "javax.crypto.interfaces", "javax.crypto.spec", "javax.imageio", "javax.imageio.event", "javax.imageio.metadata", "javax.imageio.plugins.bmp", "javax.imageio.plugins.jpeg", "javax.imageio.spi", "javax.imageio.stream", "javax.jws", "javax.jws.soap", "javax.lang.model", "javax.lang.model.element", "javax.lang.model.type", "javax.lang.model.util", "javax.management", "javax.management.loading", "javax.management.modelmbean", "javax.management.monitor", "javax.management.openmbean", "javax.management.relation", "javax.management.remote", "javax.management.remote.rmi", "javax.management.timer", "javax.naming", "javax.naming.directory", "javax.naming.event", "javax.naming.ldap", "javax.naming.spi", "javax.net", "javax.net.ssl", "javax.print", "javax.print.attribute", "javax.print.attribute.standard", "javax.print.event", "javax.rmi", "javax.rmi.CORBA", "javax.rmi.ssl", "javax.script", "javax.security.auth", "javax.security.auth.callback", "javax.security.auth.kerberos", "javax.security.auth.login", "javax.security.auth.spi", "javax.security.auth.x500", "javax.security.cert", "javax.security.sasl", "javax.sound.midi", "javax.sound.midi.spi", "javax.sound.sampled", "javax.sound.sampled.spi", "javax.sql", "javax.sql.rowset", "javax.sql.rowset.serial", "javax.sql.rowset.spi", "javax.swing", "javax.swing.border", "javax.swing.colorchooser", "javax.swing.event", "javax.swing.filechooser", "javax.swing.plaf", "javax.swing.plaf.basic", "javax.swing.plaf.metal", "javax.swing.plaf.multi", "javax.swing.plaf.synth", "javax.swing.table", "javax.swing.text", "javax.swing.text.html", "javax.swing.text.html.parser", "javax.swing.text.rtf", "javax.swing.tree", "javax.swing.undo", "javax.tools", "javax.transaction", "javax.transaction.xa", "javax.xml", "javax.xml.bind", "javax.xml.bind.annotation", "javax.xml.bind.annotation.adapters", "javax.xml.bind.attachment", "javax.xml.bind.helpers", "javax.xml.bind.util", "javax.xml.crypto", "javax.xml.crypto.dom", "javax.xml.crypto.dsig", "javax.xml.crypto.dsig.dom", "javax.xml.crypto.dsig.keyinfo", "javax.xml.crypto.dsig.spec", "javax.xml.datatype", "javax.xml.namespace", "javax.xml.parsers", "javax.xml.soap", "javax.xml.stream", "javax.xml.stream.events", "javax.xml.stream.util", "javax.xml.transform", "javax.xml.transform.dom", "javax.xml.transform.sax", "javax.xml.transform.stax", "javax.xml.transform.stream", "javax.xml.validation", "javax.xml.ws", "javax.xml.ws.handler", "javax.xml.ws.handler.soap", "javax.xml.ws.http", "javax.xml.ws.soap", "javax.xml.ws.spi", "javax.xml.ws.wsaddressing", "javax.xml.xpath", "org.ietf.jgss", "org.omg.CORBA", "org.omg.CORBA.DynAnyPackage", "org.omg.CORBA.ORBPackage", "org.omg.CORBA.TypeCodePackage", "org.omg.CORBA.portable", "org.omg.CORBA_2_3", "org.omg.CORBA_2_3.portable", "org.omg.CosNaming", "org.omg.CosNaming.NamingContextExtPackage", "org.omg.CosNaming.NamingContextPackage", "org.omg.Dynamic", "org.omg.DynamicAny", "org.omg.DynamicAny.DynAnyFactoryPackage", "org.omg.DynamicAny.DynAnyPackage", "org.omg.IOP", "org.omg.IOP.CodecFactoryPackage", "org.omg.IOP.CodecPackage", "org.omg.Messaging", "org.omg.PortableInterceptor", "org.omg.PortableInterceptor.ORBInitInfoPackage", "org.omg.PortableServer", "org.omg.PortableServer.CurrentPackage", "org.omg.PortableServer.POAManagerPackage", "org.omg.PortableServer.POAPackage", "org.omg.PortableServer.ServantLocatorPackage", "org.omg.PortableServer.portable", "org.omg.SendingContext", "org.omg.stub.java.rmi", "org.w3c.dom", "org.w3c.dom.bootstrap", "org.w3c.dom.events", "org.w3c.dom.ls", "org.xml.sax", "org.xml.sax.ext", "org.xml.sax.helpers"));

    private AutoupdateInfoParser(Map<String, UpdateItem> map, File file) {
        this.items = map;
        this.entityResolver = this.newEntityResolver();
        this.nbmFile = file;
    }

    private EntityResolver newEntityResolver() {
        try {
            Class.forName("org.netbeans.updater.XMLUtil");
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file = new File(System.getProperty("netbeans.home"));
            File file2 = new File(System.getProperty("netbeans.user"));
            File file3 = new File(file, "modules/ext/updater.jar");
            File file4 = new File(file2, "modules/ext/updater.jar");
            File file5 = new File(file, "update/new_updater/updater.jar");
            File file6 = new File(file2, "update/new_updater/updater.jar");
            String string = "    org.netbeans.updater.XMLUtil is not accessible\n    platform dir = " + file.getAbsolutePath() + "\n" + "    userdir  dir = " + file2.getAbsolutePath() + "\n" + "    updater in platform exist = " + file3.exists() + (file3.exists() ? ", length = " + file3.length() + " bytes" : "") + "\n" + "    updater in userdir  exist = " + file4.exists() + (file4.exists() ? ", length = " + file4.length() + " bytes" : "") + "\n" + "    new updater in platform exist = " + file5.exists() + (file5.exists() ? ", length = " + file5.length() + " bytes" : "") + "\n" + "    new updater in userdir  exist = " + file6.exists() + (file6.exists() ? ", length = " + file6.length() + " bytes" : "") + "\n";
            ERR.log(Level.WARNING, string);
        }
        return XMLUtil.createAUResolver();
    }

    public static Map<String, UpdateItem> getUpdateItems(File file) throws IOException, SAXException {
        HashMap<String, UpdateItem> hashMap = new HashMap<String, UpdateItem>();
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            if (!AutoupdateInfoParser.isOSGiBundle(file)) {
                sAXParser.parse(AutoupdateInfoParser.getAutoupdateInfoInputSource(file), (DefaultHandler)new AutoupdateInfoParser(hashMap, file));
            } else {
                sAXParser.parse(AutoupdateInfoParser.getAutoupdateInfoInputStream(file), (DefaultHandler)new AutoupdateInfoParser(hashMap, file));
            }
        }
        catch (SAXException sAXException) {
            ERR.log(Level.INFO, sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getMessage(), iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ERR.log(Level.INFO, parserConfigurationException.getMessage(), parserConfigurationException);
        }
        return hashMap;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.lines.add(new String(cArray, n, n2));
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (ELEMENTS.valueOf(string3)) {
            case module: {
                assert (!this.currentModule.empty()) : "Premature end of module " + string3;
                this.currentModule.pop();
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                ModuleDescriptor moduleDescriptor = this.currentModule.peek();
                assert (moduleDescriptor != null) : "ModuleDescriptor found for " + this.nbmFile;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string4 : this.lines) {
                    stringBuilder.append(string4);
                }
                moduleDescriptor.appendNotification(stringBuilder.toString());
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                assert (!this.currentLicense.empty()) : "Premature end of license " + string3;
                StringBuilder stringBuilder = new StringBuilder();
                for (String string5 : this.lines) {
                    stringBuilder.append(string5);
                }
                assert (this.currentUpdateLicenseImpl != null) : "UpdateLicenseImpl found for " + this.nbmFile;
                this.currentUpdateLicenseImpl.setAgreement(stringBuilder.toString());
                this.currentLicense.pop();
                break;
            }
            default: {
                ERR.warning("Unknown element " + string3);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        ERR.fine("End parsing " + this.nbmFile + " at " + System.currentTimeMillis());
    }

    @Override
    public void startDocument() throws SAXException {
        ERR.fine("Start parsing " + this.nbmFile + " at " + System.currentTimeMillis());
    }

    @Override
    public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
        this.lines.clear();
        switch (ELEMENTS.valueOf(string3)) {
            case module: {
                ModuleDescriptor moduleDescriptor = new ModuleDescriptor(this.nbmFile);
                moduleDescriptor.appendModuleAttributes(attributes);
                this.currentModule.push(moduleDescriptor);
                break;
            }
            case l10n: {
                break;
            }
            case manifest: {
                ModuleDescriptor moduleDescriptor = this.currentModule.peek();
                moduleDescriptor.appendManifest(attributes);
                UpdateItem updateItem = moduleDescriptor.createUpdateItem();
                UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
                this.currentUpdateLicenseImpl = updateItemImpl.getUpdateLicenseImpl();
                this.items.put(moduleDescriptor.getId(), updateItem);
                break;
            }
            case description: {
                ERR.info("Not supported yet.");
                break;
            }
            case module_notification: {
                break;
            }
            case external_package: {
                ERR.info("Not supported yet.");
                break;
            }
            case license: {
                this.currentLicense.push(attributes.getValue(LICENSE_ATTR_NAME));
                break;
            }
            default: {
                ERR.warning("Unknown element " + string3);
            }
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return this.entityResolver.resolveEntity(string, string2);
    }

    private static Manifest getManifest(org.xml.sax.Attributes attributes) {
        Manifest manifest = new Manifest();
        Attributes attributes2 = manifest.getMainAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributes2.put(new Attributes.Name(attributes.getQName(i)), attributes.getValue(i));
        }
        return manifest;
    }

    private static InputSource getAutoupdateInfoInputSource(File file) throws IOException, SAXException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            throw new IOException("Cannot open NBM file " + file + ": " + iOException, iOException);
        }
        String string = Locale.getDefault().toString();
        ZipEntry zipEntry = jarFile.getEntry("Info/locale/info_" + string + INFO_EXT);
        if (zipEntry == null) {
            zipEntry = jarFile.getEntry("Info/info.xml");
        }
        if (zipEntry == null) {
            throw new IllegalArgumentException("info.xml found in file " + file);
        }
        return new InputSource(new BufferedInputStream(jarFile.getInputStream(zipEntry)));
    }

    private static InputStream getAutoupdateInfoInputStream(File file) throws IOException, SAXException {
        try {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                throw new IOException("Cannot open NBM file " + file + ": " + iOException, iOException);
            }
            Element element = AutoupdateInfoParser.fakeOSGiInfoXml(jarFile, file);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            DOMSource dOMSource = new DOMSource(element.getOwnerDocument());
            transformer.transform(dOMSource, streamResult);
            stringWriter.close();
            String string = stringWriter.toString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            return byteArrayInputStream;
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private static boolean isOSGiBundle(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Manifest manifest = jarFile.getManifest();
            return manifest != null && manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
        }
        catch (IOException iOException) {
            ERR.log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element fakeOSGiInfoXml(JarFile jarFile, File file) throws IOException {
        Attributes attributes = jarFile.getManifest().getMainAttributes();
        Properties properties = new Properties();
        String string = attributes.getValue("Bundle-Localization");
        if (string != null) {
            InputStream inputStream = jarFile.getInputStream(jarFile.getEntry(string + ".properties"));
            try {
                properties.load(inputStream);
            }
            finally {
                inputStream.close();
            }
        }
        return AutoupdateInfoParser.fakeOSGiInfoXml(attributes, properties, file);
    }

    static Element fakeOSGiInfoXml(Attributes attributes, Properties properties, File file) {
        String string;
        String string2;
        Object object;
        CharSequence charSequence;
        Document document = XMLUtil.createDocument("module");
        Element element = document.getDocumentElement();
        String string3 = AutoupdateInfoParser.extractCodeName(attributes, null);
        element.setAttribute(MODULE_ATTR_CODE_NAME_BASE, string3);
        element.setAttribute("distribution", "");
        element.setAttribute(MODULE_ATTR_DOWNLOAD_SIZE, "0");
        element.setAttribute(MODULE_ATTR_TARGET_CLUSTER, file.getParentFile().getName());
        Element element2 = document.createElement("manifest");
        element.appendChild(element2);
        element2.setAttribute("AutoUpdate-Show-In-Client", "true");
        element2.setAttribute("OpenIDE-Module", string3);
        String string4 = AutoupdateInfoParser.loc(properties, attributes, "Bundle-Name");
        element2.setAttribute(L10N_ATTR_LOCALIZED_MODULE_NAME, string4 != null ? string4 : string3);
        String string5 = attributes.getValue("Bundle-Version");
        element2.setAttribute(MANIFEST_ATTR_SPECIFICATION_VERSION, string5 != null ? string5.replaceFirst("^(\\d+([.]\\d+([.]\\d+)?)?)([.].+)?$", "$1") : "0");
        String string6 = attributes.getValue("Require-Bundle");
        if (string6 != null) {
            charSequence = new StringBuilder();
            boolean bl = false;
            for (String object2 : string6.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                Matcher matcher = Pattern.compile("([^;]+)(.*)").matcher(object2);
                if (!matcher.matches()) {
                    throw new RuntimeException("Could not parse dependency: " + object2 + " in " + file);
                }
                String string7 = matcher.group(1);
                if (string7.trim().equals("org.eclipse.osgi")) {
                    bl = true;
                    continue;
                }
                object = Pattern.compile(";([^:=]+):?=\"?([^;\"]+)\"?").matcher(matcher.group(2));
                boolean bl2 = false;
                while (((Matcher)object).find()) {
                    if (!((Matcher)object).group(1).equals("resolution") || !((Matcher)object).group(2).equals("optional")) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                ((Matcher)object).reset();
                if (((StringBuilder)charSequence).length() > 0) {
                    ((StringBuilder)charSequence).append(", ");
                }
                ((StringBuilder)charSequence).append(string7);
                while (((Matcher)object).find()) {
                    if (!((Matcher)object).group(1).equals("bundle-version")) continue;
                    String string8 = ((Matcher)object).group(2);
                    if (string8.matches("[0-9]+([.][0-9]+)*")) {
                        ((StringBuilder)charSequence).append(" > ").append(string8);
                        continue;
                    }
                    Matcher matcher2 = Pattern.compile("\\[([0-9]+)((?:[.][0-9]+)*),([0-9.]+)\\)").matcher(string8);
                    if (!matcher2.matches()) {
                        throw new RuntimeException("Could not parse version range: " + string8 + " in " + file);
                    }
                    int n = Integer.parseInt(matcher2.group(1));
                    String string9 = matcher2.group(2);
                    try {
                        int n2 = Integer.parseInt(matcher2.group(3));
                        if (n > 99) {
                            ((StringBuilder)charSequence).append('/').append(n / 100);
                            if (n2 > n + 100) {
                                ((StringBuilder)charSequence).append('-').append(n2 / 100 - 1);
                            }
                        } else if (n2 > 100) {
                            ((StringBuilder)charSequence).append("/0-").append(n2 / 100 - 1);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ((StringBuilder)charSequence).append(" > ").append(n % 100).append(string9);
                }
            }
            if (((StringBuilder)charSequence).length() > 0) {
                element2.setAttribute("OpenIDE-Module-Module-Dependencies", ((StringBuilder)charSequence).toString());
            }
            if (bl) {
                element2.setAttribute("OpenIDE-Module-Needs", "org.netbeans.Netbinox");
            }
        }
        charSequence = attributes.getValue(BUNDLE_EXPORT_PACKAGE);
        StringBuilder stringBuilder = new StringBuilder();
        if (charSequence != null) {
            for (String string10 : ((String)charSequence).replaceAll("\"[^\"]*\"", "").split(",")) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string10.replaceAll(";.*$", "").trim());
            }
        }
        if (stringBuilder.length() > 0) {
            element2.setAttribute("OpenIDE-Module-Provides", stringBuilder.toString());
        }
        String string10 = attributes.getValue(BUNDLE_IMPORT_PACKAGE);
        StringBuilder stringBuilder2 = new StringBuilder();
        if (string10 != null) {
            for (String string7 : string10.replaceAll("\"[^\"]*\"", "").split(",")) {
                object = string7.replaceAll(";.*$", "").trim();
                if (JAVA_PLATFORM_PACKAGES.contains(object)) continue;
                if (stringBuilder2.length() > 0) {
                    stringBuilder2.append(',');
                }
                stringBuilder2.append(string7.replaceAll(";.*$", "").trim());
            }
        }
        if (stringBuilder2.length() > 0) {
            element2.setAttribute("OpenIDE-Module-Recommends", stringBuilder2.toString().replace('-', '_'));
        }
        if ((string2 = AutoupdateInfoParser.loc(properties, attributes, "Bundle-Category")) != null) {
            element2.setAttribute("OpenIDE-Module-Display-Category", string2);
        }
        if ((string = AutoupdateInfoParser.loc(properties, attributes, "Bundle-Description")) != null) {
            element2.setAttribute("OpenIDE-Module-Short-Description", string);
        }
        return element;
    }

    private static String loc(Properties properties, Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("%")) {
            return properties.getProperty(string2.substring(1));
        }
        return string2;
    }

    private static String extractCodeName(Attributes attributes, boolean[] blArray) {
        int n;
        String string = attributes.getValue("OpenIDE-Module");
        if (string != null) {
            return string;
        }
        string = attributes.getValue("Bundle-SymbolicName");
        if (string == null) {
            return null;
        }
        string = string.replace('-', '_');
        if (blArray != null) {
            blArray[0] = true;
        }
        if ((n = string.indexOf(59)) >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private static class ModuleDescriptor {
        private String moduleCodeName;
        private String targetcluster;
        private String homepage;
        private String downloadSize;
        private String author;
        private String publishDate;
        private String notification;
        private Boolean needsRestart;
        private Boolean isGlobal;
        private Boolean isEager;
        private Boolean isAutoload;
        private Boolean isPreferredUpdate;
        private String specVersion;
        private Manifest mf;
        private UpdateLicense lic;
        private final File nbmFile;

        public ModuleDescriptor(File file) {
            this.nbmFile = file;
        }

        public void appendModuleAttributes(org.xml.sax.Attributes attributes) {
            this.moduleCodeName = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_CODE_NAME_BASE);
            this.targetcluster = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_TARGET_CLUSTER);
            this.homepage = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_HOMEPAGE);
            this.downloadSize = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_DOWNLOAD_SIZE);
            this.author = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_MODULE_AUTHOR);
            this.publishDate = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_RELEASE_DATE);
            if (this.publishDate == null || this.publishDate.length() == 0) {
                this.publishDate = Utilities.formatDate(new Date(this.nbmFile.lastModified()));
            }
            String string = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_NEEDS_RESTART);
            String string2 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_IS_GLOBAL);
            String string3 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_EAGER);
            String string4 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_AUTOLOAD);
            String string5 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_IS_PREFERRED_UPDATE);
            this.needsRestart = string == null || string.trim().length() == 0 ? null : Boolean.valueOf(string);
            this.isGlobal = string2 == null || string2.trim().length() == 0 ? null : Boolean.valueOf(string2);
            this.isEager = Boolean.parseBoolean(string3);
            this.isAutoload = Boolean.parseBoolean(string4);
            this.isPreferredUpdate = Boolean.parseBoolean(string5);
            String string6 = attributes.getValue(AutoupdateInfoParser.MODULE_ATTR_LICENSE);
            this.lic = UpdateLicense.createUpdateLicense(string6, null);
        }

        public void appendManifest(org.xml.sax.Attributes attributes) {
            this.specVersion = attributes.getValue(AutoupdateInfoParser.MANIFEST_ATTR_SPECIFICATION_VERSION);
            this.mf = AutoupdateInfoParser.getManifest(attributes);
        }

        public void appendNotification(String string) {
            this.notification = string;
        }

        public String getId() {
            return this.moduleCodeName + '_' + this.specVersion;
        }

        public UpdateItem createUpdateItem() {
            URL uRL = null;
            try {
                uRL = org.openide.util.Utilities.toURI((File)this.nbmFile).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ERR.log(Level.INFO, null, malformedURLException);
            }
            UpdateItem updateItem = UpdateItem.createModule(this.moduleCodeName, this.specVersion, uRL, this.author, this.downloadSize, this.homepage, this.publishDate, null, this.mf, this.isEager, this.isAutoload, this.needsRestart, this.isGlobal, this.isPreferredUpdate, this.targetcluster, this.lic);
            UpdateItemImpl updateItemImpl = Trampoline.SPI.impl(updateItem);
            ((ModuleItem)updateItemImpl).setModuleNotification(this.notification);
            return updateItem;
        }
    }

    private static enum ELEMENTS {
        module,
        description,
        module_notification,
        external_package,
        manifest,
        l10n,
        license;

    }
}

