raismth.ns(function() { with (raismth.LIB) {
myDump("[RAISMTH] myplayer module initialization\n");

theApp.myPlayer = function() {
}
theApp.myPlayer.prototype = {
	clean : function() {
		// todo: cleanup
		this.busy = false;
		this.offset = 0;
	},

	initialize : function(url, title, ts, doc, embed, idx, play) {
		if(!this.busy) {
			this.counter = 0;
			this.v_chunk = false;
			this.a_chunk = false;
			this.ctrl = false;
			this.step = 0;
			this.ts = ts;
			this.title = title;
			this.url = url;
			this.doc = doc;
			this.embed = embed;
			this.idx = idx;
			// this.autoplay = play;
			this.autoplay = raismth.autoplay;
			this.media = false;
			this.isSmooth = false;
			this.grabber_init_time = false;
			this.stato('UI->INIT', 'Loading user interface...', 1);
			this.auth();
		} else {
			this.stato('UI->INIT', 'Window busy', 1);
		}
	},

	wget : function(url, ttauth) {
		myDump('[RAISMTH] wget uri:' + url + ' ttauth: ' + ttauth + '\n');
		
		let ioserv = Cc["@mozilla.org/network/io-service;1"]
			.getService(Ci.nsIIOService);
		let channel = ioserv.newChannel(url, 0, null);
		channel.QueryInterface(Ci.nsIHttpChannel);
		
		if(ttauth != false){
			channel.requestMethod = "POST";
			channel.setRequestHeader("ttauth", ttauth, false);
			channel.setRequestHeader("viaurl", "www.rai.tv", false);
		}
		let stream = channel.open();
		try{
			if(!channel.responseStatus) return false;
			if (channel.responseStatus == 302) return(channel.getResponseHeader('Location'));
			if (channel.responseStatus != 200) {
				myDump('[RAISMTH] wget uri:' + url + ' | channel.responseStatus: ' + channel.responseStatus + '\n');
				return false;
			}
		} catch(e) {
			return false;
		}
		// } finally {
		
			let bstream = Cc["@mozilla.org/binaryinputstream;1"]
				.createInstance(Ci.nsIBinaryInputStream);
			bstream.setInputStream(stream);
			let size = 0;
			let file_data = "";
			while(size = bstream.available()) {
				file_data += bstream.readBytes(size);
			}
			return file_data;	
		// }
	},

	notify : function(idx) {
                raismth.slobj[idx].check(idx);
		this.stato('UI->NOTIFY', 'Network slowdown detected', 1);
		alert('UI->NOTIFY: Network slowdown detected');
	},

	auth : function(r) {
		if(!r) {
			this.stato('UI->AUTH', 'Stream Url: '+this.url, 2, 1);
			this.chan = raismth.parsers.parseURI(this.url);
			this.stato('UI->AUTH', 'chan: '+this.chan, 2);
			this.stato('UI->AUTH', 'Authenticating...', 2);
			this.ttauth = raismth.utils.bypassNTP(this.chan);
			this.stato('UI->AUTH', 'ttauth: '+this.ttauth, 2);
		}
		this.busy = true;
		// alert('stacca cavo di rete per provare relinker timer');
		let timeout = 10000;
		this.stato('UI->AUTH', 'Initializing timers...', 2);
                this.dl_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
		let idx = this.idx;
		let obj = raismth.slobj[idx];
                this.dl_timer.initWithCallback(function() { obj.notify(idx); }, timeout, Ci.nsITimer.TYPE_ONE_SHOT);
		this.mData = false;
		let mData = false;
		this.stato('UI->AUTH', 'Fetching Server Data...', 2);
		if(this.url.indexOf('.csm') == -1 && this.url.indexOf('.ism') == -1 && this.url.indexOf('.wmv') == -1) {
			if(this.url.indexOf('&output=20') == -1) {
				this.url += '&output=20';
			} else if(this.url.indexOf('&output=20')) {
				this.url = this.url.replace('&output=20','');
			}
			// **async channel**
			// this.wgetAsync(this.url, this.ttauth);
			mData = this.wget(this.url, this.ttauth);
		} else {
			mData = this.url;
		}
		this.cb(mData,this.idx);
	},

	cb : function(mData,idx) {
		let target = raismth.slobj[idx];
		switch(target.step) {
			case 0:
				target.mData = mData;
			break;
			case 1:
				target.manifest = mData;
			break;
		}
		raismth.slobj[idx].check(idx);
	},

	retry : function(step){
		this.counter++;
		if(this.counter < 4) {
			this.stato('UI->CHECK', 'Timeout Getting Server Data, Retrying...['+this.counter+']', 1);
			if(step == 0) {
				this.auth(true);
			} else {
				this.maniget(true);
			}
		} else {
			this.stato('UI->CHECK', 'Timeout Getting Server Data', 0, 9);
			this.clean();			
		}
	},

	check : function(idx) { // ,obj) {
		this.prototype = raismth.slobj[idx];
		this.stato('UI->CHECK', 'Killing Unused Timers...', 2);
		this.dl_timer.cancel();
		// **async channel**
		// this.channel.cancel(0x804B000E); // force NS_ERROR_NET_TIMEOUT
		this.stato('UI->CHECK', 'Checking Server Data...', 2);
		switch(this.step) {
			case 0:
				if(this.mData) {
					// alert('mData:' + this.mData);
					this.step++;
					this.parse();
				} else {
					this.retry(0);
				}
			break;
			case 1:
				if(this.manifest) {
					// alert('manifest:' + this.manifest);
					this.smthparse();
				} else {
					this.retry(1);
				}
			break;
		}
		// this.busy = false;
		// myDump('channel cancelled\n');
	},

	stato : function(c, msg, l, st, s) {		
		if(st) {
			let m = this.doc.getElementById('marq');
			let i = this.doc.getElementById('imgstatus');
			let mc = this.doc.getElementById('maincont');
			let cc = this.doc.getElementById('clipctrl');
			let ccc = this.doc.getElementById('cctrl');
			let cin = this.doc.getElementById('cinfo');
			let sl = this.doc.getElementById('slider');
			let elapsed = this.doc.getElementById('vtime');
			let tgt = false;
			if(l){
				/*
				tgt = cc.style.display == 'block' ? ccc : (mc.style.display == 'block' ? cin : false);
				// tgt = cc.style.display == 'block' ? cc : (mc.style.display == 'block' ? mc : false);
				if(tgt && st==(9||1)){ 
				 	tgt.click();
				}
				
				// if(tgt) tgt.click();
				// mc.style.display = 'none';
				// cc.style.display = 'none';
				*/
				// i.style.display = 'block';
				
			}
			switch(st){
				
				case 10:
					// i.style.display = 'none';
					if(sl) {
						let ret = raismth.utils.slider(msg,c);
						let txt = ret.str;
						let ts = ret.ts;
						// let slider = document.createTextNode(raismth.utils.slider(msg,c));

						// .textContent 
						if(sl.firstChild) sl.firstChild.nodeValue = txt;
						if(elapsed.firstChild) elapsed.firstChild.nodeValue = ts;
						// sl.appendChild(slider);
						// let pg = 0;
						// if(msg > 85) pg = 590*(parseInt(msg/85));
						// sl.scrollLeft = pg;
					}
					/*
					if(sl && msg%85 == 0) {
						if(msg == 0) sl.scrollLeft = 0;
						else sl.scrollLeft += 590;
					}
					*/
					// if(mc.style.display == 'none') cc.style.display = 'block';
				break;
				
				case 9:
					m.setAttribute('scrollamount', 10);			
					if(cc.style.display == 'block') cc.style.display = 'none';
					if(mc.style.display == 'block') mc.style.display = 'none';
					i.src = 'chrome://raismth/skin/'+raismth.skin+'/stop_64.png';
					i.style.display = 'block';
					/*
					if(this.isSmooth) {
						this.status_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
						let timeout = 2000;
						this.status_timer.initWithCallback( function() { ccc.click(); } , timeout, Ci.nsITimer.TYPE_ONE_SHOT);
						// if(cc.style.display == 'block') cc.style.display = 'none';
						// if(mc.style.display == 'block') mc.style.display = 'none';
						// i.style.display = 'block';
					}
					*/
					// tgt = cc.style.display == 'block' ? ccc : (mc.style.display == 'block' ? cin : false);
					// if(tgt) tgt.click();
				break;
				case 1:
					m.setAttribute('scrollamount', 50);					
					// alert('auth');
					i.src = 'chrome://raismth/skin/buff.gif';
				break;
				case 2:
					m.setAttribute('scrollamount', 100);
					if(cc.style.display == 'block') cc.style.display = 'none';
					if(mc.style.display == 'block') mc.style.display = 'none';

					i.src = 'chrome://raismth/skin/'+raismth.skin+'/play_64.png';
					i.style.display = 'block';
					/*
					if(this.isSmooth) {
						// this.display_blocks();
						this.status_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
						let timeout = 2000;
						// ccc.click();
						this.status_timer.initWithCallback( function() { ccc.click(); } , timeout, Ci.nsITimer.TYPE_ONE_SHOT);
					}
					*/
				break;
				
				case 3:
					alert('3');
					m.setAttribute('scrollamount', 10);
					// i.style.display = 'none';
					// ccc.click();
					// if(this.status_timer) {
					//	this.status_timer.cancel();						
					// }
					// alert('f');
					// tgt = this.doc.getElementById('cctrl'); 
					// tgt.click();
					// i.style.display = 'none';
					// cc.style.display = 'block';
				break;
				case 4:
					alert('4');
					m.setAttribute('scrollamount', 10);
					// i.style.display = 'none';
					// tgt = ccc;
					// ccc.click();
				break;
			}
			
			// this.status_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
			// let timeout = 3000;
			// if(this.isSmooth && st != 9 && st != 10) tgt = ccc;
			// this.status_timer.initWithCallback(function(){ i.style.display = 'none'; if(tgt) tgt.click(); }, timeout, Ci.nsITimer.TYPE_ONE_SHOT);
			
		}
		
		if(l) {
			let lim = parseInt(raismth.loglevel);
			if(l <= lim) {
				let a = this.doc.getElementById('statusmsg');
				let len = 12;
				while (c.length<len){
					c += " ";
				} 
				let log = document.createTextNode(c + ': ' + msg + '\n');
				a.appendChild(log);
				a.scrollTop = a.scrollHeight; 
			}
		}
			
	},
		
	parse : function() {
		let parsed = raismth.parsers.parsemData(this.mData);
		this.videoURI = parsed[0];
		this.isSmooth = parsed[1];
		if(this.videoURI.indexOf('mms') != -1)  this.videoURI = this.videoURI.replace('mms','http');
		this.stato('UI->PARSE', 'Parsed videoURI: '+this.videoURI, 2);
		this.videoUrl = this.videoURI;
                if(!this.isSmooth) {
			if(raismth.mms_player.path) {
				// if(raismth.utils.mkfifo(this.idx)) this.ctrl = true;
				if(raismth.features['mkfifo'] != false && raismth.mms_player.path.indexOf('mplayer') != -1) {
					// fixme
					raismth.mplayer_fifo = raismth.utils.mkfifo(this.idx);
					this.ctrl = true;
				} else {
					// fixme				
				}
				this.play();
			} else {
				this.stop();
				this.busy = false;
				this.stato('UI->STOP', 'MMS Player path not matched', 1, 9);
				alert('Plz check your setting about mms player path');
                                raismth.utils.display_prefs();				
			}
			// todo: mplayer-fifo file init
                } else {
			// alert('stacca cavo rete per provare timer maniget');
			// if(raismth.features['mplayer'] != false) {
			if(raismth.smth_player) {
				// if(!raismth.features['faad']) 
				this.maniget();
			} else {
				// fixme can't play this
				alert('Raismth cannot play this stream w/o mplayer [Smooth streaming detected].');
				this.kill = true;
				this.stop();
				this.busy = false;
				this.stato('UI->PARSE', 'Smooth streaming detecetd and mplayer missing. STOP!', 1, 9);
			}
                }
	},

	maniget : function(r){
		if(this.videoURI.indexOf('.ism') != -1) this.videoUrl = this.videoURI.substring(0, this.videoURI.lastIndexOf('/') + 1);
		this.stato('UI->PARSE', 'Live Smooth: ' + this.videoUrl, 2);
                let timeout = 15000;
		this.manifest = false;
                this.stato('UI->AUTH', 'Initializing timers...', 2);
		let idx = this.idx;
		let obj = raismth.slobj[idx];
                this.dl_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
                this.dl_timer.initWithCallback(function() { obj.notify(idx); }, timeout, Ci.nsITimer.TYPE_ONE_SHOT);
		// this.wgetAsync(this.videoURI.toString(), false);
		let mData = this.wget(this.videoURI.toString(), false);
                this.cb(mData,this.idx);
	},

	smthparse : function(){
               if(this.manifest) {
			this.h264 = false;
			this.media = false;
                        this.stato('UI->PARSE', 'Checking Manifest...', 1);
			this.dom = raismth.parsers.check_smth_manifest(this.manifest);
			if(!this.dom) {
				this.stato('UI->PARSE', 'Manifest malformed [FATAL]', 0, 9);
			} else {
				this.stato('UI->PARSE', 'Parsing Manifest...', 2);
	                        let data = raismth.parsers.parse_smth_manifest(this.dom);
				// alert(JSON.stringify(data));
				this.media = this.manifest_to_object(data, this.videoUrl);
				this.mvqli = false;
				this.offset = 0;
				// dump('\nDUMP BEGIN\n' + raismth.silverlight.odump(data,0,15) + '\nEOF DUMP\n');
			}
                        this.switch_action();
                } else {
                        this.stato('UI->PARSE', 'Bad HTTP status', 0, 9);
                        this.busy = false;
                }
		
	},

	manifest_to_object : function(data,url) {
		let media = {};
		media.IsLive = false;
		media.Clip = new Array();
		let stream_url = new Array();
		let video_chunks = new Array();
		let audio_chunks = new Array();
		let numclips = 0;
		let multi = false;
		let tgt = false;
		let target = data.SmoothStreamingMedia;
		if( (typeof(target[0].IsLive) != 'undefined' && target[0].IsLive.toLowerCase() === 'true') || typeof(target[0].Clip) == 'undefined' ) {
			media.IsLive = true;
			tgt = target;
			numclips = 1;
			// stream_url[0] = url;			
		} else if(typeof(target[0].Clip) != 'undefined') {
			tgt = target[0].Clip;
			numclips = tgt.length;
		}
		for(let c = 0; c < numclips; c++) {
			let t = {};
			t.StreamUrl = media.IsLive ? url : tgt[c].Url.substr(0, tgt[c].Url.lastIndexOf('/')+1);
			// t.StreamUrl = 'http://smoothreplay.rai.it/ReplayTV/replaytv_raitre-isml/2013-07-05-09-02-36-986/Segment107/replaytv_raitre.ism/';
			// alert(media.Clip[c].StreamUrl);
			t.StreamIndex = tgt[c].StreamIndex;
			media.Clip[c] = t;

			let avail = new Array();
			let def_video_idx = false;
                        let def_audio_idx = false;
                        let v_index = new Array();
                        let a_index = new Array();
                        let t_index = new Array();

			for(let d = 0; d < tgt[c].StreamIndex.length; d++) {
				avail[d] = tgt[c].StreamIndex[d];
				if(avail[d].Type == 'video') {
					v_index.push(d);
				} else if(avail[d].Type == 'audio') {
					a_index.push(d);
				} else if(avail[d].Type == 'text') {
					t_index.push(d);
				}
			        // ql, c_chunks, a_chunks, v_teml, a_templ
			
				if(v_index.length > 1) {
                                        for(let k in v_index) {
                                                let i = v_index[k];
                                                if(typeof(avail[i].Language) != 'undefined') {
							// todo: pref
                                                        if(avail[i].Language == 'ita') {
                                                                def_video_idx = i;
                                                        }
                                                }
                                        }
                                } else {
                                        def_video_idx = v_index[0];
                                }
                                if(a_index.length > 1) {
                                        for(let k in a_index) {
                                                let i = a_index[k];
                                                if(typeof(avail[i].Language) != 'undefined') {
                                                        // todo: pref
                                                        if(avail[i].Language == 'ita') {
                                                                def_audio_idx = i;
                                                        }
                                                }
                                        }
                                } else {
                                        def_audio_idx = a_index[0];
                                }

				for(let q = 0; q < avail[d].QualityLevel.length; q++){
					let sep = false;
					let customAttr = '';
					let ql = avail[d].QualityLevel[q];
					if(typeof(ql.CustomAttributes) != 'undefined') {
						let a = ql.CustomAttributes[0].Attribute;
						for(let ca = 0; ca < a.length; ca++) {
							sep = ca < a.length - 1 ? ',' : '';
							customAttr += a[ca].Name + '=' + a[ca].Value + sep;
						}
						t.StreamIndex[d].CustomAttr = customAttr;
					}
				}
			}
                        if(def_video_idx !== false && def_audio_idx !== false) {
                                t.def_video_idx = def_video_idx;
                                t.def_audio_idx = def_audio_idx;
				let v = tgt[c].StreamIndex[def_video_idx];
				let a = tgt[c].StreamIndex[def_audio_idx];
				let vo = v.Url.lastIndexOf('QualityLevels');
				let ao = a.Url.lastIndexOf('QualityLevels');
				// if (v.Url.indexOf('http') != -1) t.StreamUrl = v.Url.substring(0, vo);
				t.video_templ = v.Url.substring(vo);
				t.audio_templ = a.Url.substring(ao);
				// t.numclips = numclips;
			} else {
				media = false;
			}
		}
		// !commentf
		dump(raismth.silverlight.odump(media) + '\n');
		return media;
	},

	autoplay_pref : function(clip,force) {
		this.clip = clip ? clip : 0;
		if(this.clip < this.media.Clip.length) {
			let tgt = this.media.Clip[this.clip];
			let vsi = tgt.StreamIndex[tgt.def_video_idx];
			if(vsi.c.length > 5) {
				let asi = tgt.StreamIndex[tgt.def_audio_idx];
				let vql = vsi.QualityLevel;
				let l = vql.length;
				let vql_avail = new Array();
				for(let c = 0; c < l; c++){
					vql_avail[c] = new Array();
					vql_avail[c].push(vql[c].Index);
					let br = parseInt(vql[c].Bitrate);
					vql_avail[c].push(br);
					vql_avail[c].push(vql[c].CodecPrivateData);
				}
				vql_avail.sort(function(a, b) { return a[1] - b[1]; });
		
				let vlowest = vql_avail[0][1];
				let vlow = vql_avail.length > 1 ? vql_avail[1][1] : vlowest;
				let vhighest = vql_avail[vql_avail.length-1][1];
				let vhigh = vql_avail.length > 2 ? vql_avail[vql_avail.length-2][1] : vhighest;
		
				let pref_ql = raismth.default_ql;
				let pql = vlowest;
				let iql = 0;
				switch(pref_ql) {		
					case 'lowest':
						pql = vlowest;				
					break;
					case 'low':
						pql = vlow;
						iql = vql_avail.length > 1 ? 1 : 0;
					break;
					case 'high':
						pql = vhigh;
						iql = vql_avail.length > 2 ? vql_avail.length-2 : vql_avail.length-1;
					break;
					case 'highest':
						pql = vhighest;
						iql = vql_avail.length-1;
					break;
				}
				
				this.vql = this.mvqli === false ? pql : vql_avail[this.mvqli][1]; // raismth.adaptive ? vlowest : (this.mvqli === false ? pql : vql_avail[this.mvqli][1]);
				this.vql_avail = vql_avail;
				this.vqli = this.mvqli === false ? iql : this.mvqli;
				// alert(vlowest + ' ' + vlow + ' ' + vhigh + ' ' + vhighest);
	
				let aql = asi.QualityLevel;
				l = aql.length;
				let aql_avail = new Array();
				for(let c = 0; c < l; c++){
		                        aql_avail[c] = new Array();
		                        aql_avail[c].push(aql[c].Index);
		                        aql_avail[c].push(parseInt(aql[c].Bitrate));
		                        aql_avail[c].push(aql[c].CodecPrivateData);
				}
				aql_avail.sort(function(a, b) { return a[1] - b[1]; });
				let alowest = aql_avail[0][1];
				let alow = aql_avail.lenght > 1 ? aql_avail[1][1] : alowest;
				let ahighest = aql_avail[aql_avail.length-1][1];
				let ahigh = aql_avail.length > 2 ? aql_avail[aql_avail.length-2][1] : ahighest;
				this.aql = ahighest;
				this.aql_avail = aql_avail;
				this.aqli = aql_avail.length-1;
				// alert(alowest + ' ' + alow + ' ' + ahigh + ' ' + ahighest);
				// let d = (this.clip == 0 ) ? 170 : 0;
				this.v_chunk = this.offset > 0 ? this.v_chunk : vsi.c[0].t ? vsi.c[0].t : vsi.c[0].d;
				this.a_chunk = this.offset > 0 ? this.a_chunk : asi.c[0].t ? asi.c[0].t : asi.c[0].d;
				// let wts = raismth.rai_windows_ts[this.idx];

				this.temp_file = this.ts; // (new Date()).getTime(); // this.v_chunk;
				// alert(this.v_chunk + ' ' + this.a_chunk + ' ' + this.temp_file);		
			} else {
			  	this.stato('AUTOPLAY', 'Fake Clip [not enough chunks]. Trying to load next clip.', 1);
				this.clip++;
				this.autoplay_pref(this.clip,force);
			//  	// alert('EEEE\n' + raismth.silverlight.odump(vsi.c));
			}
			this.stato('UI->PLAY', 'Clip loaded', 0, 2);
		} else {
			this.stato('AUTOPLAY', 'Clip not available', 0, 9);
		}
	},
	
	switch_action : function(clip,force,a,idx) {
		if(idx) this.prototype = raismth.slobj[idx];
                // this.busy = false;
                if(!this.media) {
                        this.stato('UI->PLAY', 'Unable to parse media info', 0, 9);
                        this.clean();
                } else {
                        this.autoplay_pref(clip?clip:false, a?a:false);
                        if(this.autoplay||force) {
				// this.clean();				
				this.temp_files_init();
				if(this.myStream) {
					if(raismth.features['mkfifo'] != false) {
						raismth.mplayer_fifo = raismth.utils.mkfifo(this.idx);
						this.ctrl = true;
					} else {
						this.ctrl = false;
					}
					this.grabber_init();
					this.grab(false, 1);
				} else {
					this.stato('UI->PLAY', 'Error parsing media info', 0, 9);
				}
			} else if(!this.autoplay) {
				// todo:
				let ccc = this.doc.getElementById('cctrl');
				this.status_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
				let timeout = 2000;
				this.status_timer.initWithCallback( function() { ccc.click(); } , timeout, Ci.nsITimer.TYPE_ONE_SHOT);
			}
			// this.stato('UI->PLAY', 'Clip loaded', 0, 3);
			// this.clip_details();
		}
	},

	clip_details : function() {
		// let clip = this.object2html();
		// let tgt = raismth.rai_windows[this.idx].getElementById('ctrl');
	},

	temp_files_init : function() {
		// let clip = this.current_clip;
		// let ql = this.current_ql;
		// raismth.utils.afile_init(this.temp_file, this.idx, this.clip, this.aql);
		this.myStream = raismth.utils.temp_files_init(this.temp_file, this.idx, this.clip, this.vql, this.aql);		
		// this.v_ext = this.myStream.v_ext;
		// this.a_ext = this.myStream.a_ext;
	},

	grab : function(idx,grabber_step) {
		myDump('===============================> [RAISMTH] Grabber\n');
		if(idx) this.prototype = raismth.slobj[idx];
		this.vurl = this.chunk_url(true);
		// if(grabber_step) alert(this.vurl);
		this.aurl = this.chunk_url();
		this.grabber_step = grabber_step;
		this.grabber_run();
	},

	grabber_init : function() {
		myDump('===============================> [RAISMTH] Grabber init ' + this.idx + '\n');		
		this.grabber_timer = false;
		this.grabber_buffering_time = 0;
		this.grabber_paused_time = 0;
		this.bitrate_changed = false;
		this.decoding = false;
		this.skipped = 0;
		// this.skipped = this.offset && this.offset > 0 ? this.skipped : 0;
		this.kill = false;
		this.fault = false;
		this.a_skip = false;
		this.v_skip = false;
		this.avshift = false;
		this.playing = false;
		this.buffering = false;
		this.cc = this.offset && this.offset > 0 ? this.offset : 0;
		// alert(this.offset);
		this.h264 = false;
		this.grabber_init_time = (new Date()).getTime();
		this.grabber_counter = 0;
		this.busy = true;		
	},

	grabber_run : function(){
		if(!this.kill) {
			if(!this.eof) {
				if(!this.paused) {
					this.waiting = false;
					this.cc++;
					this.delay = 0;
					this.eof = false;
					let v_data = false;
					let a_data = false;
					let v_payload = false;
					let a_payload = false;
					let dlstart = false;
					let dlstop = false;
					let dltime = (new Date()).getTime();
					let tgt = this.media.Clip[this.clip];
					let vsi = tgt.StreamIndex[tgt.def_video_idx];
	
					myDump('===============================> [RAISMTH] Grabber run \n');
					myDump('===============================> [RAISMTH] vurl: ' + this.vurl + '\n');
					myDump('===============================> [RAISMTH] aurl: ' + this.aurl + '\n');
			
					this.avsync();
					// let vck = this.v_chunk;
					// let ack = this.a_chunk;
					if(!this.v_skip){
						v_payload = this.get_chunk(this.vurl, 2500, true);
						if(!v_payload) {
							this.stato('UI-GRAB', 'Video data corrupted', 0);
							this.fault = true;
						}
					} else {
						this.v_skip = false;
					}
					if(!this.a_skip && !this.fault) {
						a_payload = this.get_chunk(this.aurl, 1500, false);
						if(!a_payload) {
							this.stato('UI-GRAB', 'Audio data corrupted', 0);
							this.fault = true;
							this.v_skip = true;
							myDump('\n' + this.aurl + ' FAULT\n');
						}
					} else if(this.a_skip) {
						this.stato('UI-GRAB', 'Syncing...Audio chunk skipped [' + this.a_chunk + ']', 2);
						this.a_skip = false;
					}
					let delta = false;
					if(!this.fault) {
						dltime = (new Date()).getTime()-dltime;
						// this.stato('UI->GRAB', 'VCK:' + vck + '['+ v_payload.length + '] - ACK:' + ack + '[' + a_payload.length + ']', 2);
						// todo vskip
						if(v_payload) raismth.utils.write_bin(v_payload, this.temp_file + this.myStream.v_ext, this.idx, this.clip, this.vql, true, this.h264);
						if(a_payload) raismth.utils.write_bin(a_payload, this.temp_file + this.myStream.a_ext, this.idx, this.clip, this.aql, false);
						if(this.h264) this.h264 = false;
						this.vurl = this.chunk_url(true);
						this.aurl = this.chunk_url();
						delta = this.timer_delay();
						delta = delta > 0 ? dltime > delta ? 0 : delta - dltime : 0;				
						// this.dltime = dltime;
						this.stato('UI->GRAB', 'Waiting ' + delta + 'ms; A/V Sync: ' + this.delay + 'ms', 2);
						if(this.grabber_counter > 0) {
							this.grab_count = this.grabber_counter*10;
							this.grabber_counter = 0;
						}
						if(this.grab_count && this.grab_count > 0) {
							this.grab_count--;
						} else {
							this.grab_count = 0;
						}
						if(raismth.adaptive && delta > 0 && !this.bitrate_changed && this.grab_count == 0 && !this.ppaused) this.adjust_video_quality(dltime);
					} else {
						this.grabber_counter++;
						if(this.grabber_counter == 1) this.cc--;
						this.stato('UI->GRAB', 'Grabber fault: grabber_counter:' + this.grabber_counter + ' cc: ' + this.cc + ' vdata_size:' + v_data.length + ' - adata_size:' + a_data.length, 0);
						if(this.grabber_counter < 16) {
							this.stato('UI->GRAB', 'Retrying '+this.grabber_counter+'/15', 0);
							this.fault = false;
							// if(this.vqli>0) this.adjust_video_quality(false,this.vqli-1);
							delta = 3000;
						} else {
							this.stato('UI->GRAB', 'Grabber encountered fatal error', 0);
							// if(raismth.playall && !this.media.IsLive) {
								this.stato('UI->GRAB', 'Forcing EOF', 1, 9);
								this.eof = true;
							// }
							// return false;
						}
					}
					this.grabber_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
					let idx = this.idx;
					let obj = raismth.slobj[idx];
					if(obj) this.grabber_timer.initWithCallback(function() { obj.grab(idx); }, delta, Ci.nsITimer.TYPE_ONE_SHOT);
					if(delta > 0) this.waiting = true;
				} else {
					this.grabber_pause();
					// if(!this.media.IsLive)
				}				
			} else {
				this.stato('UI->GRAB', 'Clip EOF', 1);
				this.eof = false;				
				if(raismth.playall && !this.playing) {					
					this.clip++;
					this.stato('UI->GRAB', 'Trying to load next clip', 1);
					this.loader = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
					let idx = this.idx;
					let obj = raismth.slobj[idx];
					if(obj) this.loader.initWithCallback(function() { obj.switch_action(obj.clip, true, true, idx); }, 1000, Ci.nsITimer.TYPE_ONE_SHOT);
					// this.switch_action(this.clip, true, true); 
				}
					
			}
		} else {
			this.stato('UI->GRAB', 'User stop', 1);
		}
	},

	grabber_pause : function(indice) {
		if(indice) this.prototype = raismth.slobj[indice];
		this.ppaused = true;
		// this.buffering = true;
		let fifo = raismth.mplayer.fifo_init(this.idx);
		let cmd = 'osd_show_text "Paused..." 2000';
		raismth.mplayer.player_control(cmd, fifo);
		cmd = 'pause';
		raismth.mplayer.player_control(cmd, fifo);
		this.paused_time = (new Date()).getTime();
	},

	grabber_unpause : function(indice,grabbing) {
		this.prototype = raismth.slobj[indice];		
		let now = (new Date()).getTime();
		// this.buffering = false;
		let fifo = raismth.mplayer.fifo_init(indice);
		raismth.mplayer.player_control('pause', fifo);
		this.grabber_paused_time += now - this.paused_time;
		this.paused = false;
		if(!grabbing) this.grab(); // grabber_run();
		this.ppaused = false;
	},

	grabber_seek : function(indice,name,delta) {
		this.prototype = raismth.slobj[indice];
		let t = this.media.Clip[this.clip];
		let vsi = t.StreamIndex[t.def_video_idx];
		let asi = t.StreamIndex[t.def_audio_idx];

		this.seek = delta;	// todo
		if(!this.media.IsLive && !vsi.c[0].d) {
			let l = vsi.c.length;
			if(this.playing || this.paused || this.cc > 0) {
			/*
			    if(!this.seeking && this.waiting) {
				this.seeking = true;
				// if(this.ctrl_t) this.ctrl_t.cancel();
				// if(this.ctrl_s) this.ctrl_s.cancel();

				let t = this.media.Clip[this.clip];
				// let vsi = t.StreamIndex[t.def_video_idx];
				// let asi = t.StreamIndex[t.def_audio_idx];
				let l = vsi.c.length;
				if(this.cc + delta < l && this.cc + delta > 0) {
					// let vc = vsi.c[this.cc].t;
					// let ac = asi.c[this.cc-this.skipped].t;
					// let v = this.v_chunk;
					// let a = this.a_chunk;
					// if(!this.paused) this.paused = true;
					this.cc += delta;
					let v_chunk = vsi.c[this.cc].t;
					let aoffset = this.cc-this.skipped < asi.c.length ? this.cc-this.skipped : asi.c.length-1;
					let a_chunk = asi.c[aoffset].t;
					let delay = ((parseInt(this.a_chunk) - parseInt(this.v_chunk))/10000000).toFixed(3);
					dump('\nDELAY:'+delay+" skipped:" + this.skipped + "\n");
					if(delay > 2) {
						dump('\nDELAY in:'+delay+"\n");
						let toskip = parseInt(delay/2);
						this.skipped += toskip;
						a_chunk = asi.c[aoffset-toskip].t;
						// alert('skip:'+skip+' skipped:'+this.skipped);
						delay = ((parseInt(this.a_chunk) - parseInt(this.v_chunk))/10000000).toFixed(3);
						dump('\nDELAY out:'+delay+"\n");
					}
					
					
					this.v_chunk = v_chunk;
					this.a_chunk = a_chunk;
					// alert('Current video chunk: ['+vc+'] - this.v_chunk: [' + v + '] || Current audio chunk: ['+ac+'] - this.v_chunk: [' + a + ']');
					// this.stato(vsi.c.length, this.cc, false, 10);		
					// let tgt = this.doc.getElementById('play');
					// this.ctrl_t = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
					// this.ctrl_t.initWithCallback(function() { raismth.slobj[indice].grabber_unpause(indice); }, 2000, Ci.nsITimer.TYPE_ONE_SHOT);					
					let avshift = (((parseInt(this.v_chunk) - parseInt(this.a_chunk))/10000000)).toFixed(3);
					this.avshift = avshift;
					// let cmd = 'osd_show_text "Fwd 20 sec: ['+avshift+']" 1000';
					// let cmd = 'audio_delay "'+avshift+'"'; 
					this.ctrl_s = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
					let timeout = (this.init_buffer*2000);
					dump('\nAV Shift:'+this.avshift+" timeout:" + timeout+"\n");
					this.ctrl_s.initWithCallback(function() { let fifo = raismth.mplayer.fifo_init(indice); let cmd = 'audio_delay '+avshift+' 1'; raismth.mplayer.player_control(cmd, fifo); raismth.slobj[indice].seeking = false; }, timeout, Ci.nsITimer.TYPE_ONE_SHOT);
					// cmd = 'pause';
					// raismth.mplayer.player_control(cmd, fifo);
					
				} else {
					this.stato('GRAB->SEEK', 'Cannot seek. End of file reached.', 1);
				}
			    } else {
				if(this.waiting) this.stato('GRAB->SEEK', 'Cannot seek. Operation already in progress.', 1);
				else this.stato('GRAB->SEEK', 'Cannot seek. Grabber overloaded.', 1);
			    }
			*/
				this.stato('GRAB->SEEK', 'Cannot seek while player is running.', 1);

			} else {
				this.offset += delta;
				if(this.offset < l && this.offset >= 0){
					this.v_chunk = vsi.c[this.offset].t;
					let aoffset = (this.offset < asi.c.length) ? this.offset : asi.c.length-1;
					this.a_chunk = asi.c[aoffset].t;
					let delay = ((parseInt(this.a_chunk) - parseInt(this.v_chunk))/10000000).toFixed(3);
					if(delay > 2) {
					        let skip = parseInt(delay/2);
						this.skipped = skip;
						this.a_chunk = asi.c[aoffset-this.skipped].t;						
					}
					delay = ((parseInt(this.a_chunk) - parseInt(this.v_chunk))/10000000).toFixed(3);
					this.stato('GRAB->SEEK', 'Stream seek: ' + this.offset*2 + ' sec.', 1);
					this.stato(vsi.c.length, this.offset, false, 10);
				} else {
					this.stato('GRAB->SEEK', 'Cannot seek. End of file reached.', 1);
					this.offset -= delta;
				}
					//this.stato('GRAB->SEEK', 'Cannot seek. Player not running.', 1);
			}
		} else if(vsi.c[0].d) {
			this.stato('GRAB->SEEK', 'Cannot seek [manifest not supported]', 1);
		} else if(this.media.IsLive){
			this.stato('GRAB->SEEK', 'Live stream detected [not seekable]', 1);
		}
	},

	grabber_monitor_init : function(timeout) {
		if(this.playing && !this.ppaused){
			// this.ctrlTimers = 1;
			this.smthTimers = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
			let idx = this.idx;
			let obj = raismth.slobj[idx];
			this.smthTimers.initWithCallback(function() { obj.grabber_monitor_clock(idx); }, timeout, Ci.nsITimer.TYPE_REPEATING_PRECISE);
		}
	},

	grabber_monitor_kill : function(data) {
		// unpause on paused
		if(this.smthTimers) this.smthTimers.cancel();
		
		if(this.playing && !this.ppaused && this.buffering && data) {
			let now = (new Date()).getTime();
			this.buffering = false;
			let fifo = raismth.mplayer.fifo_init(this.idx);
			raismth.mplayer.player_control('pause', fifo);
			this.grabber_buffering_time += now - this.buffering_time;
		}
		
		// if(this.ctrlTimers == 2) {
		//	raismth.ctrlTimers = 0;
		// 	raismth.mplayer.management(this.idx, true);
		// }
	},

	grabber_monitor_clock : function(idx) {
		if(this.playing && !this.buffering) {
			this.stato('UI-GRAB', 'Network slowdown...', 1);
			this.grabber_monitor_counter = 0;  // todo: duplicate of this.grabber_counter, remove
			this.buffering = true;
			let fifo = raismth.mplayer.fifo_init(idx);
			let cmd = 'osd_show_text "Network slowdown..." 500';
			// raismth.mplayer.player_control(cmd, fifo);
			cmd = 'pause';
		        raismth.mplayer.player_control(cmd, fifo);
			this.buffering_time = (new Date()).getTime();
		} 
		this.grabber_monitor_counter++;
		myDump('[RAISMTH] grabber_monitor_clock: Counter ['+this.grabber_monitor_counter+']\n');
		// pause on unpaused
		// alert(idx);
		// raismth.mplayer.management(this.idx);
		// todo
	},

	avsync : function(){
		/*
		if(this.cc == 1) {
			let tgt = this.media.Clip[this.clip];
			let vsi = tgt.StreamIndex[tgt.def_video_idx];
			let asi = tgt.StreamIndex[tgt.def_audio_idx];
			let v = vsi.c[0].t;
			let a = asi.c[0].t;
			this.avshift = (((parseInt(v) - parseInt(a))/10000000)-0.15).toFixed(3);
			this.stato('UI-GRAB', 'AVSHIFT: ' + this.avshift, 2);
		}		
		*/
		this.delay = ((parseInt(this.a_chunk) - parseInt(this.v_chunk))/10000000).toFixed(3);
		if(this.delay > 2) {
		        this.stato('UI-GRAB', 'Syncing delay: ' + this.delay + ' ms', 2);
		        this.a_skip = true;
		        this.skipped++;
		}
		/*
		// if(this.cc == 1 || this.cc == this.skipped - 1) {
		if(this.cc == 1) {
			// alert(this.skipped);
			let tgt = this.media.Clip[this.clip];
			let vsi = tgt.StreamIndex[tgt.def_video_idx];
			let asi = tgt.StreamIndex[tgt.def_audio_idx];
			let v = vsi.c[0].t;
			let a = asi.c[this.skipped?this.skipped:0].t;
			this.avshift = (((parseInt(v) - parseInt(a))/10000000)-0.15).toFixed(3);
			this.stato('UI-GRAB', 'AVSHIFT: ' + this.avshift, 2);
		}
		*/
		// alert('h');
		if(this.cc == 1 || this.cc == this.skipped - 1 || this.cc == this.offset +1 ) {
			// this.avshift = ((parseInt(this.v_chunk) - parseInt(this.a_chunk))/10000000);
			this.avshift = (((parseInt(this.v_chunk) - parseInt(this.a_chunk))/10000000)-0.15).toFixed(3); // -0.15
			this.stato('UI-GRAB', 'AVSHIFT: ' + this.avshift, 2);
		}
		let tgt = this.media.Clip[this.clip];
		let vsi = tgt.StreamIndex[tgt.def_video_idx];
		this.stato(vsi.c.length, this.cc, false, 10);
	},

	adjust_video_quality : function(dltime, force, indice) {
		let ret = false;
		if(indice) this.prototype = raismth.slobj[indice];
		let idx = this.idx;
		let obj = raismth.slobj[idx];
		if( (this.cc > 10 && this.cc%10==0) || force) {

                // let tgt = this.media.Clip[this.clip];
                // let vsi = tgt.StreamIndex[tgt.def_video_idx];
		// alert(vsi.c[vsi.c.length-1].t);

			if(!this.bitrate_changed) {
				let c = false;
				this.current_hdr = this.vql_avail[this.vqli][2];
				if(force) {
					c = true;
					let txt = this.vqli < force ? 'increased' : 'decreased';
					this.vqli = force;
					obj.stato('UI->CTRLS', 'Video quality ' + txt, 1);
				} else {
					if(dltime > 1800) {
						if(this.vqli>0)	{
							c = true;
							this.vqli--;
							obj.stato('UI->CTRLS', 'Video quality decreased', 1);
						} else {
							obj.stato('UI->CTRLS', 'Cannot decrease vql. Current = Min', 1);
							// cannot decrease
						}
					} else if(dltime < 1000) {
						if(this.vqli<this.vql_avail.length-1) {					
							c = true;
							this.vqli++;
							obj.stato('UI->CTRLS', 'Video quality increased', 1);
						} else {
							obj.stato('UI->CTRLS', 'Cannot increase vql. Current = Max', 1);
							// cannot increase					
						}
					}
				}
				if(c){
					ret = true;
					let target = Cc["@mozilla.org/file/local;1"].createInstance(Ci.nsILocalFile);
					let path = raismth.temp_folder.path + raismth.sep + this.temp_file + this.myStream.v_ext;
					// let idx = this.idx;
					target.initWithPath( path );
					this.offset_before = target.fileSize;
					let hdr = this.vql_avail[this.vqli][2];
					let hdr_bin = raismth.utils.manifest2bin(hdr);
					raismth.utils.write_h264_tag(target, true, hdr_bin, idx);
					this.vql = this.vql_avail[this.vqli][1];
					let offset = target.fileSize;
					let now = (new Date()).getTime();
					let playing_time = now - this.playing_time;
					let timeout = (this.cc*2000)-playing_time+this.grabber_buffering_time+2000;
					this.bitrate_changed = true;
					this.my_timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
			                // let obj = raismth.slobj[idx];
			                this.my_timer.initWithCallback(function() { obj.h264 = true; obj.stato('UI-GRAB', 'Bitrate changed', 2);}, timeout, Ci.nsITimer.TYPE_ONE_SHOT);
				}
			} else {
				// let obj = raismth.slobj[this.idx];
				obj.stato('UI->CTRLS', 'Operation already in progress. Please try again later', 1);
			}
		}
		return ret;
	},

	timer_delay : function() {
		let now = (new Date()).getTime();
		let vtime = (this.offset && this.offset > 0 ? this.cc - this.offset : this.cc)*2000;
		let delta = now - this.grabber_init_time - this.grabber_buffering_time - this.grabber_paused_time;
		myDump('\n[RAISMTH] timer_delay: grabber_buffering_time [' + this.grabber_buffering_time + ']\n');
		myDump('\n[RAISMTH] timer_delay: grabber_paused_time [' + this.grabber_paused_time + ']\n');
		this.stato('GRAB->COUNT', this.cc, 2);
		if(this.cc < 6 + this.offset) {
			delta = 200;
		} else {
			delta = vtime - delta;
			// dump(delta + ' ms delta\n');
			// TODO: pref
			if(delta < 10000) {
				delta = 0;
			} else {
				delta = 2000;
			}
			// dump('Waiting ' + delta + ' ms...\n');
		}		
		if(this.cc == (this.offset ? this.offset + 5 : this.skipped + 5) && !this.playing) {
			this.init_buffer = this.skipped + 5;
			this.play();
			this.playing = true;
			this.playing_time = (new Date()).getTime();
		} // else if(this.cc == (10 + this.skipped) && this.playing) this.h264 = true;
		
		return delta;
	},	

	get_chunk : function(url, timeout, v) {
		let payload = false;
		let tgt = this.media.Clip[this.clip];
		let vsi = tgt.StreamIndex[tgt.def_video_idx];
		let asi = tgt.StreamIndex[tgt.def_audio_idx];

		this.grabber_monitor_init(timeout);
		let dlstart = (new Date()).getTime();
		let data = this.wget(url, false);
		let dlstop = (new Date()).getTime();
		this.grabber_monitor_kill(data?true:false);
		if(data) {
		        let dltime = dlstop - dlstart;
		        let dlsize = data.length;
		        let dlspeed = (1000*dlsize)/(dltime*1048576);
		        myDump('[RAISMTH] get_chunk : Dltime ' + dltime + ' ms, lenght ' + dlsize + ' bytes, avg. speed ' + dlspeed.toFixed(3) + ' MB/sec\n');
		        let next_chunk = data.lastIndexOf("=uuid") != -1 ? raismth.utils.bin2hex(data.substr(data.lastIndexOf("=uuid")+26, 8)) : false;
		        payload = data.lastIndexOf("mdat") != -1 ? data.substr(data.lastIndexOf("mdat")+4) : false;
			if(!next_chunk) {
				let i = this.cc; // -1; 
				if((v && vsi.c[0].t) || (!v && asi.c[0].t)) i--;
				next_chunk = v ? parseInt(this.v_chunk) + parseInt(vsi.c[i].d) : parseInt(this.a_chunk) + parseInt(asi.c[i].d);
				myDump('[RAISMTH] next_chunk: ' + next_chunk + ' url: ' + url + ' index: ' + i + '\n');
			}
			// alert(next_chunk);
			if(v) this.v_chunk = next_chunk;
			else  this.a_chunk = next_chunk;
			
			if(v) {
			        let tgt = this.media.Clip[this.clip];
			        let vsi = tgt.StreamIndex[tgt.def_video_idx];
				if(this.cc == vsi.c.length && !this.media.IsLive && !raismth.ignoreeof) this.eof = true;
				
			        // if(parseInt(next_chunk) == parseInt(vsi.c[vsi.c.length-1].t) && !this.media.IsLive && !raismth.ignoreeof) this.eof = true;
				/*
			        if ( ( raismth.ignoreeof && this.cc+this.offset < vsi.c.length) || !raismth.ignoreeof ) {
			                if(this.busy && !this.media.IsLive && !this.ctrl_s && (parseInt(next_chunk) != parseInt(vsi.c[this.cc+this.offset].t))) {
			                        // alert(this.cc + ' ' + this.offset);
			                        alert('mismatch: ' + next_chunk + ' ' + vsi.c[this.cc+this.offset].t);
			                        this.fault = true;
			                }
			        }
				*/
			}
			
		} else {
		        this.stato('UI-GRAB', 'Chunk contains no data', 0);
		        this.fault = true;
		}
		return payload;
	},
	
        chunk_url : function(tipo) {  // args, brate, tipo		
                let target = null;
                let start = null;
		let ql = null;
		let tgt = this.media.Clip[this.clip];
                if(tipo) {
			target = tgt.video_templ;
			if(target.indexOf('{CustomAttributes}') != -1) {
				target = target.replace(/{CustomAttributes}/i, tgt.StreamIndex[tgt.def_video_idx].CustomAttr);
			}
                        start = this.v_chunk;
			ql = this.vql;
                } else {
			target = tgt.audio_templ;
			if(target.indexOf('{CustomAttributes}') != -1) {
				target = target.replace(/{CustomAttributes}/i, tgt.StreamIndex[tgt.def_audio_idx].CustomAttr);
			}
                        start = this.a_chunk;
			ql = this.aql;
                }
                let url = this.media.Clip[this.clip].StreamUrl + target;		
                url = url.replace(/{bitrate}/i, ql);
                url = url.replace(/{start time}/i, start);
                return url;		
        },
	
	play : function(){
		if(this.embed) {
			this.stato('UI->PLAY', 'embed: '+this.embed, 1, 2);
			let url = this.videoURI;
			let isRadio = false;
		} else {
			if((this.isSmooth && raismth.smth_player)||(!this.isSmooth && raismth.mms_player)){
				let pprocess = raismth.player.load(this.idx);
				if(!pprocess) {
					this.stato('UI->PLAY', 'Error loading external player', 0, 9);
				} else {		
					this.pprocess = pprocess;
					let t = "MMS";
					let l = 2;
					if(this.isSmooth) {
						t = "SMTH";
						l = 5;
						let timer = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
						let idx = this.idx;
						let obj = raismth.slobj[idx];
						timer.initWithCallback(function() { obj.h264 = true; }, 3000, Ci.nsITimer.TYPE_ONE_SHOT);
						// this.h264 = true;
					} else {
						this.playing = true;
					}
					this.stato('UI->PLAY', 'Starting ' + t + ' player...', 1, l);
				}			
			} else {
				this.kill = true;
				this.stop();				
				this.busy = false;
				this.stato('UI->STOP', 'SMTH Player path not matched', 1, 9);
				alert('Plz check your setting about smth player path');
				raismth.utils.display_prefs();
			}
		}
	},

	mmsplay : function(){
		this.stato('UI->PLAY', 'embed: '+this.embed, 1, 2);
		let url = this.videoURI;
		// if(url.indexOf('mms') != -1)  url = url.replace('mms','http');
		let isRadio = false;

		if(this.embed) {
			// nope
		} else {
			let pprocess = raismth.player.load(this.idx);
			if(!pprocess) {
			        this.stato('UI->PLAY', 'Error loading external player', 0, 9);
			} else {
				// alert(this.chan);
				this.pprocess = pprocess;
			        // raismth.player_istances[this.idx] = process;
			        // raismth.player_istances_pid[this.idx] = this.chan;
				this.stato('UI->PLAY', 'Starting MMS player...', 1, 2);
			}
		}
	},

	smthplay : function(){
		let pprocess = raismth.player.load(this.idx);
		if(!pprocess) {
			this.stato('UI->PLAY', 'Error loading external player', 0, 9);
		} else {
			// alert(this.chan);
			this.pprocess = pprocess;
			this.h264 = true;
			// raismth.player_istances[this.idx] = process;
			// raismth.player_istances_pid[this.idx] = this.chan;
			this.stato('UI->PLAY', 'Starting SMTH player...', 1, 5);
		}
	},

	stop : function(){
		// if(this.embed) this.busy = false;
		if(this.ctrl && this.pprocess && this.pprocess.isRunning) {
			myDump('[RAISMTH] myPlayer.stop: running istance index: ' + this.idx + '\n');
			// raismth.player_istances[this.idx].kill();
			raismth.utils._pkill(this.idx);	
			this.busy = false;
			this.stato('UI->STOP', 'index: '+this.idx+' embed: '+this.embed, 1, 9);
		} 
		if(this.isSmooth) {
			this.cc = 0;		
			this.offset = 0;
		}
	},

}

theApp.myPlayer.__proto__ = theApp.myPlayer.prototype;

}});

