/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.DocumentType;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EntityReferenceImpl
extends ParentNode
implements EntityReference {
    static final long serialVersionUID = -7381452955687102062L;
    protected String name;

    public EntityReferenceImpl(CoreDocumentImpl coreDocumentImpl, String string) {
        super(coreDocumentImpl);
        this.name = string;
        this.isReadOnly(true);
        this.needsSyncChildren(true);
    }

    public short getNodeType() {
        return 5;
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public Node cloneNode(boolean bl) {
        EntityReferenceImpl entityReferenceImpl = (EntityReferenceImpl)super.cloneNode(bl);
        entityReferenceImpl.setReadOnly(true, bl);
        return entityReferenceImpl;
    }

    protected void synchronizeChildren() {
        NamedNodeMap namedNodeMap;
        this.needsSyncChildren(false);
        DocumentType documentType = this.getOwnerDocument().getDoctype();
        if (null != documentType && null != (namedNodeMap = documentType.getEntities())) {
            EntityImpl entityImpl = (EntityImpl)namedNodeMap.getNamedItem(this.getNodeName());
            if (entityImpl == null) {
                return;
            }
            this.isReadOnly(false);
            Node node = entityImpl.getFirstChild();
            while (node != null) {
                Node node2 = node.cloneNode(true);
                this.insertBefore(node2, null);
                node = node.getNextSibling();
            }
            this.setReadOnly(true, true);
        }
    }
}

