/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.PrintWriter;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.dom3.DOMLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;

public class DOMErrorHandlerWrapper
implements XMLErrorHandler,
DOMErrorHandler {
    protected DOMErrorHandler fDomErrorHandler;
    boolean eStatus = true;
    protected PrintWriter fOut;

    public DOMErrorHandlerWrapper() {
        this.fOut = new PrintWriter(System.err);
    }

    public DOMErrorHandlerWrapper(DOMErrorHandler dOMErrorHandler) {
        this.fDomErrorHandler = dOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        this.fDomErrorHandler = dOMErrorHandler;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDomErrorHandler;
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        DOMErrorImpl dOMErrorImpl = new DOMErrorImpl(0, xMLParseException);
        this.fDomErrorHandler.handleError(dOMErrorImpl);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        DOMErrorImpl dOMErrorImpl = new DOMErrorImpl(1, xMLParseException);
        this.fDomErrorHandler.handleError(dOMErrorImpl);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        DOMErrorImpl dOMErrorImpl = new DOMErrorImpl(2, xMLParseException);
        this.fDomErrorHandler.handleError(dOMErrorImpl);
    }

    public boolean handleError(DOMError dOMError) {
        this.printError(dOMError);
        return this.eStatus;
    }

    private void printError(DOMError dOMError) {
        int n = -1;
        this.fOut.print("[");
        if (n == 0) {
            this.fOut.print("Warning");
        } else if (n == 1) {
            this.fOut.print("Error");
        } else {
            this.fOut.print("Fatal Error");
            this.eStatus = false;
        }
        this.fOut.print("] ");
        this.fOut.print(": ");
        this.fOut.print(dOMError.getMessage());
        this.fOut.print(':');
        this.fOut.print(dOMError.getException());
        DOMLocator dOMLocator = dOMError.getLocation();
        if (dOMLocator != null) {
            this.fOut.print(":L ");
            this.fOut.print(dOMLocator.getLineNumber());
            this.fOut.print(":C ");
            this.fOut.print(dOMLocator.getColumnNumber());
            this.fOut.print(": ");
            this.fOut.print(dOMLocator.getOffset());
            this.fOut.print(": ");
            this.fOut.print(dOMLocator.getErrorNode().getNodeName());
            String string = dOMLocator.getUri();
            if (string != null) {
                int n2 = string.lastIndexOf(47);
                if (n2 != -1) {
                    string = string.substring(n2 + 1);
                }
                this.fOut.print(": ");
                this.fOut.print(string);
            }
        }
        this.fOut.println();
        this.fOut.flush();
    }
}

