/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.util.Scanner;
import org.jmol.api.JmolViewer;
import org.jmol.script.ScriptContext;

public class InputScannerThread
extends Thread {
    private JmolViewer vwr;
    private Scanner scanner;
    private boolean isSilent;
    private StringBuilder buffer = new StringBuilder();

    InputScannerThread(JmolViewer jmolViewer, boolean bl) {
        this.vwr = jmolViewer;
        this.isSilent = bl;
        this.start();
    }

    @Override
    public synchronized void start() {
        this.scanner = new Scanner(System.in);
        this.scanner.useDelimiter("\n");
        super.start();
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setPriority(1);
            this.say(null);
            block3: while (true) {
                Thread.sleep(100L);
                while (true) {
                    if (!this.scanner.hasNext()) continue block3;
                    String string = this.scanner.next();
                    if ((string = string.substring(0, string.length() - 1)).toLowerCase().equals("exitjmol")) {
                        System.exit(0);
                    }
                    if (this.vwr.checkHalt(string, false)) {
                        this.buffer = new StringBuilder();
                        string = "";
                    }
                    this.buffer.append(string).append('\n');
                    if (this.checkCommand() || this.buffer.length() != 1) continue;
                    this.say(null);
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void say(String string) {
        if (this.isSilent) {
            return;
        }
        if (string == null) {
            string = "Enter: \nquit     to stop processing and re-initialize input\nexit     to stop all script processing\nexitJmol to exit Jmol\nJmol> ";
        }
        System.out.print(string);
        System.out.flush();
    }

    private boolean checkCommand() {
        String string = this.buffer.toString();
        if (string.length() == 1) {
            return false;
        }
        Object object = this.vwr.scriptCheck(string);
        if (object instanceof String) {
            string = (String)object;
            if (string.indexOf("missing END") >= 0) {
                return true;
            }
            this.say(string);
            return false;
        }
        if (object instanceof ScriptContext) {
            ScriptContext scriptContext = (ScriptContext)object;
            if (!scriptContext.isComplete) {
                return true;
            }
        }
        this.buffer = new StringBuilder();
        string = string + "\u0001##noendcheck";
        if (this.isSilent) {
            this.vwr.evalStringQuiet(string);
        } else {
            this.vwr.evalString(string);
        }
        return true;
    }
}

