/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Dots;
import org.jmol.util.C;
import org.jmol.util.Geodesic;

public class DotsRenderer
extends ShapeRenderer {
    public boolean iShowSolid;
    public int screenLevel;
    public int screenDotCount;
    public int[] scrCoords;
    public int[] faceMap = null;
    private V3 v3temp = new V3();
    private P3i scrTemp = new P3i();
    private int dotScale;
    protected float testRadiusAdjust;

    protected void initRenderer() {
        this.screenLevel = Dots.MAX_LEVEL;
        this.screenDotCount = Geodesic.getVertexCount((int)Dots.MAX_LEVEL);
        this.scrCoords = new int[3 * this.screenDotCount];
    }

    protected boolean render() {
        this.render1((Dots)this.shape);
        return false;
    }

    protected void render1(Dots dots) {
        if (!this.iShowSolid && !this.g3d.setC((short)4)) {
            return;
        }
        int n = (int)this.vwr.getScalePixelsPerAngstrom(true);
        int n2 = this.iShowSolid || n > 20 ? 3 : (n > 10 ? 2 : (this.screenLevel = n > 5 ? 1 : 0));
        if (!this.iShowSolid) {
            this.screenLevel += this.vwr.getInt(553648143) - 3;
        }
        this.screenLevel = Math.max(Math.min(this.screenLevel, Dots.MAX_LEVEL), 0);
        this.screenDotCount = Geodesic.getVertexCount((int)this.screenLevel);
        this.dotScale = this.vwr.getInt(0x21000010);
        BS[] bSArray = dots.ec.getDotsConvexMaps();
        int n3 = dots.ec.getDotsConvexMax();
        while (--n3 >= 0) {
            Atom atom = this.ms.at[n3];
            BS bS = bSArray[n3];
            if (bS == null || !this.isVisibleForMe(atom) || !this.g3d.isInDisplayRange(atom.sX, atom.sY)) continue;
            try {
                float f = dots.ec.getAppropriateRadius(n3) + this.testRadiusAdjust;
                int n4 = 0;
                int n5 = 0;
                int n6 = Math.min(bS.size(), this.screenDotCount);
                while (--n6 >= 0) {
                    if (!bS.get(n6)) continue;
                    this.v3temp.scaleAdd2(f, (T3)Geodesic.getVertexVector((int)n6), (T3)atom);
                    this.tm.transformPtScr((T3)this.v3temp, this.scrTemp);
                    if (this.faceMap != null) {
                        this.faceMap[n6] = n5;
                    }
                    this.scrCoords[n5++] = this.scrTemp.x;
                    this.scrCoords[n5++] = this.scrTemp.y;
                    this.scrCoords[n5++] = this.scrTemp.z;
                    ++n4;
                }
                if (n4 == 0) continue;
                this.renderConvex(C.getColixInherited((short)dots.colixes[n3], (short)atom.colixAtom), bS, n4);
            }
            catch (Exception exception) {
                System.out.println("Dots rendering error");
                System.out.println(exception.toString());
            }
        }
    }

    protected void renderConvex(short s, BS bS, int n) {
        this.colix = C.getColixTranslucent3((short)s, (boolean)false, (float)0.0f);
        this.renderDots(n);
    }

    protected void renderDots(int n) {
        this.g3d.setC(this.colix);
        this.g3d.drawPoints(n, this.scrCoords, this.dotScale);
    }
}

