/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<K, T> {
    private static Cache NULL;

    private Cache() {
    }

    public static <K, T> Cache<K, T> getNullCache() {
        if (NULL != null) {
            return NULL;
        }
        NULL = new Cache<K, T>();
        return NULL;
    }

    public static <K, T> Cache<K, T> newSoftCache() {
        return new SoftCache();
    }

    public static <K, T> Cache<K, T> newStrongSoftCache(int size2) {
        return new SoftCache(size2);
    }

    public T get(K key) {
        return null;
    }

    public T put(K key, T value2) {
        return null;
    }

    public T remove(K key) {
        return null;
    }

    public void clear() {
    }

    public int size() {
        return 0;
    }

    static final class SoftCache<K, T>
    extends Cache<K, T> {
        private final Map<K, Ref<K, T>> cache;
        private final ReferenceQueue<T> refQueue = new ReferenceQueue();
        private final int strongLimit;
        private final SortedMap<Ref<K, T>, T> strongRefs;

        private SoftCache() {
            this.strongLimit = 0;
            this.cache = new ConcurrentHashMap<K, Ref<K, T>>();
            this.strongRefs = null;
        }

        private SoftCache(int limit) {
            this.strongLimit = limit;
            int capacity = Math.min(limit, 32);
            this.cache = new ConcurrentHashMap<K, Ref<K, T>>(capacity);
            this.strongRefs = new TreeMap<Ref<K, T>, T>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(K key) {
            Object result = null;
            Ref<K, T> ref = this.cache.get(key);
            if (ref != null) {
                result = ref.get();
                if (result == null) {
                    this.cache.remove(key);
                } else if (this.strongRefs != null) {
                    SortedMap<Ref<K, T>, T> sortedMap = this.strongRefs;
                    synchronized (sortedMap) {
                        this.strongRefs.remove(ref);
                        this.strongRefs.put(ref.recordAccess(), result);
                        if (this.strongLimit > 0 && this.strongRefs.size() > this.strongLimit) {
                            this.strongRefs.remove(this.strongRefs.firstKey());
                        }
                    }
                }
            }
            return (T)result;
        }

        @Override
        public T put(K key, T value2) {
            this.purgeRefQueue();
            SoftReference prev = this.cache.put(key, new Ref(value2, key, this.refQueue));
            return prev == null ? null : (T)prev.get();
        }

        @Override
        public T remove(K key) {
            this.purgeRefQueue();
            SoftReference removed = this.cache.remove(key);
            return removed == null ? null : (T)removed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            if (this.strongRefs != null) {
                SortedMap<Ref<K, T>, T> sortedMap = this.strongRefs;
                synchronized (sortedMap) {
                    this.strongRefs.clear();
                }
            }
            this.purgeRefQueue();
            this.cache.clear();
            this.purgeRefQueue();
        }

        @Override
        public int size() {
            this.purgeRefQueue();
            return this.cache.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void purgeRefQueue() {
            Ref ref;
            while ((ref = (Ref)this.refQueue.poll()) != null) {
                ReferenceQueue<T> referenceQueue = this.refQueue;
                synchronized (referenceQueue) {
                    this.cache.remove(ref.key);
                }
            }
        }

        private static class Ref<K, T>
        extends SoftReference<T>
        implements Comparable<Ref> {
            private final K key;
            volatile long access;

            private Ref(T value2, K key, ReferenceQueue<T> queue) {
                super(value2, queue);
                this.key = key;
                this.recordAccess();
            }

            final Ref<K, T> recordAccess() {
                this.access = System.currentTimeMillis();
                return this;
            }

            public boolean equals(Object obj) {
                if (obj instanceof Ref) {
                    return this.key.equals(((Ref)obj).key);
                }
                return false;
            }

            public int hashCode() {
                return this.key.hashCode();
            }

            @Override
            public int compareTo(Ref that) {
                long diff = this.access - that.access;
                if (diff == 0L) {
                    return 0;
                }
                return diff > 0L ? 1 : -1;
            }
        }
    }
}

