/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.resourcetracker;

import de.intarsys.tools.resourcetracker.IResourceReference;
import de.intarsys.tools.resourcetracker.PhantomResourceReference;
import de.intarsys.tools.resourcetracker.ResourceFinalizer;
import de.intarsys.tools.resourcetracker.SoftResourceReference;
import de.intarsys.tools.resourcetracker.WeakResourceReference;
import java.lang.ref.ReferenceQueue;

public abstract class ResourceTracker {
    private IResourceReference[] references;
    private int next = 0;
    private final ResourceFinalizer finalizer;

    public ResourceTracker() {
        this(500);
    }

    public ResourceTracker(int n) {
        this.references = new IResourceReference[n];
        this.finalizer = ResourceFinalizer.get();
    }

    public ResourceTracker(ResourceFinalizer resourceFinalizer) {
        this(resourceFinalizer, 500);
    }

    public ResourceTracker(ResourceFinalizer resourceFinalizer, int n) {
        this.references = new IResourceReference[n];
        this.finalizer = resourceFinalizer;
    }

    protected synchronized IResourceReference add(IResourceReference iResourceReference) {
        this.finalizer.ensureStarted();
        if (this.next >= this.references.length) {
            System.gc();
            this.finalizer.drainQueue();
            if (this.next >= this.references.length) {
                IResourceReference[] iResourceReferenceArray = new IResourceReference[this.references.length << 1];
                System.arraycopy(this.references, 0, iResourceReferenceArray, 0, this.references.length);
                this.references = iResourceReferenceArray;
            }
        }
        this.references[this.next++] = iResourceReference;
        return iResourceReference;
    }

    protected abstract void basicDispose(Object var1);

    protected void dispose(IResourceReference iResourceReference) {
        this.remove(iResourceReference);
        if (iResourceReference.getResource() != null) {
            this.basicDispose(iResourceReference.getResource());
        }
    }

    protected ReferenceQueue getQueue() {
        return this.finalizer.getQueue();
    }

    protected synchronized void remove(IResourceReference iResourceReference) {
        int n = this.next;
        int n2 = 0;
        while (n2 < n) {
            if (this.references[n2] == iResourceReference) {
                --this.next;
                this.references[n2] = this.references[this.next];
                this.references[this.next] = null;
                break;
            }
            ++n2;
        }
    }

    public IResourceReference trackPhantom(Object object, Object object2) {
        return this.add(new PhantomResourceReference(object, object2, this));
    }

    public IResourceReference trackSoft(Object object, Object object2) {
        return this.add(new SoftResourceReference(object, object2, this));
    }

    public IResourceReference trackWeak(Object object, Object object2) {
        return this.add(new WeakResourceReference(object, object2, this));
    }
}

