# coding=utf-8
from __future__ import unicode_literals
from .. import Provider as AddressProvider


class Provider(AddressProvider):

    city_formats = ('{{city_name}}', )

    street_name_formats = (
        '{{first_name}} {{last_name}}',
        '{{last_name}}'
    )

    street_address_formats = ('{{building_number}} {{street_name}}', )

    address_formats = ('{{street_address}}\n{{city}} {{postcode}}','{{street_address}}\n{{city}}-{{postcode}}' )

    building_number_formats = ('####','###', '##', '#', '#/#','##/##','##/###','##/####')

    postcode_formats = ('######', )

    cities = (
       'आदिलाबाद','अगरतला','अहमदाबाद', 'अहमदनगर' , 'अजमेर' ,'अम्बाजी' ,'अमरपुर' ,'इलाहाबाद' ,'अकोला' 'अखनूर', 
       'अन्तर्गत' , 'अलांग' ,'अलीगढ' ,'दादरा और नागर हवेली', 'अमरावती' , 'अमरोहा', 'अनन्तपुर', 'करना', 'जिससेबेलारी',
       'अनंतनाग','भागलपुर',  'पेपरबोर्डस','त्रिबेनी', 'टिसूज', 'भद्रक', 'बचेली' ,'बहादुरगंज' ,'बहादुरगढ' ,'चिरमिरी', 'चिराला', 'चित्रदुर्ग' ,
       'चित्तूर' ,'चित्रकूट' ,'देवगढ़' , 'दालखोला' , 'देवास', 'चंडीगढ', 'फादर', 'चिन्नफ', 'चिपलुन', 'चक्रधरपुर', 'चंबा', 'फतहपुर', 'फतेहपुर',
       'फतेहगढ', 'फतहपुर' ,'फतहपुर' ,'चित्तूर' ,'चित्रकूट', 'सभापतिने', 'देवगढ़', 'द्वारारस्वीकृति', 'दालखोला', 
       'धर्मापुरी', 'पाकाला', 'धारवाड' ,'असम',  'देहरा' , 'रानीताल' ,'खडगपुर', 'मोकामा', 'मोकोकचुंग' ,'जिलोंपर' ,'विस्तारण' ,'मोतिहारी' 
    )

    states = (
        'अरूणाचल प्रदेश', 'बिहार', 'असम' ,'आंध्र प्रदेश' ,'छत्तीसगढ','हरियाणा' ,'गुजरात' ,'हिमाचल प्रदेश', 'गोवा', 'मध्य प्रदेश', 'महाराष्ट्र', 'कश्मीर',
        'केरल' , 'कर्नाटक', 'मणिपुर' ,'मिजोरम', 'मेघालय', 'सिबक्कम' ,'राजस्थान','पंजाब', 'उडीसा' ,'उत्तरांचल' ,'उत्तर प्रदेश', 'तमिलनाडु', 'त्रिपुरा',
        'पश्चिमी बंगाल', 'अंडमान और निकोबार', 'द्वीप समूह' , 'दमन और दीव', 'दादरा और नागर हवेली', 'दिल्ली','पांडिचेरी', 'लक्षद्वीप'
    )

    countries = (
        'आर्मेनिया', 'यू.के.','फ्रांस', 'अजेपटीना', 'ब्राजील'  ,'ईरान', 'यूनान', 'स्पेन' ,'हमारे' , 'जॉजिऩया', 'लेबनान' , 'सायप्रस', 'सीरिया', 'कनाडा', 'रूस' ,
        'संयुक्त राज्य अमरीका' ,'नेदर्लान्ड', 'फ्रांस','ऑस्ट्रेलिया', 'एंटीगुआ', 'बार्बुडा' ,'अर्जेंटीना', 'आर्मेनिया' ,'ऑस्ट्रिया', 'अज़रबाइजान','बारबाडोस', 'बेलारूस', 'बेल्जियम',
        'बेलीज़' ,'बेनिन', 'बहामास' ,'बहरीन', 'बांग्लादेश', 'भूटान', 'बोलिविया', 'बोस्निया'  ,'हर्जेगोविना', 'बोत्सवाना' , 'ब्राजील' ,'ब्रुनेई' ,'बुल्गारिया', 'बुर्किना', 'फ़ासो',
        'बर्मा', 'बुरूंडी','डोमिनिकन रिपब्लिक','गिनिया', 'टीमोर','फ़िनलैंड','गेबोन', 'गाम्बिया', 'जर्मनी', 'जार्जिया ग्रेनेडा','घाना' ,'यूनान' ,'ग्रेट ब्रिटेन', 'हंगरी',
        'भारत', 'इराक', 'आयरलैंड', 'इंडोनेशिया' , 'इसराइल' , 'आइलैंड', 'ईरान' ,'इटली','जमैका' ,'जॉर्डन','जापान','क़जाख़स्तान', 'केन्या', 'किरिबाती',  'दक्षिण कोरिया', 'लातविया',
        'लाओस' , 'उत्तर कोरिया', 'दक्षिण कोसोवो', 'कुवैत', 'लेबनान', 'लिचटीनस्टीन', 'लिथुआनिया' ,'लक्समबर्ग', 'लीबिया' ,'लाइबेरिया', 'लेसोथो',
        'नेपाल' ,'न्यूजीलैंड', 'निकारागुआ', 'नाइजर', 'नाउरू','लुसिया', 'रूस',  'रोमानिया', 'अरब', 'अमीरात', 'यूएई' ,'युगांडा', 'यूक्रेन', 'उरूग्वे', 
        'उज़बेकिस्तान', 'यूनाइटेड किंगडम', 'वानुआतू', 'वेटिकन सिटी' , 'वेनेजुएला',  'पश्चिमी सहारा'  , 'वियतनाम', 'यमन', 'ज़ायर' , 'जाबम्बया', 'जिम्बाब्वे' 
    )

    @classmethod
    def city_name(cls):
        return cls.random_element(cls.cities)

    @classmethod
    def state(cls):
        return cls.random_element(cls.states)
