/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfoWithAnnotation;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfoWithTypeAnnotation;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationInfo;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FieldInfo
extends ClassFileStruct
implements IBinaryField,
Comparable {
    protected int accessFlags = -1;
    protected int attributeBytes;
    protected Constant constant;
    protected char[] descriptor;
    protected char[] name;
    protected char[] signature;
    protected int signatureUtf8Offset = -1;
    protected long tagBits;
    protected Object wrappedConstantValue;

    public static FieldInfo createField(byte[] byArray, int[] nArray, int n) {
        FieldInfo fieldInfo = new FieldInfo(byArray, nArray, n);
        int n2 = fieldInfo.u2At(6);
        int n3 = 8;
        ClassFileStruct[] classFileStructArray = null;
        ClassFileStruct[] classFileStructArray2 = null;
        for (int i = 0; i < n2; ++i) {
            int n4 = fieldInfo.constantPoolOffsets[fieldInfo.u2At(n3)] - fieldInfo.structOffset;
            char[] cArray = fieldInfo.utf8At(n4 + 3, fieldInfo.u2At(n4 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        fieldInfo.signatureUtf8Offset = fieldInfo.constantPoolOffsets[fieldInfo.u2At(n3 + 6)] - fieldInfo.structOffset;
                        break;
                    }
                    case 'R': {
                        ClassFileStruct[] classFileStructArray3;
                        int n5;
                        AnnotationInfo[] annotationInfoArray = null;
                        TypeAnnotationInfo[] typeAnnotationInfoArray = null;
                        if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                            annotationInfoArray = fieldInfo.decodeAnnotations(n3, true);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                            annotationInfoArray = fieldInfo.decodeAnnotations(n3, false);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName)) {
                            typeAnnotationInfoArray = fieldInfo.decodeTypeAnnotations(n3, true);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName)) {
                            typeAnnotationInfoArray = fieldInfo.decodeTypeAnnotations(n3, false);
                        }
                        if (annotationInfoArray != null) {
                            if (classFileStructArray == null) {
                                classFileStructArray = annotationInfoArray;
                                break;
                            }
                            n5 = classFileStructArray.length;
                            classFileStructArray3 = new AnnotationInfo[n5 + annotationInfoArray.length];
                            System.arraycopy(classFileStructArray, 0, classFileStructArray3, 0, n5);
                            System.arraycopy(annotationInfoArray, 0, classFileStructArray3, n5, annotationInfoArray.length);
                            classFileStructArray = classFileStructArray3;
                            break;
                        }
                        if (typeAnnotationInfoArray == null) break;
                        if (classFileStructArray2 == null) {
                            classFileStructArray2 = typeAnnotationInfoArray;
                            break;
                        }
                        n5 = classFileStructArray2.length;
                        classFileStructArray3 = new TypeAnnotationInfo[n5 + typeAnnotationInfoArray.length];
                        System.arraycopy(classFileStructArray2, 0, classFileStructArray3, 0, n5);
                        System.arraycopy(typeAnnotationInfoArray, 0, classFileStructArray3, n5, typeAnnotationInfoArray.length);
                        classFileStructArray2 = classFileStructArray3;
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + fieldInfo.u4At(n3 + 2)));
        }
        fieldInfo.attributeBytes = n3;
        if (classFileStructArray2 != null) {
            return new FieldInfoWithTypeAnnotation(fieldInfo, (AnnotationInfo[])classFileStructArray, (TypeAnnotationInfo[])classFileStructArray2);
        }
        if (classFileStructArray != null) {
            return new FieldInfoWithAnnotation(fieldInfo, (AnnotationInfo[])classFileStructArray);
        }
        return fieldInfo;
    }

    protected FieldInfo(byte[] byArray, int[] nArray, int n) {
        super(byArray, nArray, n);
    }

    private AnnotationInfo[] decodeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            int n3 = n + 8;
            AnnotationInfo[] annotationInfoArray = null;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                AnnotationInfo annotationInfo = new AnnotationInfo(this.reference, this.constantPoolOffsets, n3 + this.structOffset, bl, false);
                n3 += annotationInfo.readOffset;
                long l = annotationInfo.standardAnnotationTagBits;
                if (l != 0L) {
                    this.tagBits |= l;
                    continue;
                }
                if (annotationInfoArray == null) {
                    annotationInfoArray = new AnnotationInfo[n2 - i];
                }
                annotationInfoArray[n4++] = annotationInfo;
            }
            if (annotationInfoArray != null) {
                if (n4 != annotationInfoArray.length) {
                    AnnotationInfo[] annotationInfoArray2 = annotationInfoArray;
                    annotationInfoArray = new AnnotationInfo[n4];
                    System.arraycopy(annotationInfoArray2, 0, annotationInfoArray, 0, n4);
                }
                return annotationInfoArray;
            }
        }
        return null;
    }

    TypeAnnotationInfo[] decodeTypeAnnotations(int n, boolean bl) {
        int n2 = this.u2At(n + 6);
        if (n2 > 0) {
            int n3 = n + 8;
            TypeAnnotationInfo[] typeAnnotationInfoArray = new TypeAnnotationInfo[n2];
            for (int i = 0; i < n2; ++i) {
                TypeAnnotationInfo typeAnnotationInfo = new TypeAnnotationInfo(this.reference, this.constantPoolOffsets, n3 + this.structOffset, bl, false);
                n3 += typeAnnotationInfo.readOffset;
                typeAnnotationInfoArray[i] = typeAnnotationInfo;
            }
            return typeAnnotationInfoArray;
        }
        return null;
    }

    public int compareTo(Object object) {
        return new String(this.getName()).compareTo(new String(((FieldInfo)object).getName()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof FieldInfo)) {
            return false;
        }
        return CharOperation.equals(this.getName(), ((FieldInfo)object).getName());
    }

    public int hashCode() {
        return CharOperation.hashCode(this.getName());
    }

    @Override
    public Constant getConstant() {
        if (this.constant == null) {
            this.readConstantAttribute();
        }
        return this.constant;
    }

    @Override
    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    @Override
    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    @Override
    public char[] getName() {
        if (this.name == null) {
            int n = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.name;
    }

    @Override
    public long getTagBits() {
        return this.tagBits;
    }

    @Override
    public char[] getTypeName() {
        if (this.descriptor == null) {
            int n = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.descriptor = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.descriptor;
    }

    @Override
    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    @Override
    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }

    public Object getWrappedConstantValue() {
        if (this.wrappedConstantValue == null && this.hasConstant()) {
            Constant constant = this.getConstant();
            switch (constant.typeID()) {
                case 10: {
                    this.wrappedConstantValue = new Integer(constant.intValue());
                    break;
                }
                case 3: {
                    this.wrappedConstantValue = new Byte(constant.byteValue());
                    break;
                }
                case 4: {
                    this.wrappedConstantValue = new Short(constant.shortValue());
                    break;
                }
                case 2: {
                    this.wrappedConstantValue = new Character(constant.charValue());
                    break;
                }
                case 9: {
                    this.wrappedConstantValue = new Float(constant.floatValue());
                    break;
                }
                case 8: {
                    this.wrappedConstantValue = new Double(constant.doubleValue());
                    break;
                }
                case 5: {
                    this.wrappedConstantValue = Util.toBoolean(constant.booleanValue());
                    break;
                }
                case 7: {
                    this.wrappedConstantValue = new Long(constant.longValue());
                    break;
                }
                case 11: {
                    this.wrappedConstantValue = constant.stringValue();
                }
            }
        }
        return this.wrappedConstantValue;
    }

    public boolean hasConstant() {
        return this.getConstant() != Constant.NotAConstant;
    }

    protected void initialize() {
        this.getModifiers();
        this.getName();
        this.getConstant();
        this.getTypeName();
        this.getGenericSignature();
        this.reset();
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readConstantAttribute() {
        int n = this.u2At(6);
        int n2 = 8;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n3 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n3 + 3, this.u2At(n3 + 1));
            if (CharOperation.equals(cArray, AttributeNamesConstants.ConstantValueName)) {
                bl = true;
                int n4 = this.constantPoolOffsets[this.u2At(n2 + 6)] - this.structOffset;
                block0 : switch (this.u1At(n4)) {
                    case 3: {
                        char[] cArray2 = this.getTypeName();
                        if (cArray2.length == 1) {
                            switch (cArray2[0]) {
                                case 'Z': {
                                    this.constant = BooleanConstant.fromValue(this.i4At(n4 + 1) == 1);
                                    break block0;
                                }
                                case 'I': {
                                    this.constant = IntConstant.fromValue(this.i4At(n4 + 1));
                                    break block0;
                                }
                                case 'C': {
                                    this.constant = CharConstant.fromValue((char)this.i4At(n4 + 1));
                                    break block0;
                                }
                                case 'B': {
                                    this.constant = ByteConstant.fromValue((byte)this.i4At(n4 + 1));
                                    break block0;
                                }
                                case 'S': {
                                    this.constant = ShortConstant.fromValue((short)this.i4At(n4 + 1));
                                    break block0;
                                }
                            }
                            this.constant = Constant.NotAConstant;
                            break;
                        }
                        this.constant = Constant.NotAConstant;
                        break;
                    }
                    case 4: {
                        this.constant = FloatConstant.fromValue(this.floatAt(n4 + 1));
                        break;
                    }
                    case 6: {
                        this.constant = DoubleConstant.fromValue(this.doubleAt(n4 + 1));
                        break;
                    }
                    case 5: {
                        this.constant = LongConstant.fromValue(this.i8At(n4 + 1));
                        break;
                    }
                    case 8: {
                        n3 = this.constantPoolOffsets[this.u2At(n4 + 1)] - this.structOffset;
                        this.constant = StringConstant.fromValue(String.valueOf(this.utf8At(n3 + 3, this.u2At(n3 + 1))));
                    }
                }
            }
            n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
        }
        if (!bl) {
            this.constant = Constant.NotAConstant;
        }
    }

    private void readModifierRelatedAttributes() {
        int n = this.u2At(6);
        int n2 = 8;
        for (int i = 0; i < n; ++i) {
            int n3 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n3 + 3, this.u2At(n3 + 1));
            if (cArray.length != 0) {
                switch (cArray[0]) {
                    case 'D': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                    }
                }
            }
            n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
        }
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public void throwFormatException() throws ClassFormatException {
        throw new ClassFormatException(17);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void toStringContent(StringBuffer stringBuffer) {
        int n = this.getModifiers();
        stringBuffer.append('{').append(((n & 0x100000) != 0 ? "deprecated " : Util.EMPTY_STRING) + ((n & 1) == 1 ? "public " : Util.EMPTY_STRING) + ((n & 2) == 2 ? "private " : Util.EMPTY_STRING) + ((n & 4) == 4 ? "protected " : Util.EMPTY_STRING) + ((n & 8) == 8 ? "static " : Util.EMPTY_STRING) + ((n & 0x10) == 16 ? "final " : Util.EMPTY_STRING) + ((n & 0x40) == 64 ? "volatile " : Util.EMPTY_STRING) + ((n & 0x80) == 128 ? "transient " : Util.EMPTY_STRING)).append(this.getTypeName()).append(' ').append(this.getName()).append(' ').append(this.getConstant()).append('}').toString();
    }
}

