/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import gnu.inet.util.LineInputStream;
import gnu.mail.util.BOutputStream;
import gnu.mail.util.Base64InputStream;
import gnu.mail.util.Base64OutputStream;
import gnu.mail.util.QInputStream;
import gnu.mail.util.QOutputStream;
import gnu.mail.util.QPInputStream;
import gnu.mail.util.QPOutputStream;
import gnu.mail.util.UUInputStream;
import gnu.mail.util.UUOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.ParseException;

public class MimeUtility {
    private static HashMap mimeCharsets;
    private static HashMap javaCharsets;
    private static boolean java12;
    private static String defaultJavaCharset;
    private static int part;
    public static final int ALL = -1;
    static final int ALL_ASCII = 1;
    static final int MAJORITY_ASCII = 2;
    static final int MINORITY_ASCII = 3;

    private MimeUtility() {
    }

    public static String getEncoding(DataSource ds) {
        String encoding = "base64";
        InputStream is = null;
        try {
            is = ds.getInputStream();
            ContentType ct = new ContentType(ds.getContentType());
            boolean text = ct.match("text/*");
            switch (MimeUtility.asciiStatus(is, -1, text)) {
                case 1: {
                    encoding = "7bit";
                    break;
                }
                case 2: {
                    if (!text) break;
                    encoding = "quoted-printable";
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return encoding;
    }

    public static String getEncoding(DataHandler dh) {
        String encoding = "base64";
        if (dh.getName() != null) {
            return MimeUtility.getEncoding(dh.getDataSource());
        }
        try {
            ContentType ct = new ContentType(dh.getContentType());
            boolean text = ct.match("text/*");
            AsciiOutputStream aos = new AsciiOutputStream(!text, MimeUtility.encodeeolStrict() && !text);
            try {
                dh.writeTo((OutputStream)aos);
            }
            catch (IOException e) {
                // empty catch block
            }
            switch (aos.status()) {
                case 1: {
                    encoding = "7bit";
                    break;
                }
                case 2: {
                    if (!text) break;
                    encoding = "quoted-printable";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return encoding;
    }

    public static InputStream decode(InputStream is, String encoding) throws MessagingException {
        if (encoding.equalsIgnoreCase("base64")) {
            return new Base64InputStream(is);
        }
        if (encoding.equalsIgnoreCase("quoted-printable")) {
            return new QPInputStream(is);
        }
        if (encoding.equalsIgnoreCase("uuencode") || encoding.equalsIgnoreCase("x-uuencode")) {
            return new UUInputStream(is);
        }
        if (encoding.equalsIgnoreCase("binary") || encoding.equalsIgnoreCase("7bit") || encoding.equalsIgnoreCase("8bit")) {
            return is;
        }
        throw new MessagingException("Unknown encoding: " + encoding);
    }

    public static OutputStream encode(OutputStream os, String encoding) throws MessagingException {
        if (encoding == null) {
            return os;
        }
        if (encoding.equalsIgnoreCase("base64")) {
            return new Base64OutputStream(os);
        }
        if (encoding.equalsIgnoreCase("quoted-printable")) {
            return new QPOutputStream(os);
        }
        if (encoding.equalsIgnoreCase("uuencode") || encoding.equalsIgnoreCase("x-uuencode")) {
            return new UUOutputStream(os);
        }
        if (encoding.equalsIgnoreCase("binary") || encoding.equalsIgnoreCase("7bit") || encoding.equalsIgnoreCase("8bit")) {
            return os;
        }
        throw new MessagingException("Unknown encoding: " + encoding);
    }

    public static OutputStream encode(OutputStream os, String encoding, String filename) throws MessagingException {
        if (encoding == null) {
            return os;
        }
        if (encoding.equalsIgnoreCase("base64")) {
            return new Base64OutputStream(os);
        }
        if (encoding.equalsIgnoreCase("quoted-printable")) {
            return new QPOutputStream(os);
        }
        if (encoding.equalsIgnoreCase("uuencode") || encoding.equalsIgnoreCase("x-uuencode")) {
            return new UUOutputStream(os, filename);
        }
        if (encoding.equalsIgnoreCase("binary") || encoding.equalsIgnoreCase("7bit") || encoding.equalsIgnoreCase("8bit")) {
            return os;
        }
        throw new MessagingException("Unknown encoding: " + encoding);
    }

    public static String encodeText(String text) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(text, null, null);
    }

    public static String encodeText(String text, String charset, String encoding) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(text, charset, encoding, false);
    }

    public static String decodeText(String etext) throws UnsupportedEncodingException {
        String delimiters = "\t\n\r ";
        if (etext.indexOf("=?") == -1) {
            return etext;
        }
        StringTokenizer st = new StringTokenizer(etext, delimiters, true);
        StringBuffer buffer = new StringBuffer();
        StringBuffer extra = new StringBuffer();
        boolean decoded = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            char c = token.charAt(0);
            if (delimiters.indexOf(c) > -1) {
                extra.append(c);
                continue;
            }
            try {
                token = MimeUtility.decodeWord(token);
                if (!decoded && extra.length() > 0) {
                    buffer.append(extra);
                }
                decoded = true;
            }
            catch (ParseException e) {
                if (!MimeUtility.decodetextStrict()) {
                    token = MimeUtility.decodeInnerText(token);
                }
                if (extra.length() > 0) {
                    buffer.append(extra);
                }
                decoded = false;
            }
            buffer.append(token);
            extra.setLength(0);
        }
        return buffer.toString();
    }

    public static String encodeWord(String text) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(text, null, null);
    }

    public static String encodeWord(String text, String charset, String encoding) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(text, charset, encoding, true);
    }

    private static String encodeWord(String text, String charset, String encoding, boolean word) throws UnsupportedEncodingException {
        boolean bEncoding;
        String javaCharset;
        if (MimeUtility.asciiStatus(text.getBytes()) == 1) {
            return text;
        }
        if (charset == null) {
            javaCharset = MimeUtility.getDefaultJavaCharset();
            charset = MimeUtility.mimeCharset(javaCharset);
        } else {
            javaCharset = MimeUtility.javaCharset(charset);
        }
        if (encoding == null) {
            byte[] bytes = text.getBytes(javaCharset);
            encoding = MimeUtility.asciiStatus(bytes) != 3 ? "Q" : "B";
        }
        if (encoding.equalsIgnoreCase("B")) {
            bEncoding = true;
        } else if (encoding.equalsIgnoreCase("Q")) {
            bEncoding = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + encoding);
        }
        StringBuffer encodingBuffer = new StringBuffer();
        encodingBuffer.append("=?");
        encodingBuffer.append(charset);
        encodingBuffer.append("?");
        encodingBuffer.append(encoding);
        encodingBuffer.append("?");
        StringBuffer buffer = new StringBuffer();
        MimeUtility.encodeBuffer(buffer, text, javaCharset, bEncoding, 68 - charset.length(), encodingBuffer.toString(), true, word);
        return buffer.toString();
    }

    private static void encodeBuffer(StringBuffer buffer, String text, String charset, boolean bEncoding, int max, String encoding, boolean keepTogether, boolean word) throws UnsupportedEncodingException {
        byte[] bytes = text.getBytes(charset);
        int elen = bEncoding ? BOutputStream.encodedLength(bytes) : QOutputStream.encodedLength(bytes, word);
        int len = text.length();
        if (elen > max && len > 1) {
            MimeUtility.encodeBuffer(buffer, text.substring(0, len / 2), charset, bEncoding, max, encoding, keepTogether, word);
            MimeUtility.encodeBuffer(buffer, text.substring(len / 2, len), charset, bEncoding, max, encoding, false, word);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FilterOutputStream os = null;
            os = bEncoding ? new BOutputStream(bos) : new QOutputStream((OutputStream)bos, word);
            try {
                ((OutputStream)os).write(bytes);
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                // empty catch block
            }
            bytes = bos.toByteArray();
            if (!keepTogether) {
                buffer.append("\r\n ");
            }
            buffer.append(encoding);
            for (int i = 0; i < bytes.length; ++i) {
                buffer.append((char)bytes[i]);
            }
            buffer.append("?=");
        }
    }

    public static String decodeWord(String text) throws ParseException, UnsupportedEncodingException {
        if (!text.startsWith("=?")) {
            throw new ParseException();
        }
        int start = 2;
        int end = text.indexOf(63, start);
        if (end < 0) {
            throw new ParseException();
        }
        String charset = text.substring(start, end);
        int si = charset.indexOf(42);
        if (si != -1) {
            charset = charset.substring(0, si);
        }
        charset = MimeUtility.javaCharset(charset);
        start = end + 1;
        if ((end = text.indexOf(63, start)) < 0) {
            throw new ParseException();
        }
        String encoding = text.substring(start, end);
        start = end + 1;
        if ((end = text.indexOf("?=", start)) < 0) {
            throw new ParseException();
        }
        text = text.substring(start, end);
        try {
            FilterInputStream is;
            char[] chars = text.toCharArray();
            int len = chars.length;
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                bytes[i] = (byte)chars[i];
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            if (encoding.equalsIgnoreCase("B")) {
                is = new Base64InputStream(bis);
            } else if (encoding.equalsIgnoreCase("Q")) {
                is = new QInputStream(bis);
            } else {
                throw new UnsupportedEncodingException("Unknown encoding: " + encoding);
            }
            len = bis.available();
            bytes = new byte[len];
            len = ((InputStream)is).read(bytes, 0, len);
            String ret = new String(bytes, 0, len, charset);
            if (text.length() > end + 2) {
                String extra = text.substring(end + 2);
                if (!MimeUtility.decodetextStrict()) {
                    extra = MimeUtility.decodeInnerText(extra);
                }
                ret = ret + extra;
            }
            return ret;
        }
        catch (IOException e) {
            throw new ParseException();
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedEncodingException();
        }
    }

    private static boolean encodeeolStrict() {
        try {
            String encodeeolStrict = System.getProperty("mail.mime.encodeeol.strict", "false");
            return Boolean.valueOf(encodeeolStrict);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static boolean decodetextStrict() {
        try {
            String decodetextStrict = System.getProperty("mail.mime.decodetext.strict", "true");
            return Boolean.valueOf(decodetextStrict);
        }
        catch (SecurityException e) {
            return true;
        }
    }

    private static String decodeInnerText(String text) throws UnsupportedEncodingException {
        int end;
        String LD = "=?";
        String RD = "?=";
        int pos = 0;
        StringBuffer buffer = new StringBuffer();
        int start = text.indexOf("=?", pos);
        while (start != -1 && (end = text.indexOf("?=", start + 2)) != -1) {
            buffer.append(text.substring(pos, start));
            pos = end + 2;
            String encoded = text.substring(start, pos);
            try {
                buffer.append(MimeUtility.decodeWord(encoded));
            }
            catch (ParseException e) {
                buffer.append(encoded);
            }
            start = text.indexOf("=?", pos);
        }
        if (buffer.length() > 0) {
            if (pos < text.length()) {
                buffer.append(text.substring(pos));
            }
            return buffer.toString();
        }
        return text;
    }

    public static String quote(String text, String specials) {
        int len = text.length();
        boolean needsQuotes = false;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '\r' || c == '\"' || c == '\\') {
                StringBuffer buffer = new StringBuffer(len + 3);
                buffer.append('\"');
                for (int j = 0; j < len; ++j) {
                    char c2 = text.charAt(j);
                    if (c2 == '\"' || c2 == '\\' || c2 == '\r' || c2 == '\n') {
                        buffer.append('\\');
                    }
                    buffer.append(c2);
                }
                buffer.append('\"');
                return buffer.toString();
            }
            if (c >= ' ' && c <= '\u007f' && specials.indexOf(c) < 0) continue;
            needsQuotes = true;
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer(len + 2);
            buffer.append('\"');
            buffer.append(text);
            buffer.append('\"');
            return buffer.toString();
        }
        return text;
    }

    private static void parse(HashMap mappings, LineInputStream lin) {
        block4: while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = lin.readLine()) == null || line.startsWith("--") && line.endsWith("--")) {
                        return;
                    }
                    if (line.trim().length() == 0 || line.startsWith("#")) continue;
                    StringTokenizer st = new StringTokenizer(line, "\t ");
                    try {
                        String key = st.nextToken();
                        String value = st.nextToken();
                        mappings.put(key.toLowerCase(), value);
                        continue block4;
                    }
                    catch (NoSuchElementException e2) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public static String javaCharset(String charset) {
        if (mimeCharsets == null || charset == null) {
            return charset;
        }
        String jc = (String)mimeCharsets.get(charset.toLowerCase());
        if (jc != null) {
            if (java12) {
                return jc;
            }
            String mc = (String)javaCharsets.get(jc.toLowerCase());
            return mc != null ? mc : charset;
        }
        return charset;
    }

    public static String mimeCharset(String charset) {
        if (javaCharsets == null || charset == null) {
            return charset;
        }
        String mc = (String)javaCharsets.get(charset.toLowerCase());
        return mc != null ? mc : charset;
    }

    public static String getDefaultJavaCharset() {
        block4: {
            if (defaultJavaCharset == null) {
                try {
                    defaultJavaCharset = System.getProperty("mail.mime.charset");
                    if (defaultJavaCharset == null) {
                        defaultJavaCharset = System.getProperty("file.encoding", "UTF-8");
                    }
                }
                catch (SecurityException e) {
                    InputStreamReader isr = new InputStreamReader(new InputStream(){

                        @Override
                        public int read() {
                            return 0;
                        }
                    });
                    defaultJavaCharset = isr.getEncoding();
                    if (defaultJavaCharset != null) break block4;
                    defaultJavaCharset = "UTF-8";
                }
            }
        }
        return MimeUtility.javaCharset(defaultJavaCharset);
    }

    static String getUniqueBoundaryValue() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("----=_Part_");
        buffer.append(part++);
        buffer.append("_");
        buffer.append(Math.abs(buffer.hashCode()));
        buffer.append('.');
        buffer.append(System.currentTimeMillis());
        return buffer.toString();
    }

    static String getUniqueMessageIDValue(Session session) {
        InternetAddress localAddress = InternetAddress.getLocalAddress(session);
        String address = localAddress != null ? localAddress.getAddress() : "javamailuser@localhost";
        StringBuffer buffer = new StringBuffer();
        buffer.append(Math.abs(MimeUtility.getUniqueBoundaryValue().hashCode()));
        buffer.append('.');
        buffer.append(System.currentTimeMillis());
        buffer.append('.');
        buffer.append("JavaMail.");
        buffer.append(address);
        return buffer.toString();
    }

    static int asciiStatus(byte[] bytes) {
        int asciiCount = 0;
        int nonAsciiCount = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (MimeUtility.isAscii(bytes[i])) {
                ++asciiCount;
                continue;
            }
            ++nonAsciiCount;
        }
        if (nonAsciiCount == 0) {
            return 1;
        }
        return asciiCount <= nonAsciiCount ? 3 : 2;
    }

    static int asciiStatus(InputStream is, int len, boolean text) {
        int asciiCount = 0;
        int nonAsciiCount = 0;
        int blockLen = 4096;
        int lineLen = 0;
        boolean islong = false;
        byte[] bytes = null;
        if (len != 0) {
            blockLen = len != -1 ? Math.min(len, 4096) : 4096;
            bytes = new byte[blockLen];
        }
        while (len != 0) {
            int readLen;
            try {
                readLen = is.read(bytes, 0, blockLen);
                if (readLen < 0) break;
                for (int i = 0; i < readLen; ++i) {
                    int c = bytes[i] & 0xFF;
                    if (c == 13 || c == 10) {
                        lineLen = 0;
                    } else if (++lineLen > 998) {
                        islong = true;
                    }
                    if (MimeUtility.isAscii(c)) {
                        ++asciiCount;
                        continue;
                    }
                    if (text) {
                        return 3;
                    }
                    ++nonAsciiCount;
                }
            }
            catch (IOException e) {
                break;
            }
            if (len == -1) continue;
            len -= readLen;
        }
        if (len == 0 && text) {
            return 3;
        }
        if (nonAsciiCount == 0) {
            return !islong ? 1 : 2;
        }
        return asciiCount <= nonAsciiCount ? 3 : 2;
    }

    private static final boolean isAscii(int c) {
        if (c < 0) {
            c += 255;
        }
        return c < 128 && c > 31 || c == 13 || c == 10 || c == 9;
    }

    public static String fold(int used, String s) {
        int i;
        int len = s.length();
        int k = Math.min(76 - used, len);
        if (k == len) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        do {
            if ((i = MimeUtility.whitespaceIndexOf(s, k, -1, len)) == -1) {
                i = MimeUtility.whitespaceIndexOf(s, k, 1, len);
            }
            if (i != -1) {
                buf.append(s.substring(0, i));
                buf.append('\n');
                s = s.substring(i);
                len -= i;
            }
            k = Math.min(76, len);
        } while (i != -1);
        buf.append(s);
        return buf.toString();
    }

    private static int whitespaceIndexOf(String s, int offset, int step, int len) {
        for (int i = offset; i > 0 && i < len; i += step) {
            char c = s.charAt(i);
            if (c != ' ' && c != '\t') continue;
            return i;
        }
        return -1;
    }

    public static String unfold(String s) {
        StringBuffer buf = null;
        int start = 0;
        int len = s.length();
        for (int end = start; end < len; ++end) {
            char d;
            char c = s.charAt(end);
            if (c != '\n' || end >= len - 1 || (d = s.charAt(end + 1)) != ' ' && d != '\t') continue;
            String head = s.substring(start, end);
            if (buf == null) {
                buf = new StringBuffer();
            }
            buf.append(head);
            start = end + 1;
        }
        if (buf == null) {
            return s;
        }
        buf.append(s.substring(start));
        return buf.toString();
    }

    static {
        String mappings = "/META-INF/javamail.charset.map";
        InputStream in = MimeUtility.class.getResourceAsStream(mappings);
        if (in != null) {
            mimeCharsets = new HashMap(10);
            javaCharsets = new HashMap(20);
            LineInputStream lin = new LineInputStream(in);
            MimeUtility.parse(mimeCharsets, lin);
            MimeUtility.parse(javaCharsets, lin);
        }
        try {
            String version = System.getProperty("java.version");
            java12 = version.startsWith("1.2") || version.startsWith("1.1");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        part = 0;
    }

    static class AsciiOutputStream
    extends OutputStream {
        static final int LF = 10;
        static final int CR = 13;
        private boolean strict;
        private boolean eolStrict;
        private int asciiCount = 0;
        private int nonAsciiCount = 0;
        private int ret;
        private int len;
        private int last = -1;
        private boolean islong = false;
        private boolean eolCheckFailed = false;

        public AsciiOutputStream(boolean strict, boolean eolStrict) {
            this.strict = strict;
            this.eolStrict = eolStrict;
        }

        @Override
        public void write(int c) throws IOException {
            this.check(c);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.write(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            length += offset;
            for (int i = offset; i < length; ++i) {
                this.check(bytes[i]);
            }
        }

        private final void check(int c) throws IOException {
            if (this.eolStrict && (this.last == 13 && (c &= 0xFF) != 10 || this.last != 13 && c == 10)) {
                this.eolCheckFailed = true;
            }
            if (c == 13 || c == 10) {
                this.len = 0;
            } else {
                ++this.len;
                if (this.len > 998) {
                    this.islong = true;
                }
            }
            if (c > 127) {
                ++this.nonAsciiCount;
                if (this.strict) {
                    this.ret = 3;
                    throw new EOFException();
                }
            } else {
                ++this.asciiCount;
            }
            this.last = c;
        }

        int status() {
            if (this.ret != 0) {
                return this.ret;
            }
            if (this.eolCheckFailed) {
                return 3;
            }
            if (this.nonAsciiCount == 0) {
                return !this.islong ? 1 : 2;
            }
            return this.asciiCount <= this.nonAsciiCount ? 2 : 3;
        }
    }
}

