/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.generic.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.gradle.foundation.visitors.AllProjectsAndTasksVisitor;
import org.gradle.foundation.visitors.UniqueNameProjectAndTaskVisitor;
import org.gradle.gradleplugin.foundation.GradlePluginLord;
import org.gradle.gradleplugin.foundation.filters.BasicFilterEditor;
import org.gradle.gradleplugin.foundation.filters.BasicProjectAndTaskFilter;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingExportInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.SwingImportInteraction;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;
import org.gradle.gradleplugin.userinterface.swing.generic.filter.AbstractFilterEditorPanel;

public class ProjectAndTaskFilterDialog {
    private JDialog dialog;
    private JPanel mainPanel;
    private TaskFilterEditorPanel taskFilterEditorPanel;
    private ProjectFilterEditorPanel projectFilterEditorPanel;
    private JCheckBox filterOutTasksWithNoDescriptionCheckBox;
    private BasicFilterEditor editor;
    private GradlePluginLord gradlePluginLord;
    private boolean saveResults;

    public ProjectAndTaskFilterDialog(Window parent, GradlePluginLord gradlePluginLord) {
        this.gradlePluginLord = gradlePluginLord;
        this.dialog = Utility.createDialog(parent, "Filter", true);
        this.setupUI();
    }

    public BasicProjectAndTaskFilter show(BasicProjectAndTaskFilter filter) {
        this.editor = new BasicFilterEditor(filter);
        if (this.mainPanel == null) {
            this.setupUI();
        }
        this.populate();
        this.taskFilterEditorPanel.enableAppropriately();
        this.projectFilterEditorPanel.enableAppropriately();
        this.dialog.setVisible(true);
        if (this.saveResults) {
            return this.editor.createFilter();
        }
        return null;
    }

    private void setupUI() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.dialog.getContentPane().add(this.mainPanel);
        this.mainPanel.add(this.createOptionsPanel(), "North");
        this.mainPanel.add(this.createCenterPanel(), "Center");
        this.mainPanel.add(this.createOkCancelPanel(), "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProjectAndTaskFilterDialog.this.close(false);
            }
        });
        this.dialog.setSize(600, 750);
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
    }

    private Component createOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JButton importButton = new JButton(new AbstractAction("Import..."){

            public void actionPerformed(ActionEvent e) {
                ProjectAndTaskFilterDialog.this.importFilter();
            }
        });
        JButton exportButton = new JButton(new AbstractAction("Export..."){

            public void actionPerformed(ActionEvent e) {
                ProjectAndTaskFilterDialog.this.exportFilter();
            }
        });
        this.filterOutTasksWithNoDescriptionCheckBox = new JCheckBox(new AbstractAction("Hide Tasks With No Description"){

            public void actionPerformed(ActionEvent e) {
                ProjectAndTaskFilterDialog.this.filterOutTasksWithNoDescription();
            }
        });
        panel.add(this.filterOutTasksWithNoDescriptionCheckBox);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(importButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(exportButton);
        panel.add(Box.createHorizontalGlue());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        return panel;
    }

    private Component createOkCancelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JButton okButton = new JButton(new AbstractAction("OK"){

            public void actionPerformed(ActionEvent e) {
                ProjectAndTaskFilterDialog.this.close(true);
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                ProjectAndTaskFilterDialog.this.close(false);
            }
        });
        panel.add(Box.createHorizontalGlue());
        panel.add(okButton);
        panel.add(Box.createHorizontalStrut(10));
        panel.add(cancelButton);
        panel.add(Box.createHorizontalGlue());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        return panel;
    }

    private Component createCenterPanel() {
        JPanel outterPanel = new JPanel();
        outterPanel.setLayout(new BoxLayout(outterPanel, 1));
        JPanel projectPanel = new JPanel(new BorderLayout());
        JPanel taskPanel = new JPanel(new BorderLayout());
        projectPanel.add(this.createProjectPanel(), "Center");
        taskPanel.add(this.createTasksPanel(), "Center");
        projectPanel.setBorder(BorderFactory.createTitledBorder("Projects"));
        taskPanel.setBorder(BorderFactory.createTitledBorder("Tasks"));
        outterPanel.add(projectPanel);
        outterPanel.add(Box.createVerticalStrut(10));
        outterPanel.add(taskPanel);
        return outterPanel;
    }

    private Component createTasksPanel() {
        this.taskFilterEditorPanel = new TaskFilterEditorPanel();
        return this.taskFilterEditorPanel.getComponent();
    }

    private Component createProjectPanel() {
        this.projectFilterEditorPanel = new ProjectFilterEditorPanel();
        return this.projectFilterEditorPanel.getComponent();
    }

    private void close(boolean saveResults) {
        this.saveResults = saveResults;
        this.dialog.setVisible(false);
    }

    private void importFilter() {
        if (this.editor.importFromFile(new SwingImportInteraction(this.dialog))) {
            this.taskFilterEditorPanel.getComponent().repaint();
            this.projectFilterEditorPanel.getComponent().repaint();
        }
    }

    private void exportFilter() {
        this.editor.exportToFile(new SwingExportInteraction(this.dialog));
    }

    private void populate() {
        UniqueNameProjectAndTaskVisitor visitor = new UniqueNameProjectAndTaskVisitor();
        AllProjectsAndTasksVisitor.visitProjectAndTasks(this.gradlePluginLord.getProjects(), visitor, null);
        List<String> taskNames = visitor.getSortedTaskNames();
        List<String> projectNames = visitor.getSortedProjectNames();
        this.taskFilterEditorPanel.populate(taskNames);
        this.projectFilterEditorPanel.populate(projectNames);
        this.filterOutTasksWithNoDescriptionCheckBox.setSelected(this.editor.filterOutTasksWithNoDescription());
    }

    private void filterOutTasksWithNoDescription() {
        this.editor.setFilterOutTasksWithNoDescription(this.filterOutTasksWithNoDescriptionCheckBox.isSelected());
        this.taskFilterEditorPanel.getComponent().repaint();
        this.projectFilterEditorPanel.getComponent().repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectFilterEditorPanel
    extends AbstractFilterEditorPanel {
        private ProjectFilterEditorPanel() {
        }

        @Override
        protected boolean isAllowed(String item) {
            return ProjectAndTaskFilterDialog.this.editor.doesAllowProject(item);
        }

        @Override
        protected void hideSelected(List<String> selection) {
            ProjectAndTaskFilterDialog.this.editor.hideProjectsByName(selection);
        }

        @Override
        protected void showSelected(List<String> selection) {
            ProjectAndTaskFilterDialog.this.editor.showProjectsByName(selection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskFilterEditorPanel
    extends AbstractFilterEditorPanel {
        private TaskFilterEditorPanel() {
        }

        @Override
        protected boolean isAllowed(String item) {
            return ProjectAndTaskFilterDialog.this.editor.doesAllowTask(item);
        }

        @Override
        protected void hideSelected(List<String> selection) {
            ProjectAndTaskFilterDialog.this.editor.hideTasksByName(selection);
        }

        @Override
        protected void showSelected(List<String> selection) {
            ProjectAndTaskFilterDialog.this.editor.showTasksByName(selection);
        }
    }
}

