/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.internal.cache.Cache;
import org.gradle.api.internal.cache.CacheAccessSerializer;
import org.gradle.api.internal.cache.MapBackedCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.internal.Factory;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.registry.PersistentDaemonRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonRegistryServices {
    private final File daemonBaseDir;
    private final Cache<File, DaemonRegistry> daemonRegistryCache;
    private static final Map<File, DaemonRegistry> REGISTRY_STORAGE = new HashMap<File, DaemonRegistry>();
    private static final Cache<File, DaemonRegistry> REGISTRY_CACHE = new CacheAccessSerializer<File, DaemonRegistry>(new MapBackedCache<File, DaemonRegistry>(REGISTRY_STORAGE));

    public DaemonRegistryServices(File daemonBaseDir) {
        this(daemonBaseDir, REGISTRY_CACHE);
    }

    DaemonRegistryServices(File daemonBaseDir, Cache<File, DaemonRegistry> daemonRegistryCache) {
        this.daemonBaseDir = daemonBaseDir;
        this.daemonRegistryCache = daemonRegistryCache;
    }

    DaemonDir createDaemonDir() {
        return new DaemonDir(this.daemonBaseDir);
    }

    DaemonRegistry createDaemonRegistry(DaemonDir daemonDir, final FileLockManager fileLockManager) {
        final File daemonRegistryFile = daemonDir.getRegistry();
        return this.daemonRegistryCache.get(daemonRegistryFile, new Factory<DaemonRegistry>(){

            @Override
            public DaemonRegistry create() {
                return new PersistentDaemonRegistry(daemonRegistryFile, fileLockManager);
            }
        });
    }

    Properties createProperties() {
        return System.getProperties();
    }
}

