/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.sources;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.platform.base.ModelInstantiationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class BaseLanguageSourceSet
extends AbstractBuildableModelElement
implements LanguageSourceSetInternal {
    private String name;
    private String fullName;
    private String parentName;
    private String typeName;
    private SourceDirectorySet source;
    private boolean generated;
    private Task generatorTask;
    protected FileResolver fileResolver;
    private static ThreadLocal<SourceSetInfo> nextSourceSetInfo = new ThreadLocal();

    public String getName() {
        return this.name;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getProjectScopedName() {
        return this.fullName;
    }

    @Override
    public String getDisplayName() {
        return String.format("%s '%s:%s'", this.getTypeName(), this.parentName, this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected String getTypeName() {
        return this.typeName;
    }

    @Override
    public void builtBy(Object ... tasks) {
        this.generated = true;
        super.builtBy(tasks);
    }

    @Override
    public void generatedBy(Task generatorTask) {
        this.generatorTask = generatorTask;
    }

    @Override
    public Task getGeneratorTask() {
        return this.generatorTask;
    }

    @Override
    public boolean getMayHaveSources() {
        return this.generated || !this.source.isEmpty();
    }

    @Override
    public SourceDirectorySet getSource() {
        return this.source;
    }

    public static <T extends LanguageSourceSet> T create(Class<? extends LanguageSourceSet> publicType, Class<T> type, String name, String parentName, FileResolver fileResolver) {
        nextSourceSetInfo.set(new SourceSetInfo(name, parentName, publicType.getSimpleName(), fileResolver));
        try {
            LanguageSourceSet languageSourceSet = (LanguageSourceSet)DirectInstantiator.INSTANCE.newInstance(type, new Object[0]);
            return (T)languageSourceSet;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create LanguageSourceSet of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            nextSourceSetInfo.set(null);
        }
    }

    public BaseLanguageSourceSet() {
        this(nextSourceSetInfo.get());
    }

    private BaseLanguageSourceSet(SourceSetInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseLanguageSourceSet is not permitted. Use a LanguageTypeBuilder instead.");
        }
        this.name = info.name;
        this.parentName = info.parentName;
        this.typeName = info.typeName;
        this.fullName = info.parentName + StringUtils.capitalize((String)this.name);
        this.source = new DefaultSourceDirectorySet("source", info.fileResolver);
        this.fileResolver = info.fileResolver;
        super.builtBy(this.source.getBuildDependencies());
    }

    private static class SourceSetInfo {
        final String name;
        final String parentName;
        final String typeName;
        final FileResolver fileResolver;

        private SourceSetInfo(String name, String parentName, String typeName, FileResolver fileResolver) {
            this.name = name;
            this.parentName = parentName;
            this.typeName = typeName;
            this.fileResolver = fileResolver;
        }
    }
}

