/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal;

import org.gradle.api.tasks.Optional;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.play.internal.PlayPlatformRequirement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayPlatformNotationParser {
    private static final NotationParserBuilder<PlatformRequirement> BUILDER = NotationParserBuilder.toType(PlatformRequirement.class).fromCharSequence((NotationConverter)new StringConverter()).converter((NotationConverter)new MapConverter());

    public static NotationParser<Object, PlatformRequirement> parser() {
        return PlayPlatformNotationParser.builder().toComposite();
    }

    private static NotationParserBuilder<PlatformRequirement> builder() {
        return BUILDER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringConverter
    implements NotationConverter<String, PlatformRequirement> {
        StringConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("The name of a Play platform").example("'play-2.3.9'.");
        }

        public void convert(String notation, NotationConvertResult<? super PlatformRequirement> result) throws TypeConversionException {
            result.converted((Object)new DefaultPlatformRequirement(notation));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MapConverter
    extends MapNotationConverter<PlatformRequirement> {
        MapConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Map defining the platform versions").example("[play: '2.3.9', scala:'2.11.4', java: '1.6']");
        }

        protected PlatformRequirement parseMap(@MapKey(value="play") String playVersion, @MapKey(value="scala") @Optional String scalaVersion, @MapKey(value="java") @Optional String javaVersion) {
            return new PlayPlatformRequirement(playVersion, scalaVersion, javaVersion);
        }
    }
}

