/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.io.File;
import org.gradle.api.internal.changedetection.rules.ChangeType;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;

abstract class FileChange
implements TaskStateChange {
    private final String path;
    private final ChangeType change;

    public FileChange(String path, ChangeType change) {
        this.path = path;
        this.change = change;
    }

    public String getMessage() {
        return String.format("%s file %s %s.", this.getFileType(), this.path, this.change.describe());
    }

    public String toString() {
        return this.getMessage();
    }

    protected abstract String getFileType();

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return new File(this.path);
    }

    public boolean isAdded() {
        return this.change == ChangeType.ADDED;
    }

    public boolean isModified() {
        return this.change == ChangeType.MODIFIED;
    }

    public boolean isRemoved() {
        return this.change == ChangeType.REMOVED;
    }
}

