/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.launcher;

import java.io.DataInputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.process.internal.child.EncodedStream;
import org.gradle.process.internal.child.IsolatedApplicationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerContext;

public class IsolatedGradleWorkerMain {
    public void run() throws Exception {
        DataInputStream instr = new DataInputStream(new EncodedStream.EncodedInput(System.in));
        int applicationClassPathLength = instr.readInt();
        ArrayList<URI> classpath = new ArrayList<URI>();
        for (int i = 0; i < applicationClassPathLength; ++i) {
            String uri = instr.readUTF();
            classpath.add(new URI(uri));
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(instr);
        Action worker = (Action)objectInputStream.readObject();
        new IsolatedApplicationClassLoaderWorker(classpath, (Action<WorkerContext>)worker).call();
    }

    public static void main(String[] args) {
        try {
            new IsolatedGradleWorkerMain().run();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

